C--COMMON BLOCK INCLUDE FILE FOR HYPOINVERSE

C--COMMON.INC IS INCLUDED IN THE BLOCK DATA.

C--SHORT INTEGER AND LOGICAL DECLARATIONS
      INCLUDE 'integer.for'     !SUN & VAX VERSION. USES *2 LENGTHS

C--GENERAL PARAMETERS
      LOGICAL    SUBMOD
      COMMON /D/ SUBMOD         !F=NORMAL PROGRAM, T=SUBROUTINE VERSION
C     CHARACTER  CPADD*2
C     COMMON /C/ CPADD          !DUMMY PADDING IF NEEDED
      CHARACTER  CM*3
      COMMON /C/ CM             !CURRENT COMMAND NAME
      CHARACTER  INST*132
      COMMON /C/ INST           !CURRENT COMMAND PARAMETERS OR PHASE CARD
      CHARACTER  CTEMP*1
      COMMON /C/ CTEMP          !CHARACTER TEMPORARY
      CHARACTER  TERM*80
      COMMON /C/ TERM           !TERMINATOR (INSTRUCTION) CARD
      CHARACTER  IS*1
      COMMON /C/ IS             !CHARACTER TEMPORARY, 'S' FOR SOUTH LAT
      CHARACTER  IE*1
      COMMON /C/ IE             !CHARACTER TEMPORARY, 'E' FOR EAST LON
      REAL       PI
      COMMON /D/ PI             !PI
      REAL       RDEG
      COMMON /D/ RDEG           !DEGREES PER RADIAN
      INTEGER    INP
      COMMON /D/ INP            !COMMAND INPUT UNIT NUMBER
      INTEGER    ISTAT
      COMMON /D/ ISTAT          !A STATUS FLAG SET BY HYCMD FOR HYP
      INTEGER    ISTAT2
      COMMON /D/ ISTAT2         !A STATUS FLAG SET BY HYOPEN FOR HYP
C--DECLARED IN INTEGER.FOR
      COMMON /D/ IRES           !STATUS FLAG FROM HYPOINV & CUSP SUBROUTINES
C--DECLARED IN INTEGER.FOR
      COMMON /D/ IPADD          !DUMMY PADDING
      LOGICAL    LTBIG
      COMMON /D/ LTBIG          !BIG EVENT FLAG (HYPHS TO HYLST)
      CHARACTER  RUNLAB*1
      COMMON /C/ RUNLAB         !1-LETTER LABEL FOR ENTIRE RUN (LAB)
      LOGICAL    LP153
      COMMON /D/ LP153          !T=PASS COL 153 THRU, F=RUNLAB (LAB)
      CHARACTER  CP1*1
      COMMON /C/ CP1            !PASS THRU LABEL, IE AUTHORITY
      CHARACTER  CP2*1
      COMMON /C/ CP2            !PASS THRU LABEL, IE VERSION
      CHARACTER  CP3*1
      COMMON /C/ CP3            !PASS THRU LABEL, IE REVISION
      LOGICAL    DEPFIX
      COMMON /D/ DEPFIX         !INDIVIDUAL FLAG TO FIX ONE DEPTH
      LOGICAL    DEPFIXA
      COMMON /D/ DEPFIXA        !FLAG TO FIX ALL DEPTHS (ZTR)
      LOGICAL    HYPOFIX
      COMMON /D/ HYPOFIX        !INDIVIDUAL FLAG TO FIX ONE HYPOCENTER
      LOGICAL    ALLFIX
      COMMON /D/ ALLFIX         !INDIVIDUAL FLAG TO FIX ONE HYPO & ORIGIN
      CHARACTER  FIXCHR*1
      COMMON /C/ FIXCHR         !CHARACTER USED TO SIGNAL HYPOCENTER FIX
      CHARACTER  CDOMAN*2
      COMMON /C/ CDOMAN         !CODE FOR PROCESSING DOMAIN (IE NC) (VER)
      CHARACTER  CPVERS*2
      COMMON /C/ CPVERS         !CODE FOR PROCESSING VERSION (IE 01) (VER)

C--FILES AND OUTPUT CONTROLS
C--DEFINING COMMAND NAMES ARE IN PARENTHESES
      CHARACTER  SUMFIL*60
      COMMON /C/ SUMFIL         !HYPOINVERSE SUMMARY OUTPUT FILENAME (SUM)
      CHARACTER  ARCFIL*60
      COMMON /C/ ARCFIL         !ARCHIVE OUTPUT FILENAME (ARC)
      CHARACTER  PRTFIL*60
      COMMON /C/ PRTFIL         !PRINT OUTPUT FILENAME (PRT)
      LOGICAL    LSUM
      COMMON /D/ LSUM           !TRUE TO OUTPUT SUMMARY DATA (SUM)
      INTEGER    IH71S
      COMMON /D/ IH71S          !SUMMARY FORMAT 1=HI 2=H71 (H71)
      INTEGER    IH71T
      COMMON /D/ IH71T          !TERMINATOR FORMAT 1=HI 2=H71 3=HDR TRIAL (H71)
      LOGICAL    LARC
      COMMON /D/ LARC           !TRUE TO OUTPUT ARCHIVE DATA (ARC)
      LOGICAL    LPRT
      COMMON /D/ LPRT           !TRUE TO OUTPUT A PRINTOUT FILE (PRT)
      LOGICAL    LMAG
      COMMON /D/ LMAG           !TRUE TO OUTPUT MAGNITUDE DATA FILE (MFL)
      LOGICAL    LERR
      COMMON /D/ LERR           !TRUE TO OUTPUT ERROR MESSAGES TO TERMINAL (ERF)
      LOGICAL    LCUSP
      COMMON /D/ LCUSP          !TRUE IF READING FROM CUSP MEM FILES (COP)
      CHARACTER  FORID*30
      COMMON /C/ FORID          !CUSP ID READING FORMAT (FID)
      CHARACTER  STAFIL*60
      COMMON /C/ STAFIL         !STATION INPUT FILENAME (STA)
      CHARACTER  BSTAFL*60
      COMMON /C/ BSTAFL         !BINARY STATION SNAPSHOT (WST,RST)
      LOGICAL    LBSTA
      COMMON /D/ LBSTA          !T IF BINARY STATIONS, F IF ASCII (RST,STA,DEL)
      CHARACTER  BCRUFL*60
      COMMON /C/ BCRUFL         !BINARY CRUST MODELS SNAPSHOT (WCR,RCR)
      LOGICAL    LBCRU
      COMMON /D/ LBCRU          !T IF BINARY CRUST MODELS, F IF ASCII (RCR,CRT)
      CHARACTER  DELFIL*60
      COMMON /C/ DELFIL         !STATION DELAY FILENAME (DEL)
      CHARACTER  ATNFIL*60
      COMMON /C/ ATNFIL         !STATION ATTENUATION FILENAME (ATE)
      CHARACTER  CALFIL*60
      COMMON /C/ CALFIL         !STATION CAL FACTOR FILENAME (CAL)
      CHARACTER  FMCFIL*60
      COMMON /C/ FMCFIL         !STATION FMAG CORRECTION FILENAME (FMC)
      CHARACTER  XMCFIL*60
      COMMON /C/ XMCFIL         !STATION XMAG CORRECTION FILENAME (XMC)
      CHARACTER  PHSFIL*60
      COMMON /C/ PHSFIL         !PHASE DATA INPUT FILENAME (PHS)
      CHARACTER  MAGFIL*60
      COMMON /C/ MAGFIL         !MAGNITUDE DATA OUTPUT FILE (MFL)
      CHARACTER  INFILE*60
      COMMON /C/ INFILE(0:4)    !COMMAND INPUT FILENAME (@)
      INTEGER    ISTFMT
      COMMON /D/ ISTFMT         !STATION FORMAT NO. 1=HI 2=H71 3=HI2 (STF)
      INTEGER    JCP
      COMMON /D/ JCP            !PHASE DATA FORMAT CODE (COP)
      INTEGER    JCPO
      COMMON /D/ JCPO           !1=MODIFY CUSP MEM FILES, 0=NO (COP)
      INTEGER    JCA
      COMMON /D/ JCA            !ARCHIVE DATA FORMAT CODE (CAR)
C               THE CODES ARE: 1=FULL 2=CONDENSED 3=CONDENSED PICKER STYLE
      INTEGER    JST
      COMMON /D/ JST            !0=PRINT EVENTS ONLY, 1=ADD PARAMS & FILES TO START
C               OF PRINTOUT, 2=ADD STA LIST & CRUST MODELS (LST)
      INTEGER    JST2
      COMMON /D/ JST2           !STATION LIST QUANTITY CONTROL 0,1,2 (LST)
      INTEGER    JST3
      COMMON /D/ JST3           !CRUST LIST QUANTITY CONTROL 0,1 (LST)
      INTEGER    KPRINT
      COMMON /D/ KPRINT         !CONTROLS AMOUNT OF PRINTOUT (KPR)
      LOGICAL    LEJCT
      COMMON /D/ LEJCT          !TRUE TO PAGE EJECT PRINTOUT BEFORE EACH EVENT (TOP)
      LOGICAL    LREP
      COMMON /D/ LREP           !TRUE TO REPORT EACH EVENT ON TERMINAL AS LOCATED (REP)
      LOGICAL    LPRALL
      COMMON /D/ LPRALL         !TRUE TO PRINT UNWEIGHTED STATIONS (REP)
      LOGICAL    LAPP
      COMMON /D/ LAPP(3)        !INDICATES WHETHER OUTPUT FILES ARE APPENDED TO (APP)
C               1=PRINT FILE 2=SUMMARY 3=ARCHIVE
      CHARACTER  TERMIN*60
      COMMON /C/ TERMIN         !THE CURRENT TERMINAL DEVICE CODE
      LOGICAL    L2000
      COMMON /D/ L2000          !T=SUPPORT YR2000 FORMATS, F=OLD FORMATS
      INTEGER    ICENT
      COMMON /D/ ICENT          !DEFAULT CENTURY OLD PHASE FORMAT
      INTEGER    IAMPU
      COMMON /D/ IAMPU          !DEFAULT AMP UNITS CODE
      CHARACTER  GREETING*70
      COMMON /C/ GREETING       !GREETING MESSAGE FOR TERMINAL & PRT FILE
      LOGICAL    LBLANKMAG
      COMMON /D/ LBLANKMAG      !T TO USE BLANKS FOR NOMAGS IN READABLE SUM(RDM)
      INTEGER    NRDMAG
      COMMON /D/ NRDMAG         !NUMBER OF READABLE MAGS IN SUM OUTPUT (RDM)
      INTEGER    MRDMAG
      COMMON /D/ MRDMAG(5)      !WHICH READABLE MAGS IN SUM OUTPUT (RDM)
C               1=FMAG1 2=FMAG2 3=XMAG1 4=XMAG2 5=EXTMAG

C--HYPOINVERSE CRUSTAL MODELS ********************************************
C--DATA PRESENT FOR EACH OF THE LH=LM MODELS (CRH,CRL,CRE)
C--LH IS THE MAX NO. OF LAYER MODELS WHICH MUST = LM, THE MAX NO. OF MODELS
      INTEGER    NLYR
      PARAMETER (NLYR=20)
      INTEGER    LH
      PARAMETER (LH=36)
      CHARACTER   MODNAM*30
      COMMON /MC/ MODNAM(LH)    !MODEL NAME OR LABEL
      INTEGER    LAY
      COMMON /M/ LAY(LH)        !NUMBER OF LAYERS OR V-D POINTS
      REAL       D
      COMMON /M/ D(NLYR,LH)     !DEPTH TO LAYER TOP OR VELOCITY POINT
      REAL       VEL
      COMMON /M/ VEL(NLYR,LH)   !LAYER OR POINT VELOCITY
      REAL       THK
      COMMON /M/ THK(NLYR,LH)   !THICKNESS OF HOMOGENEOUS LAYER
      REAL       VSQ
      COMMON /M/ VSQ(NLYR,LH)   !SQUARED VELOCITY OF HOMOGENEOUS LAYER
      INTEGER    MODTYP
      COMMON /M/ MODTYP(LH)     !MDL TYPE (-1=UNDEF, 0=GRAD, 1=HOMO LAYER)
C                               !(2=LIN GRADIENT OVER HALFSP, 3=LIN GRAD)
C                               !(4=HYPOELLIPSE LAYER)
      LOGICAL    LELEV
      COMMON /M/ LELEV(LH)      !TRUE TO USE STATION ELEVATIONS IN HYPOELIP MOD TYPES

C--PARAMETERS FOR LIN GRADIENT MODELS MODTYP=2,3 (LINVOL,LINV FROM HYPOELLIPSE)
C--NOTE: STATION ELEVATIONS ARE USED, CAN BE NEGATIVE, EQ DEPTHS CAN BE +/-
      REAL       ELEVMX
      COMMON /M/ ELEVMX(LH)     !REFERENCE (MAX) ELEV ABOVE S.L. IN KM (CRL,CRE)
      REAL       ELEVMAX
      COMMON /M/ ELEVMAX        !MIN OF ELEVMX OF 3 MODELS USED THIS ITERATION FWK 1.37
      REAL       VREF
      COMMON /M/ VREF(LH)       !VELOCITY AT REFERENCE ELEV (CRL)
      REAL       VGRAD
      COMMON /M/ VGRAD(LH)      !VELOCITY GRADIENT OF ENTIRE MODEL (CRL,CRV)
      REAL       VSEA
      COMMON /M/ VSEA(LH)       !VELOCITY AT SEA LEVEL (CRV)
      REAL       THICK
      COMMON /M/ THICK(LH)      !THICKNESS OF HALFSPACE (CRV)
      REAL       VHALF
      COMMON /M/ VHALF(LH)      !VELOCITY OF HALFSPACE (CRV)

C--PARAMETERS FOR HYPOELLIPSE LAYER MODELS MODTYP=4
C--NOTE: STATION ELEVATIONS ARE USED, CAN BE NEGATIVE, EQ DEPTHS CAN BE +/-
      REAL       VSQDE
      COMMON /M/ VSQDE(NLYR,NLYR,LH) !USED IN REFRACTION CALCULATIONS
      REAL       FREF
      COMMON /M/ FREF(NLYR,NLYR,LH)  !USED IN REFRACTION CALCULATIONS
      REAL       VELI
      COMMON /M/ VELI(NLYR,LH)       !ONE OVER VOLOCITY
      REAL       TIDE
      COMMON /M/ TIDE(NLYR,NLYR,LH)  !USED IN REFRACTION CALCULATIONS
      REAL       DIDE
      COMMON /M/ DIDE(NLYR,NLYR,LH)  !USED IN REFRACTION CALCULATIONS

C--DATA USED ONLY FOR LINEAR GRADIENT TRAVEL TIME TABLES
      INTEGER    LN
      PARAMETER (LN=36)         !THE NUMBER OF LINEAR-GRAD MODELS ALLOWED
      REAL       REDV
      COMMON /M/ REDV(LN)       !ONE OVER THE REDUCING VELOCITY
      INTEGER    NZ
      COMMON /M/ NZ(LN)         !NUMBER OF DEPTH GRID POINTS
      INTEGER    NZ1,            NZ2
      REAL               DZ1,            DZ2
      COMMON /M/ NZ1(LN),DZ1(LN),NZ2(LN),DZ2(LN)        !DEPTH GRID PARAMS
      INTEGER    ND
      COMMON /M/ ND(LN)         !NUMBER OF DISTANCE GRID POINTS
      INTEGER    ND1,            ND2
      REAL               DD1,            DD2
      COMMON /M/ ND1(LN),DD1(LN),ND2(LN),DD2(LN)        !DIST GRID PARAMS
      LOGICAL    GD1,    GD2,    GZ1,    GZ2
      COMMON /M/ GD1(LN),GD2(LN),GZ1(LN),GZ2(LN)        !GRID FLAGS

C--DECLARE ARRAY STORAGE FOR TRAVEL TIME TABLE. THE ARRAY KT HOLDS
C  CONDENSED TRAVEL TIMES TO 28 DEPTH & 42 DISTANCE POINTS.
C  KDHR HOLDS THE DISTANCES AT WHICH HORIZONTAL RAYS EMERGE.
C--DECLARED IN INTEGER.FOR
      COMMON /M/ KDHR(LN,28)
C--DECLARED IN INTEGER.FOR
      COMMON /M/ KT(LN,28,42)

C--PARAMETERS FOR MULTIPLE CRUSTAL MODELS
C--LM IS THE MAXIMUM NUMBER OF MODELS OF EITHER GRADIENT OR LAYER TYPE.
C  LM MUST = LH (MAX NO. OF LAYER MODELS). LN (MAX NO. OF GRADIENT MODELS)
C  MAY BE LESS THAN OR = LM.  LH & LN ARE PARAMETERS IN HYPCOMC.
      INTEGER    LM
      PARAMETER (LM=36)         !MAX NUMBER OF CRUST MODELS
      INTEGER    MOD
      COMMON /D/ MOD            !CURRENT CRUST MODEL NUMBER
      CHARACTER  CRUFIL*60
      COMMON /C/ CRUFIL(LM)     !CRUST MODEL INPUT FILENAMES (CRT,CRH)
      CHARACTER  CRODE*3
      COMMON /C/ CRODE(LM)      !CRUST MODEL CODE FROM NAME
      INTEGER    MODALT
      COMMON /D/ MODALT(LM)     !=0 NO ALTERNATE MOD, =N USE MODEL N W/SOME STAS
      REAL       POSM
      COMMON /D/ POSM(LM)       !P/S VELOCITY RATIO FOR THIS MODEL (POS,PSM)
      REAL       POSB
      COMMON /D/ POSB(LM)       !S= POSM*P +POSB FOR THIS MODEL (PSM)
      LOGICAL    LMULT
      COMMON /D/ LMULT          !T TO PROCESS W/ REGION-DEPENDENT MODELS (MUL)
      INTEGER    MODSAL
      COMMON /D/ MODSAL(LM)     !=0 NO S MODEL, =N USE MODEL N FOR S (SAL)
      INTEGER    MODDEF
      COMMON /D/ MODDEF         !DEFAULT MODEL FOR UNLISTED REGIONS (MUL)
      INTEGER    MAXMOD
      COMMON /D/ MAXMOD         !HIGHEST MODEL NUMBER DEFINED (CRT,CRH,CRE,CRL,CRV)
      INTEGER    NMOD
      COMMON /D/ NMOD           !NO. OF POS WEIGHTED MODELS FOR AN EVENT (1-3)
      INTEGER    MODS
      COMMON /D/ MODS (3)       !MODEL NUMBERS FOR THIS EVENT
      REAL       WMOD
      COMMON /D/ WMOD (3)       !WEIGHTS OF EACH MODEL

      INTEGER    NODMAX
      PARAMETER (NODMAX=124)    !MAX NO. OF GEOGRAPHIC NODES FOR DEFINING MODELS
      INTEGER    NNODE
      COMMON /D/ NNODE          !NUMBER OF NODES CURRENTLY DEFINED (NOD)
      REAL       HLAT
      COMMON /D/ HLAT(NODMAX)   !NODE CIRCLE CENTER LAT (NOD)
      REAL       HLON
      COMMON /D/ HLON(NODMAX)   !NODE CIRCLE CENTER LON (NOD)
      REAL       RAD1
      COMMON /D/ RAD1(NODMAX)   !NODE CIRCLE INNER RADIUS (NOD)
      REAL       RAD2
      COMMON /D/ RAD2(NODMAX)   !NODE CIRCLE OUTER RADIUS
      REAL       DRAD
      COMMON /D/ DRAD(NODMAX)   !NODE CIRCLE TRANSITION WIDTH (NOD)
      INTEGER    MODH
      COMMON /D/ MODH(NODMAX)   !MODEL NO. FOR THIS NODE (NOD)
      REAL       HDIS
      COMMON /D/ HDIS(NODMAX)   !EPICENTRAL DIST FROM NODE

C--DATA FOR ALL AVAILABLE STATIONS STORED AS LOOKUP TABLE (SUBSCRIPT J)
C  USE 2-BYTE INTEGERS WHERE POSSIBLE
C     INTEGER*4 JCEXP, JFEXP ,JXEXP            !LONGER LENGTH REQUIRED
      INTEGER    MAXSTA
      PARAMETER (MAXSTA=11000)  !MAX NO. OF STATIONS STORED IN LOOKUP TABLE
      INTEGER    JSTA
      COMMON /D/ JSTA           !NUMBER OF STATIONS ACTUALLY READ INTO TABLE
C                                 JSTA <= MAXSTA
      CHARACTER  STANAM*5
      COMMON /C/ STANAM (MAXSTA)        !5-LETTER STATION NAME
      CHARACTER  JNET*2
      COMMON /C/ JNET   (MAXSTA)        !2-LETTER SEISMIC NET CODE
      CHARACTER  JCOMP1*1
      COMMON /C/ JCOMP1 (MAXSTA)        !1-LETTER COMPONENT CODE
      CHARACTER  JCOMP3*3
      COMMON /C/ JCOMP3 (MAXSTA)        !3-LETTER COMPONENT CODE
      CHARACTER  JCOMPA*3
      COMMON /C/ JCOMPA (MAXSTA)        !ALTERNATIVE 3-LETTER COMPONENT CODE
      CHARACTER  JSLOC*2
      COMMON /C/ JSLOC  (MAXSTA)        !2-LETTER LOCATION CODE
      CHARACTER  JSLOC2*2
      COMMON /C/ JSLOC2 (MAXSTA)        !EQUIVALENT LOCATION CODE ('  '='--')
      LOGICAL    LLOC2
      COMMON /D/ LLOC2                  !T IF 2ND LOCATION CODE MATCHED
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JLATD (MAXSTA)         !LATITUDE (DEG)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JLATM (MAXSTA)         !LATITUDE (IN .01 MIN)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JLOND (MAXSTA)         !LONGITUDE (DEG)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JLONM (MAXSTA)         !LONGITUDE (IN .01 MIN)
      INTEGER    JELEV
      COMMON /D/ JELEV (MAXSTA)         !ELEVATION ABOVE SEA LEVEL IN M
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JPER (MAXSTA)          !STANDARD PERIOD (PERIOD IN SEC * 10)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JTYPE (MAXSTA)         !RESPONSE TYPE 0=WA 1,3=L4C 4=HS1 ETC
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JCAL (MAXSTA)          !STATION CAL FACTOR *1000
      INTEGER    JCEXP
      COMMON /D/ JCEXP (MAXSTA)         !CAL EXPIRATION DATE (IN YMDH)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JLMOD (MAXSTA)         !T TO USE ALTERNATE MODEL FOR THIS STA
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JFCOR (MAXSTA)         !DUR MAG CORRECTION *100
      INTEGER    JFEXP
      COMMON /D/ JFEXP (MAXSTA)         !FCOR EXPIRATION DATE (IN YMDH)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JXCOR (MAXSTA)         !AMP MAG CORRECTION *100
      INTEGER    JXEXP
      COMMON /D/ JXEXP (MAXSTA)         !XCOR EXPIRATION DATE (IN YMDH)
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JPSWT (MAXSTA)         !P & S STATION WEIGHTS
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JXWT (MAXSTA)          !AMPLITUDE MAGNITUDE WEIGHT *10
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JFWT (MAXSTA)          !DURATION MAGNITUDE WEIGHT *10
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JFGWT (MAXSTA)         !DURATION GAIN CORRECTION WEIGHT *1
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JPD (LM,MAXSTA)        !P DELAYS IN .01 SEC
      CHARACTER  STRMK*1
      COMMON /C/ STRMK (MAXSTA)         !1-LETTER STATION REMARK
C--THE FOLLOWING 4 VARIABLES DEPEND ON COMP TYPE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JFM1 (MAXSTA)          !USE THIS STATION FOR 1ST DUR MAG
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JFM2 (MAXSTA)          !USE THIS STATION FOR 2ND DUR MAG
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JXM1 (MAXSTA)          !USE THIS STATION FOR 1ST AMP MAG
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JXM2 (MAXSTA)          !USE THIS STATION FOR 2ND AMP MAG
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JPM1 (MAXSTA)          !USE THIS STATION FOR 1ST P AMP MAG
C--DECLARED IN INTEGER.FOR
      COMMON /D/ JPM2 (MAXSTA)          !USE THIS STATION FOR 2ND P AMP MAG

C************** DATA FOR A PARTICULAR EVENT *********************
C--DATA PRESENT FOR EACH STATION REPORTING AN EVENT (SUBSCRIPT K)
C  USE 2-BYTE INTEGERS WHERE POSSIBLE
      INTEGER    MAXPHS
      PARAMETER (MAXPHS=1500)   !MAX NO. OF STATIONS FOR EACH EVENT
      INTEGER    KSTA
      COMMON /D/ KSTA           !NO. OF STATIONS (PHASE CARDS) FOR THIS EVENT
C                                 KSTA <= MAXPHS
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KINDX (MAXPHS)         !POINTER TO STATION IN LOOKUP TABLE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KP (MAXPHS)            !P TIME IN .01"
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KS (MAXPHS)            !S TIME IN .01"
      REAL       DIS
      COMMON /D/ DIS (MAXPHS)           !DISTANCE TO EPICENTER IN KM
      INTEGER    KAZEM
      COMMON /D/ KAZEM (MAXPHS)         !CONDENSED AZIMUTH & EMERGENCE ANGLE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KWT (MAXPHS)           !CONDENSED ASSIGNED P & S WEIGHT CODES
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KFWT (MAXPHS)          !ASSIGNED DUR MAGNITUDE WEIGHT CODE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KXWT (MAXPHS)          !ASSIGNED AMP MAGNITUDE WEIGHT CODE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KPAWT (MAXPHS)         !ASSIGNED P AMP MAG WEIGHT CODE
      REAL       PAWT
      COMMON /D/ PAWT (MAXPHS)          !P AMP MAGNITUDE WEIGHT
      REAL       FMPK
      COMMON /D/ FMPK (MAXPHS)          !CODA DURATION IN SECONDS
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KXMAG (MAXPHS)         !CALCULATED AMP MAG FOR THIS STA *100
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KFMAG (MAXPHS)         !CALCULATED DUR MAG FOR THIS STA *100
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KPMAG (MAXPHS)         !CALCULATED P MAG FOR THIS STA *100
      REAL       AMPK
      COMMON /D/ AMPK (MAXPHS)          !MAX PEAK-TO-PEAK AMP IN MM OR COUNTS
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KAMPU (MAXPHS)         !AMP UNITS CODE 0=PP-MM 1=0-P 2=COUNTS
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KAMPTYP (MAXPHS)       !AMP TYP 0=? 1=WA 2=VEL 3=ACCEL 4=NOUSE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KIMTYP (MAXPHS)        !INST TYP 0=NOMAG 1=ML 2=MX
      INTEGER    KPAMP
      COMMON /D/ KPAMP (MAXPHS)         !PP P AMP IN COUNTS, 1ST 3 PEAKS
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KPER (MAXPHS)          !PERIOD AT AMP READING IN .01 SEC.
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KCAL (MAXPHS)          !CAL FACTOR FOR THIS AMP ONLY IN .01
      CHARACTER  KPRK*3
      COMMON /C/ KPRK (MAXPHS)          !P REMARK INCL FIRST MOTION
      CHARACTER  KSRK*2
      COMMON /C/ KSRK (MAXPHS)          !S REMARK
      CHARACTER  PARMK*1
      COMMON /C/ PARMK (MAXPHS)         !P AMPLITUDE DESCRIPTOR
      REAL       PNORM
      COMMON /D/ PNORM (MAXPHS)         !PMAG L1 NORM FOR STA TB MINIMIZED
      REAL       PNORM2
      COMMON /D/ PNORM2 (MAXPHS)        !PMAG2 L1 NORM FOR STA TB MINIMIZED
      CHARACTER  KRMK*1
      COMMON /C/ KRMK (MAXPHS)          !ANY 1 LETTER STATION REMARK
      CHARACTER  KRMK6*6
      COMMON /C/ KRMK6 (MAXPHS)         !ORIGINAL 6-LETTER REMARK
      CHARACTER  KSHAD*104              !A MAX LENGTH OF 104 IS TESTED IN HYPHS
      COMMON /C/ KSHAD (MAXPHS)         !OPTIONAL SHADOW PHASE RECORD
C--DECLARED IN INTEGER.FOR
      COMMON /D/ KLSHA (MAXPHS)         !LENGTH OF KSHAD
      CHARACTER  KSOU*1
      COMMON /C/ KSOU (MAXPHS)          !1-LETTER DATA SOURCE CODE
      CHARACTER  KDEV*3
      COMMON /C/ KDEV (MAXPHS)          !3-LETTER DIGITIZER DEVICE CODE

C--DATA PRESENT FOR EACH PHASE (P OR S) REPORTED FOR THIS EVENT (SUBSCRIPT IM)
      INTEGER    MMAX
      PARAMETER (MMAX=1200)             !MAX NO. OF PHASES (P OR S) PER EVENT
      INTEGER    M
      COMMON /D/ M                      !NO. OF ARRIVAL TIMES FOR THIS EVENT
C--DECLARED IN INTEGER.FOR
      COMMON /D/ IND (MMAX)             !POINTER TO STATION IN TABLE
C--DECLARED IN INTEGER.FOR
      COMMON /D/ MSFLAG (MMAX)          !LOGICAL S ARRIVAL FLAG
      REAL       A
      COMMON /D/ A (MMAX,5)             !TRAVEL TIMES & DERIVATIVES
      REAL       R
      COMMON /D/ R (MMAX)               !CURRENT TRAVEL TIME RESIDUAL
      REAL       W
      COMMON /D/ W (MMAX)               !COMPUTED WEIGHT OF READING
C--DECLARED IN INTEGER.FOR
      COMMON /D/ IMPORT (MMAX)          !COMPUTED IMPORTANCE OF READING IN .001
C--DECLARED IN INTEGER.FOR
      COMMON /D/ MTCAL (MMAX)           !CALC TT IN .01. MULT S TIMES BY POS
C--THESE VALUES ARE PASSED BY THE ARRAY A.
C 1 AIN !ANGLE OF EMERGENCE AT THE SOURCE, MEASURED IN DEGREES FROM NADIR.
C 2 T           !TRAVEL TIME
C 3 DTDR        !TT DERIVATIVE WRT DISTANCE
C 4 DTDZ        !TT DERIVATIVE WRT DEPTH

C--HYPOCENTER DATA FOR THIS EVENT
      INTEGER    KYEAR
      COMMON /D/ KYEAR                  !TWO DIGIT YEAR
      INTEGER    KYEAR2
      COMMON /D/ KYEAR2                 !4 DIGIT YEAR
      INTEGER    KMONTH
      COMMON /D/ KMONTH                 !MONTH
      INTEGER    KDAY
      COMMON /D/ KDAY                   !DAY
      INTEGER    KHOUR
      COMMON /D/ KHOUR                  !HOUR
      INTEGER    KMIN
      COMMON /D/ KMIN                   !MINUTE
      REAL       T1
      COMMON /D/ T1                     !CURRENT (OR TRIAL) ORIGIN TIME, SEC
      REAL       Z1
      COMMON /D/ Z1                     !CURRENT (OR TRIAL) DEPTH FROM LOCATOR
      REAL       ZGEOID
      COMMON /D/ ZGEOID                 !DEPTH RELATIVE TO GOEID
      REAL       ZREP
      COMMON /D/ ZREP                   !REPORTED DEPTH (Z1 OR ZGEOID)
      REAL       CLAT
      COMMON /D/ CLAT                   !CURRENT (OR TRIAL) LAT, DECIMAL DEGREES
      REAL       CLON
      COMMON /D/ CLON                   !CURRENT (OR TRIAL) LON, DECIMAL DEG, POS WEST
      INTEGER    LAT
      COMMON /D/ LAT                    !EVENT LAT, DEG
      REAL       XLTM
      COMMON /D/ XLTM                   !EVENT LAT, MIN
      INTEGER    LON
      COMMON /D/ LON                    !EVENT LON, DEG
      REAL       XLNM
      COMMON /D/ XLNM                   !EVENT LON, MIN
      INTEGER    IDEPDAT
      COMMON /D/ IDEPDAT                !DEPTH DATUM IN M ABOVE SEA LEVEL
      INTEGER    JDSTA
      COMMON /D/ JDSTA                  !NO. OF CLOSE STATIONS (MAX 5) USED FOR DD
      LOGICAL    LGEOID
      COMMON /D/ LGEOID                 !TRUE TO REPORT GEOID DEPTH (GEO COMMAND)
      INTEGER    IELMIN
      COMMON /D/ IELMIN                 !MIN ELEV TO USE IN 5 STA AVER (GEO COMM)
      CHARACTER  CZFLAG*1
      COMMON /C/ CZFLAG                 !DEPTH TYPE FLAG (CHAR*1)

C--ERROR DATA FOR THIS EVENT
      REAL       ERH
      COMMON /D/ ERH                    !HORIZONTAL LOCATION ERROR
      REAL       ERZ
      COMMON /D/ ERZ                    !DEPTH ERROR
      REAL       SERR
      COMMON /D/ SERR(3)                !MAGNITUDES OF 3 STD. ERRORS
      INTEGER    IAZ
      COMMON /D/ IAZ(3)                 !AZIMUTHS OF 3 STD. ERRORS
      INTEGER    IDIP
      COMMON /D/ IDIP(3)                !DIPS OF 3 STD. ERRORS

C--FIRST MAGNITUDE DATA FOR EVENT
      REAL       FMAG
      COMMON /D/ FMAG                   !MEDIAN DURATION MAG
      REAL       XMAG
      COMMON /D/ XMAG                   !MEDIAN AMPLITUDE MAG
C     INTEGER    MFMAG
C     COMMON /D/ MFMAG                  !TOTAL OF DURATION MAG WEIGHTS *100
      INTEGER    NFMAG
      COMMON /D/ NFMAG                  !NUMBER OF DURATION MAGS W/ WEIGHTS>0
C     INTEGER    MXMAG
C     COMMON /D/ MXMAG                  !TOTAL OF AMPLITUDE MAG WEIGHTS *100
      INTEGER    NXMAG
      COMMON /D/ NXMAG                  !NUMBER OF AMPLITUDE MAGS W/ WEIGHTS>0
      REAL       FMMAD
      COMMON /D/ FMMAD                  !MEDIAN ABSOL DIFFERENCE OF DURATION MAGS
      REAL       XMMAD
      COMMON /D/ XMMAD                  !MEDIAN ABSOL DIFFERENCE OF AMPLITUDE MAGS
      REAL       BMAG
      COMMON /D/ BMAG                   !PASS THRU (BERKELEY) MAGNITUDE
C     INTEGER    MBMAG
C     COMMON /D/ MBMAG                  !TOTAL OF PASS THRU MAG WEIGHTS *100
      INTEGER    NBMAG
      COMMON /D/ NBMAG                  !NUMBER OF PASS THRU MAGS W/ WEIGHTS>0
      CHARACTER  BMTYP*1
      COMMON /C/ BMTYP                  !PASS THRU MAGNITUDE LABEL CODE
      REAL       BMAGX
      COMMON /D/ BMAGX                  !PASS THRU X-MAGNITUDE
C     INTEGER    MBMAGX
C     COMMON /D/ MBMAGX                 !NUMBER OF PASS THRU XMAG READINGS *100
      INTEGER    NBMAGX
      COMMON /D/ NBMAGX                 !NUMBER OF PASS THRU XMAG READINGS
      CHARACTER  BMTYPX*1
      COMMON /C/ BMTYPX                 !PASS THRU X-MAGNITUDE LABEL CODE

C--SECOND MAGNITUDE DATA FOR EVENT
      REAL       FMAG2
      COMMON /D/ FMAG2          !MEDIAN DURATION MAG
      REAL       XMAG2
      COMMON /D/ XMAG2          !MEDIAN AMPLITUDE MAG
C     INTEGER    MFMAG2
C     COMMON /D/ MFMAG2         !TOTAL OF DURATION MAG WEIGHTS *100
      INTEGER    NFMAG2
      COMMON /D/ NFMAG2         !NUMBER OF DURATION MAGS W/ WEIGHTS>0
C     INTEGER    MXMAG2
C     COMMON /D/ MXMAG2         !TOTAL OF AMPLITUDE MAG WEIGHTS *100
      INTEGER    NXMAG2
      COMMON /D/ NXMAG2         !NUMBER OF AMPLITUDE MAGS W/ WEIGHTS>0
      REAL       FMMAD2
      COMMON /D/ FMMAD2         !MEDIAN ABSOL DIFFERENCE OF DURATION MAGS
      REAL       XMMAD2
      COMMON /D/ XMMAD2         !MEDIAN ABSOL DIFFERENCE OF AMPLITUDE MAGS

C--MISCELLANEOUS DATA FOR THIS EVENT
      REAL       RMS
      COMMON /D/ RMS            !RMS RESIDUAL AFTER RESIDUAL WEIGHTING
      REAL       RMSWT
      COMMON /D/ RMSWT          !RMS RESIDUAL BEFORE RESIDUAL WEIGHTING
      CHARACTER  REMK*3
      COMMON /C/ REMK           !3-LETTER REMARK BASED ON LOCATION
      CHARACTER  RMK1*1
      COMMON /C/ RMK1           !FIRST 1-LETTER AUXILIARY REMARK
      CHARACTER  RMK2*1
      COMMON /C/ RMK2           !SECOND 1-LETTER AUXILIARY REMARK
      CHARACTER  FULNAM*25
      COMMON /C/ FULNAM         !FULL 25-LETTER REGION NAME
      LOGICAL    DONE
      COMMON /D/ DONE           !FLAG SET WHEN EVENT IS LOCATED
      REAL       V
      COMMON /D/ V(4,4)         !EIGENVECTOR MATRIX
      REAL       EIGVAL
      COMMON /D/ EIGVAL(4)      !EIGENVALUES
      REAL       COVAR
      COMMON /D/ COVAR(4,4)     !COVARIANCE MATRIX
      INTEGER    IDNO
      COMMON /D/ IDNO           !EVENT ID NO. INPUT FOR EVENT
      INTEGER    MEMDSK
      COMMON /D/ MEMDSK         !0=GET CUSP EVENT FROM MEMORY 1=DISK (LOC)
      INTEGER    INUM
      COMMON /D/ INUM           !EVENT NO. WITHIN THIS LOCATION RUN
      INTEGER    LENSHA
      COMMON /D/ LENSHA         !LENGTH OF OPTIONAL REC AFTER TERMINATOR CARD
      CHARACTER  SHADO*95
      COMMON /C/ SHADO          !OPTIONAL RECORD AFTER TERMINATOR CARD

      INTEGER    MSHA
      PARAMETER (MSHA=4)        !MAX NUMBER OF SHADOW RECS AFTER HEADER
      INTEGER    NSHA1
      COMMON /D/ NSHA1          !ACTUAL NUMBER OF SHADOW RECS AFTER HEADER
      INTEGER    LSHA1
      COMMON /D/ LSHA1 (MSHA)   !LENGTH OF OPTIONAL REC AFTER ARCHIVE HEADER
      CHARACTER  SHAD1*95
      COMMON /C/ SHAD1 (MSHA)   !OPTIONAL RECORD AFTER ARCHIVE HEADER
      INTEGER    ITR
      COMMON /D/ ITR            !CURRENT ITERATION NUMBER
      REAL       DMIN
      COMMON /D/ DMIN           !DISTANCE TO CLOSEST STATION
      INTEGER    KEND
      COMMON /D/ KEND           !PROGRAM TERMINATION FLAG
      INTEGER    MAXGAP
      COMMON /D/ MAXGAP         !MAXIMUM AZIMUTHAL GAP
      INTEGER    NFRM
      COMMON /D/ NFRM           !NUMBER OF FIRST MOTIONS
      INTEGER    NWR
      COMMON /D/ NWR            !NUMBER OF WEIGHTED READINGS (P & S)
      INTEGER    NWS
      COMMON /D/ NWS            !NUMBER OF WEIGHTED S READINGS
      INTEGER    NVR
      COMMON /D/ NVR            !NUMBER OF VALID READINGS (>0 ASSIGNED WEIGHTS)
      REAL       RR
      COMMON /D/ RR             !LENGTH OF ADJUSTMENT VECTOR IN KM
      CHARACTER  SOUCOD*1
      COMMON /C/ SOUCOD         !MOST COMMON PHASE SOURCE CODE
      CHARACTER  FMSOU*1
      COMMON /C/ FMSOU          !MOST COMMON 1ST FMAG SOURCE CODE
      CHARACTER  XMSOU*1
      COMMON /C/ XMSOU          !MOST COMMON 1ST XMAG SOURCE CODE
      CHARACTER  FMSOU2*1
      COMMON /C/ FMSOU2         !MOST COMMON 2ND FMAG SOURCE CODE
      CHARACTER  XMSOU2*1
      COMMON /C/ XMSOU2         !MOST COMMON 2ND XMAG SOURCE CODE

C***************** PARAMETERS WHICH APPLY TO ALL EVENTS ******************
C--THE DEFINING COMMANDS ARE GIVEN IN PARENTHESES

CC--STATION DELAY PARAMETERS (DLY) [MADE OBSOLETE BY MULTIPLE MODEL OPTION]
C     INTEGER    KDLY
C     COMMON /D/ KDLY   !DELAY MODEL CONTROL: 1=MODEL 1, 2=MODEL 2, 3=LINE
CC                       SEPARATES 2 MODELS, 4=CIRCLE SEPS. 2 MODELS.
C     REAL       DLYBAL
C     COMMON /D/ DLYBAL !FACTOR WHICH BALENCES BETWEEN 2 DELAY MODELS
CC                        (0 FOR MOD1, 1 FOR MOD2)
C     REAL       DLYAZ
C     COMMON /D/ DLYAZ  !AZIMUTH OF LINE OR RADIUS OF CIRCLE WHICH
CC                        SEPARATES THE 2 DELAY MODELS
C     REAL       DLYWD
C     COMMON /D/ DLYWD  !WIDTH OF TRANSITION ZONE BETWEEN MODELS
C     REAL       DLYLON
C     COMMON /D/ DLYLON !LON OF CIRCLE CENTER OR POINT ON LINE
C     REAL       DLYLAT
C     COMMON /D/ DLYLAT !LAT OF CIRCLE CENTER OR POINT ON LINE
CC                         BOTH IN DECIMAL DEGREES, POS N & W

C--TERMINATING LOCATION UPON CONVERGENCE (CON)
      INTEGER    ITRLIM
      COMMON /D/ ITRLIM         !MAXIMUM NUMBER OF ITERATIONS
      REAL       DQUIT
      COMMON /D/ DQUIT          !STOP WHEN HYPO ADJUSTMENT IS < THIS
      REAL       DRQT
      COMMON /D/ DRQT           !STOP WHEN CHANGE IN RMS < THIS
      INTEGER    MINSTA
      COMMON /D/ MINSTA         !MIN NO. OF PHASE CARDS TO ATTEMPT LOC (MIN)

C--ITERATION & DAMPING CONTROLS (DAM)
      REAL       DXFIX
      COMMON /D/ DXFIX          !KEEP DEPTH FIXED UNTIL ADJUST IS < THIS
      REAL       DZMAX
      COMMON /D/ DZMAX          !DAMP DEPTH ADJUST IF > THIS
      REAL       DXMAX
      COMMON /D/ DXMAX          !DAMP DISTANCE ADJUST IF > THIS
      REAL       D2FAR
      COMMON /D/ D2FAR          !STOP WHEN STA-DIST(2) > THIS
      REAL       DZAIR
      COMMON /D/ DZAIR          !FRACTION OF DEPTH ADJ. IF QUAKE GOES INTO AIR
      REAL       DAMP
      COMMON /D/ DAMP           !DAMPING FACTOR FOR ALL HYPO ADJUSTMENTS
      REAL       EIGTOL
      COMMON /D/ EIGTOL         !MIN EIGENVALUE REQUIRED FOR ADJUSTMENT
      REAL       RBACK
      COMMON /D/ RBACK          !LIMIT ON RMS INCREASE FOR ONE ITERATION
      REAL       BACFAC
      COMMON /D/ BACFAC         !FRACTION OF STEP TO MOVE BACK IF
C                                 INCREASE IN RMS > RBACK

C--DURATION MAG CONSTANTS
      LOGICAL    LATEN
      COMMON /D/ LATEN          !TRUE TO CONVERT STA ATTEN TO CAL FACTOR (ATN)
      REAL       FMA1,FMB1,FMZ1,FMD1,FMF1
      COMMON /D/ FMA1,FMB1,FMZ1,FMD1,FMF1       !LOW DUR MAG CONSTANTS (DUR)
      REAL       FMA2,FMB2,FMZ2,FMD2,FMF2
      COMMON /D/ FMA2,FMB2,FMZ2,FMD2,FMF2       !HIGH DUR MAG CONSTANTS (DUR)
      REAL       FMBRK
      COMMON /D/ FMBRK          !DURATION SEPARATING LO & HI CONSTANTS (DUR)
      REAL       FMGN
      COMMON /D/ FMGN           !COEFF OF GAIN CORR TO OLD FMAGS (DUR)
      INTEGER    IDUG
      COMMON /D/ IDUG           !NUMBER OF GAIN CORR COMPS, -1=ALL (DUG)
      CHARACTER  CDUG*3
      COMMON /C/ CDUG(10)       !COMPONENTS TO CORRECT (DUG)
      REAL       DCOFM1
      COMMON /D/ DCOFM1         !COEFF OF ADDL LINEAR DIST TERM (DU2)
      REAL       DBRKM1
      COMMON /D/ DBRKM1         !START DIST OF ADDL LINEAR DIST TERM (DU2)
      REAL       DCOFM2
      COMMON /D/ DCOFM2         !COEFF OF ADDL LINEAR DIST TERM (DU2)
      REAL       DBRKM2
      COMMON /D/ DBRKM2         !START DIST OF ADDL LINEAR DIST TERM (DU2)
      REAL       ZCOFM
      COMMON /D/ ZCOFM          !COEFF OF ADDL LINEAR DEPTH TERM (DU2)
      REAL       ZBRKM
      COMMON /D/ ZBRKM          !START DEPTH OF ADDL LINEAR DEPTH TERM (DU2)
      REAL       FMA1B,FMB1B,FMZ1B,FMD1B,FMF1B
      COMMON /D/ FMA1B,FMB1B,FMZ1B,FMD1B,FMF1B  !LOW 2nd DUR MAG (DUB)
      REAL       FMA2B,FMB2B,FMZ2B,FMD2B,FMF2B
      COMMON /D/ FMA2B,FMB2B,FMZ2B,FMD2B,FMF2B  !HIGH 2nd DUR MAG (DUB)
      REAL       FMBRKB
      COMMON /D/ FMBRKB         !2ND DURATION SEPARATING LO & HI CONSTS (DUB)
      REAL       FMGNB
      COMMON /D/ FMGNB          !COEFF OF GAIN CORR FOR 2nd FMAGS (DUB)
      INTEGER    MAGSEL
      COMMON /D/ MAGSEL         !FMAG1: 1=CODA MAGS 2=TAU MAGS 3=2nd CODA (MAG)
      INTEGER    MAGSL2
      COMMON /D/ MAGSL2         !FMAG2: 1=CODA MAGS 2=TAU MAGS 3=2nd CODA (MAG)
      LOGICAL    LCOWT
      COMMON /D/ LCOWT          !T=USE CODA WEIGHTS F=IGNORE CODA WEIGHTS (MAG)
      INTEGER    MLOGA0
      COMMON /D/ MLOGA0         !1=USE EATON LOGA0 RELATION 2=BAKUN & JOYNER(MAG
C                               !3=RICHTER 4=BKY'S NORDQUIST 5=RICHTER (MAG)
      INTEGER    NOMAGV
      COMMON /D/ NOMAGV         !MIN (NO)MAG CODE 0=0. 1=-1. 2=-9. (MA2)
      REAL       VNOMAG
      COMMON /D/ VNOMAG         !MIN (NO)MAG VALUE 0=0. 1=-1. 2=-9.
      INTEGER    MINMAG
      COMMON /D/ MINMAG         !MIN MAG VALUE *100
      LOGICAL    LMED
      COMMON /D/ LMED           !T FOR WEIGHTED MEDIAN, F FOR MEAN (MA2)
      INTEGER    NLA0
      COMMON /D/ NLA0           !NUMBER OF COMPONENTS W/ UNIQUE LOGA0 REL.(LA0)
      CHARACTER  CLA0*3
      COMMON /C/ CLA0(20)       !COMPONENT CODES FOR UNIQUE LOGA0 (LA0)
      INTEGER    MLA0
      COMMON /D/ MLA0(20)       !LOGA0 # (LIKE MLOGA0) FOR UNIQUE LOGA0S (LA0)
      REAL       DMA0
      COMMON /D/ DMA0           !CONSTANT IN TAU MAG (TAU)
      REAL       DMA1
      COMMON /D/ DMA1           !COEFF. OF LOG(TAU) IN TAU MAG (TAU)
      REAL       DMA2
      COMMON /D/ DMA2           !COEFF. OF LOG(TAU)**2 IN TAU MAG (TAU)
      REAL       DMLI
      COMMON /D/ DMLI           !COEFF. OF TAU IN TAU MAG (TAU)
      REAL       DMZ
      COMMON /D/ DMZ            !COEFF. OF DEPTH IN TAU MAG (TAU)
      REAL       DMGN
      COMMON /D/ DMGN           !COEFF. OF GAIN/ATTEN IN TAU MAG (TAU)

C--DURATION & AMPLITUDE MAGNITUDE CORRECTIONS
C     INTEGER*4 ICDATE, IFDATE, IXDATE         !LONGER LENGTH REQUIRED
      INTEGER    ICDATE
      COMMON /D/ ICDATE         !INITIAL DATE FOR EXTRACTING ATTENS (ATE)
      INTEGER    IFDATE
      COMMON /D/ IFDATE         !INITIAL DATE FOR EXTRACTING FMCORS (FMC)
      INTEGER    IXDATE
      COMMON /D/ IXDATE         !INITIAL DATE FOR EXTRACTING XMCORS (XMC)
      LOGICAL    LNOFMC
      COMMON /D/ LNOFMC         !T TO USE STA W/ NO CORR, F TO OMIT (FMC)
      LOGICAL    LNOXMC
      COMMON /D/ LNOXMC         !T TO USE STA W/ NO CORR, F TO OMIT (XMC)
      REAL       CALSV
      COMMON /D/ CALSV(0:13)    !CAL FACTORS FOR EACH ATTENUATION SETTING
      INTEGER    NFCM
      COMMON /D/ NFCM           !# OF COMPONENTS TO CORRECT FMAGS (FCM)
      CHARACTER  CFCM*3
      COMMON /C/ CFCM(10)       !3-LETTER COMPONENTS TO CORRECT (FCM)
      REAL       AFCM
      COMMON /D/ AFCM(10)       !FMAG CORRECTION FOR COMPONENT (FCM)
      INTEGER    NXCM
      COMMON /D/ NXCM           !# OF COMPONENTS TO CORRECT XMAGS (XCM)
      CHARACTER  CXCM*3
      COMMON /C/ CXCM(10)       !3-LETTER COMPONENTS TO CORRECT (XCM)
      REAL       AXCM
      COMMON /D/ AXCM(10)       !XMAG CORRECTION FOR COMPONENT (XCM)

C--SELECTING WHICH COMPONENTS TO USE FOR THE 4 MAGNITUDES
C--ALSO SELECT WHICH INSTRUMENT TYPES TO USE WITH THE 2 AMP MAGS
      INTEGER    NCPF1
      COMMON /D/ NCPF1          !NUMBER OF COMPONENTS TO SELECT FOR FMAG1 (FC1)
      CHARACTER  COMPF1*3
      COMMON /C/ COMPF1(20)     !COMPONENTS TO USE FOR FMAG1 (FC1)
      CHARACTER  LABF1*1
      COMMON /C/ LABF1          !LABEL CODE TO IDENTIFY FMAG1 (FC1)
      INTEGER    NCPF2
      COMMON /D/ NCPF2          !NUMBER OF COMPONENTS TO SELECT FOR FMAG2 (FC2)
      CHARACTER  COMPF2*3
      COMMON /C/ COMPF2(20)     !COMPONENTS TO USE FOR FMAG2 (FC2)
      CHARACTER  LABF2*1
      COMMON /C/ LABF2          !LABEL CODE TO IDENTIFY FMAG2 (FC2)
      INTEGER    NCPX1
      COMMON /D/ NCPX1          !NUMBER OF COMPONENTS TO SELECT FOR XMAG1 (XC1)
      CHARACTER  COMPX1*3
      COMMON /C/ COMPX1(20)     !COMPONENTS TO USE FOR XMAG1 (XC1)
      CHARACTER  LABX1*1
      COMMON /C/ LABX1          !LABEL CODE TO IDENTIFY XMAG1 (XC1)
      INTEGER    NCPX2
      COMMON /D/ NCPX2          !NUMBER OF COMPONENTS TO SELECT FOR XMAG2 (XC2)
      CHARACTER  COMPX2*3
      COMMON /C/ COMPX2(20)     !COMPONENTS TO USE FOR XMAG2 (XC2)
      CHARACTER  LABX2*1
      COMMON /C/ LABX2          !LABEL CODE TO IDENTIFY XMAG2 (XC2)
      INTEGER    MAG1TYPX
      COMMON /D/ MAG1TYPX       !TYPE OF MAG FOR XMAG1 1=ML 2=MX (XMT)
      INTEGER    MAG2TYPX
      COMMON /D/ MAG2TYPX       !TYPE OF MAG FOR XMAG2 1=ML 2=MX (XMT)
C--PARAMETERS FOR FMAG2 IN A LAT/LON BOX (ALL COMPONENTS)
      LOGICAL    USEMAR
      COMMON /D/ USEMAR         !T FOR FMAG2 IN A LAT/LON BOX (MAR)
      LOGICAL    LINBOX
      COMMON /D/ LINBOX         !T IF THIS EQ IN LAT/LON BOX
      REAL       YLATMX
      COMMON /D/ YLATMX         !MAX LAT FOR FMAG2 BOX (MAR)
      REAL       YLATMN
      COMMON /D/ YLATMN         !MIN LAT FOR FMAG2 BOX (MAR)
      REAL       XLONMX
      COMMON /D/ XLONMX         !MAX LON FOR FMAG2 BOX (MAR)
      REAL       XLONMN
      COMMON /D/ XLONMN         !MIN LON FOR FMAG2 BOX (MAR)
      LOGICAL    SWITCH12
      COMMON /D/ SWITCH12       !T SWITCH FMAGS 1&2 IF EQ IN BOX &READABLE (MAR)

C--SELECTING WHICH INSTRUMENT TYPES TO USE FOR THE 2 AMP MAGS
      LOGICAL    LXCH
      COMMON /D/ LXCH           !T FOR COMPONENT CHOICE, F INST TYPE CHOICE(XCH)
      INTEGER    NXTYP1
      COMMON /D/ NXTYP1         !NUMBER OF INST TYPES FOR XMAG1 (XTY)
      INTEGER    IXTYP1
      COMMON /D/ IXTYP1(3)      !INST TYPES FOR XMAG1 (XTY)
      INTEGER    NXTYP2
      COMMON /D/ NXTYP2         !NUMBER OF INST TYPES FOR XMAG2 (XTY)
      INTEGER    IXTYP2
      COMMON /D/ IXTYP2(3)      !INST TYPES FOR XMAG2 (XTY)

C--PREFERRED EVENT MAGNITUDES
C--MAG NUMBER TAGS: 1=FMAG 2=XMAG 3=PASS-THRU-MAG 4=XMAG2 5=FMAG2
      INTEGER    NMAGS
      COMMON /D/ NMAGS          !NUMBER OF PREFERRED MAGNITUDES (PRE)
      INTEGER    MPREF
      COMMON /D/ MPREF(10)      !PREFERENCE ORDER OF MAG NUMBER TAGS (PRE)
      INTEGER    MNPREF
      COMMON /D/ MNPREF(10)     !MINIMUM NUMBER OF READINGS TO USE (PRE)
      REAL       AMPREF
      COMMON /D/ AMPREF(10)     !MIN MAG TO SELECT PREFERRED MAG (PRE)
      REAL       AXPREF
      COMMON /D/ AXPREF(10)     !MAX MAG TO SELECT PREFERRED MAG (PRE)
      REAL       PMAG
      COMMON /D/ PMAG           !PREFERRED MAG
C     INTEGER    MPMAG
C     COMMON /D/ MPMAG          !TOTAL WEIGHTS OF PREFERRED MAG *100
      INTEGER    NPMAG
      COMMON /D/ NPMAG          !NUMBER OF PREFERRED MAGS W/ WEIGHTS>0
      CHARACTER  LABPR*1
      COMMON /C/ LABPR          !LABEL CODE OF PREFERRED MAG
      REAL       PMMAD
      COMMON /D/ PMMAD          !MEDIAN-ABS-DIFF OF PREFERRED MAG

C--MISCELLANEOUS PARAMETERS
      INTEGER    ITRDIS
      COMMON /D/ ITRDIS         !ITERATION TO BEGIN DISTANCE WEIGHTING (DIS)
      REAL       DISCUT,DISW1,DISW2
      COMMON /D/ DISCUT,DISW1,DISW2             !DIST. WEIGHT PARAMETERS (DIS)
      INTEGER    ITRDI1
      REAL              DISCU1,DISW11,DISW21
      COMMON /D/ ITRDI1,DISCU1,DISW11,DISW21    !DIST. WEIGHT PARAMETERS (DI1)
      INTEGER    ITRRES
      COMMON /D/ ITRRES         !ITERATION TO BEGIN RESIDUAL WEIGHTING (RMS)
      REAL       RMSCUT,RMSW1,RMSW2
      COMMON /D/ RMSCUT,RMSW1,RMSW2     !RMS WEIGHTING PARAMS. (RMS)
      LOGICAL    LJUNK
      COMMON /D/ LJUNK          !T TO KILL DIS & RES WEIGHTING WHEN M<4 (JUN)
      REAL       SWT
      COMMON /D/ SWT            !MULTIPLY ALL S WEIGHTS BY THIS (SWT)
C     REAL       POS
C     COMMON /D/ POS            !VP/VS VELOCITY RATIO (POS) REPLACED BY POSM()
      REAL       ZTR
      COMMON /D/ ZTR            !TRIAL DEPTH (ZTR)
      REAL       RDERR
      COMMON /D/ RDERR          !ESTIMATED READING ERROR IN SECS (ERR)
      REAL       ERCOF
      COMMON /D/ ERCOF          !WEIGHTING FACTOR OF RMS IN ERROR CALCS (ERC)
      INTEGER    NET
      COMMON /D/ NET            !NET FOR ASSIGNING 3-LET. NAMES BASED ON LOCATION (NET)
      INTEGER    NSTLET
      COMMON /D/ NSTLET         !NUMBER OF STATION SITE LETTERS TO TEST (LET)
      INTEGER    NETLET
      COMMON /D/ NETLET         !NUMBER OF STATION NET LETTERS TO TEST (LET)
      INTEGER    NCOMP
      COMMON /D/ NCOMP          !NUMBER OF COMPONENT LETTERS TO TEST (LET)
      INTEGER    NSLOC
      COMMON /D/ NSLOC          !# OF LOCATION CODE LETS TO TEST IN PHASE FILE (LET)
      INTEGER    NSLOC2
      COMMON /D/ NSLOC2         !# OF LOCATION CODE LETS TO TEST IN OTHER FILES (LET)
      LOGICAL    LCOMP1
      COMMON /D/ LCOMP1         !T= 1 LETTER COMPONENT, F=OTHERWISE (LES)
      LOGICAL    LKEEP
      COMMON /D/ LKEEP          !T=WRITE UNKNOWN STAS TO ARC FILE (KEP)
      REAL       WTVALS
      COMMON /D/ WTVALS(4)      !NUMERICAL WEIGHTS FOR CODES 0-3 (WET)

C--PHASE & SHADOW DATA FOR UNKNOWN STATIONS. COMM BETWEEN HYPHS AND HYLST.
      INTEGER    MAXUNK
      PARAMETER (MAXUNK=40)
      INTEGER      NLUNK
      COMMON /UNK/ NLUNK        !NUMBER OF UNK STAS IN "NO COMPLAIN" LIST (UNK)
      CHARACTER    LUNK*5
      COMMON /UNC/ LUNK(10)     !LIST OF STAS TO NOT COMPLAIN WHEN UNKNOWN (UNK)
      INTEGER      NUNK
      COMMON /UNK/ NUNK         !NUMBER OF UNKNOWN STATIONS THIS EVENT
      CHARACTER    PUNK*132
      COMMON /UNC/ PUNK(MAXUNK) !PHASE RECORDS OF UNKNOWN STATIONS
      INTEGER      NPUNK
      COMMON /UNK/ NPUNK(MAXUNK) !LENGTH OF PHASE RECORDS
      CHARACTER    SUNK*132
      COMMON /UNC/ SUNK(MAXUNK) !SHADOW RECORDS OF UNKNOWN STATIONS
      INTEGER      NSUNK
      COMMON /UNK/ NSUNK(MAXUNK) !LENGTH OF SHADOW RECORDS

C--INTERACTIVE PROCESSING OF SINGLE-EVENT FILES (PRO COMMAND)
      CHARACTER  LSTFIL*40
      COMMON /C/ LSTFIL         !FILE FOR READING BASE EVENT NAMES (BAS)
      INTEGER    NCBASE
      COMMON /D/ NCBASE         !NUMBER OF CHARACTERS IN BASE NAME (BAS)
      CHARACTER  LSTFOR*40
      COMMON /C/ LSTFOR         !FORMAT FOR READING EVENT FILE (BAS)
      CHARACTER  EXTPHS*8
      COMMON /C/ EXTPHS         !PHASE FILENAME EXTENSION (BAS)
      CHARACTER  EXTARC*8
      COMMON /C/ EXTARC         !ARCHIVE FILENAME EXTENSION (BAS)
      CHARACTER  EXTSUM*8
      COMMON /C/ EXTSUM         !SUMMARY FILENAME EXTENSION (BAS)
      CHARACTER  EXTPRT*8
      COMMON /C/ EXTPRT         !PRINTOUT FILENAME EXTENSION (BAS)
      INTEGER    IEDFLG
      COMMON /D/ IEDFLG         !EDITOR FLAG 1=EDT 2=ANY ED (BAS)

C--TRANSLATION ARRAYS FROM 3-LETTER DIGITIZERS TO 1-LETTER DATA SOURCE CODES
      INTEGER    MAXDIG
      PARAMETER (MAXDIG=50)
      CHARACTER  DIG3*3
      COMMON /C/ DIG3(MAXDIG)   !3-LETTER DIGITIZER CODES IN MEM FILE (DIG)
      CHARACTER  DIG1*1
      COMMON /C/ DIG1(MAXDIG)   !CORRESPONDING 1-LETTER DATA SOURCE CODES (DIG)
      CHARACTER  DIGDEF*1
      COMMON /C/ DIGDEF         !DEFAULT DATA SOURCE CODE (DID)
      INTEGER    NDIG
      COMMON /D/ NDIG           !NUMBER OF DATA SOURCE CODES (DID)

C--P AMPLITUDE MAGNITUDE PARAMETERS
      LOGICAL    LPMAG
      COMMON /D/ LPMAG          !T= COMPUTE PMAG, MUST HAVE SHADOW INPUT (PMA)
      LOGICAL    LPPRT
      COMMON /D/ LPPRT          !T= ADD PMAG STA. LINES TO PRINT OUTPUT (PMA)
      REAL       CNT2MD
      COMMON /D/ CNT2MD         !DEVEL. MM PER COUNT (P AMPS) RTP=.04 (PMA)
      REAL       CLPRAT
      COMMON /D/ CLPRAT         !RATIO OF PMCLIP/PMUSED FOR CLIPPED MAG (PMA)
      INTEGER    LATYPP
      COMMON /D/ LATYPP         !LOGA0 FORMULA # FOR PMAGS (PMA)
      INTEGER    NPWM
      COMMON /D/ NPWM           !NUMBER OF COMPONENTS WITH PAMAG WEIGHTS (PAC)
      CHARACTER  CPWM*3
      COMMON /C/ CPWM(10)       !COMPONENTS WITH DEFINED WEIGHTS (PAC)
      REAL       WPWM
      COMMON /D/ WPWM(10)       !WEIGHTS FOR EACH COMPONENT (PAC)

C--P AMP MAGNITUDE COMPONENT AND DATA SOURCE DEPENDENT PARAMETERS
      CHARACTER  LABP1*1
      COMMON /C/ LABP1          !LABEL OF PRIMARY P AMP MAGNITUDE (PC1)
      REAL       PMA1
      COMMON /D/ PMA1           !COEFFICIENT IN PMAG = PMA1 +PMB1*LOGA (PC1)
      REAL       PMB1
      COMMON /D/ PMB1           !COEFFICIENT IN PMAG = PMA1 +PMB1*LOGA (PC1)
      INTEGER    NCPP1
      COMMON /D/ NCPP1          !NUMBER OF COMPONENTS TO USE FOR PAMAG (PC1)
      CHARACTER  COMPP1*3
      COMMON /C/ COMPP1(10)     !COMPONENT CODES FOR PRIMARY P MAG (PC1)
      CHARACTER  LABP2*1
      COMMON /C/ LABP2          !LABEL OF SECONDARY P AMP MAGNITUDE (PC2)
      REAL       PMA2
      COMMON /D/ PMA2           !COEFFICIENT IN PMAG = PMA2 +PMB2*LOGA (PC1)
      REAL       PMB2
      COMMON /D/ PMB2           !COEFFICIENT IN PMAG = PMA2 +PMB2*LOGA (PC1)
      INTEGER    NCPP2
      COMMON /D/ NCPP2          !NUMBER OF COMPONENTS TO USE FOR PAMAG2 (PC2)
      CHARACTER  COMPP2*3
      COMMON /C/ COMPP2(10)     !COMPONENT CODES FOR SECONDARY P MAG (PC2)
      INTEGER    NCNTMM
      COMMON /D/ NCNTMM         !NUMBER OF SOURCE SPECIFIC CONV FACTORS (PMC)
      CHARACTER  CCNTMM*1
      COMMON /C/ CCNTMM(10)     !DATA SOURCE CODES (PMC)
      REAL       CNT2MM
      COMMON /D/ CNT2MM(10)     !COUNTS TO MM CONVERSION FOR SOURCE (PMC)

C--PRIMARY P AMPLITUDE MAGNITUDE
      REAL       PAMAG
      COMMON /D/ PAMAG          !PRIMARY P AMPLITUDE MAGNITUDE FOR EVENT
      REAL       PAMAD
      COMMON /D/ PAMAD          !MEDIAN ABSOLUTE DIFFERENCE OF PMAG
      REAL       PMUSED
      COMMON /D/ PMUSED         !TOTAL OF WEIGHTS OF STATIONS USED IN PMAG
      REAL       PMCLIP
      COMMON /D/ PMCLIP         !TOT OF WEIGHTS OF CLIPPED STAS USED IN PMAG
      INTEGER    MINPM
      COMMON /D/ MINPM          !PMAG CLIP FLAG =1 OF PMAG IS A MIN, =0 OK
      REAL       PNORMN
      COMMON /D/ PNORMN         !L1 NORM FOR EVENT P MAG
      CHARACTER  PSOUR*1
      COMMON /C/ PSOUR          !PRINCIPAL DATA SOURCE FOR P MAGS

C--SECONDARY P AMPLITUDE MAGNITUDE (IE LOW GAIN)
      REAL       PAMAG2
      COMMON /D/ PAMAG2         !SECONDARY P AMPLITUDE MAGNITUDE FOR EVENT
      REAL       PAMAD2
      COMMON /D/ PAMAD2         !MEDIAN ABSOLUTE DIFFERENCE OF PMAG
      REAL       PMUSD2
      COMMON /D/ PMUSD2         !TOTAL OF WEIGHTS OF STATIONS USED IN PMAG
      REAL       PMCLP2
      COMMON /D/ PMCLP2         !TOT OF WEIGHTS OF CLIPPED STAS USED IN PMAG
      INTEGER    MINPM2
      COMMON /D/ MINPM2         !PMAG CLIP FLAG =1 OF PMAG IS A MIN, =0 OK
      REAL       PNRMN2
      COMMON /D/ PNRMN2         !L1 NORM FOR EVENT P MAG
      CHARACTER  PSOUR2*1
      COMMON /C/ PSOUR2         !PRINCIPAL DATA SOURCE FOR P MAGS
