/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/

package ewquakealert;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

/**
 *
 * @author RL197718
 */
public class WaveServer {


    WaveServer(){
        //Nothing...
        
        
    }

    public boolean getData(Vector<Phase> phases) {
        boolean output = true;
        //Method to acquire data from the waveserver

        //Establish connection to the waveserver
        Socket socket;
        BufferedReader Sinput;
        DataOutputStream Soutput;
        try {
            socket = new Socket(Configuration.waveserverIP, Configuration.waveserverPort);
            Sinput = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            Soutput = new DataOutputStream(socket.getOutputStream());
            EWQuakeAlertView.println("Connection to waveserver " +
                                        Configuration.waveserverIP + ": " + Configuration.waveserverPort +
                                        " has been established.");

        }
        catch (Exception e) {
            EWQuakeAlertView.println("Connection to waveserver " +
                    Configuration.waveserverIP + ": " + Configuration.waveserverPort +
                    " failed.");
            return false;
        }
        


        //Determine overall starttime and endtime
        double starttime = Double.MAX_VALUE;
        double endtime = 0;
        for (int i=0; i<phases.size(); i++) {
            if (phases.elementAt(i).StartTime<starttime) starttime = phases.elementAt(i).StartTime;
            if (phases.elementAt(i).EndTime>endtime) endtime = phases.elementAt(i).EndTime;
        }
        starttime = starttime/1000 - 15;
        endtime = endtime/1000 + 0;
        double aux = endtime - starttime;
        

        //Prepare number format for start and endtime
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("en", "US"));
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("#0.000000");

        
        //Try to get data from all stations in the vector
        for (int i=0; i<phases.size(); i++) {
            if (!phases.elementAt(i).dataRetrieved) {
                String Request = "GETSCNL: " + String.valueOf(i) + " " +
                        phases.elementAt(i).Sta + " " +
                        phases.elementAt(i).Chan + " " +
                        phases.elementAt(i).Net + " " +
                        phases.elementAt(i).Loc + " " +
                        df.format(starttime) + " " +
                        df.format(endtime)+ " " +
                        "0" + " " +
                        "SCNL" + (char)(byte)10;
                //System.out.println("<" + Request + ">");

                try {
                    //Try to get data
                    Soutput.writeBytes(Request);
                    //Wait for answer
                    String[] parts;
                    do {
                        String d = Sinput.readLine();
                        //System.out.println("<<" + d + ">>");
                        parts = d.split("\\s+");
                    } while (!parts[0].equals(String.valueOf(i)));

                    String flag = parts[6];

                    if (parts[6].equals("F")) {
                        //Return samples... store in ewChannel object
                        double data_starttime = Double.valueOf(parts[8]);
                        double samp_period = 1/Double.valueOf(parts[9]);
                        int[] samples = new int[parts.length - 10];
                        double[] time = new double[parts.length - 10];
                        for (int f=0; f<samples.length; f++) {
                            samples[f] = Integer.valueOf(parts[f+10]);
                            time[f] = starttime + (double)(f) * samp_period;
                        }
                        phases.elementAt(i).data = samples;
                        phases.elementAt(i).time = time;
                        phases.elementAt(i).dataRetrieved = true;
                    }
                    if (parts[6].equals("FR")) {
                        phases.elementAt(i).dataRetrieved = false;
                        output = false;
                    }
                    if (parts[6].equals("FL")) {
                        phases.elementAt(i).dataRetrieved = false;
                    }
                    if (parts[6].equals("FC")) {
                        phases.elementAt(i).dataRetrieved = false;
                    }
                    if (parts[6].equals("FN")) {
                        phases.elementAt(i).dataRetrieved = false;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    EWQuakeAlertView.println("Unable to retrieve data from waveserver.");
                    output = false;
                }
            }
        }
        try {
            socket.close();
            Sinput.close();
            Soutput.close();
            EWQuakeAlertView.println("Disconnected from waveserver " +
                    Configuration.waveserverIP + ": " + Configuration.waveserverPort);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        if (output)  {
            int wc = 0;
            for (int i=0; i<phases.size(); i++)
                if (phases.elementAt(i).dataRetrieved) wc++;
            EWQuakeAlertView.println("Retrieved " + wc + " waveforms from the waveserver.");
        }
        return output;
    }






    // Returns a generated image.





/*
    public class Phase {
        private long StartTime;
        private long CDuration;
        private long EndTime;
        private String Sta;
        private String Chan;
        private String Net;
        private String Loc = "--";

        private String P, FstMotion, Weight;

        private int[] data;
        private double[] time;

        private boolean dataRetrieved = false;
    }
*/
}
