/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.CORBANameParser;
import com.ooc.OB.HexConverter;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ObjectFactory;
import com.ooc.OB.TypeCodeFactory;
import com.ooc.OCI.Buffer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;

class CorbaURL {
    private String urlStr_;
    private String scheme_;
    private Vector addresses_;
    private byte[] key_;
    private int fragmentStartIdx_;
    private boolean rirURL_;
    private static final String iorPrefix_ = "ior";
    private static final String corbalocPrefix_ = "corbaloc";
    private static final String corbanamePrefix_ = "corbaname";
    private static final String filePrefix_ = "file";
    private static final String relfilePrefix_ = "relfile";
    private static final String iiopProt_ = "iiop:";
    private static final String iiopProtColon_ = ":";
    private static final String rirProt_ = "rir:";

    public CorbaURL(String string) {
        this.urlStr_ = string;
        this.parseScheme();
    }

    public Object toObject(ORBInstance oRBInstance) {
        if (this.scheme_.equals(iorPrefix_)) {
            return this.IORToObject(oRBInstance);
        }
        if (this.scheme_.equals(corbalocPrefix_)) {
            return this.CORBALOCToObject(oRBInstance);
        }
        if (this.scheme_.equals(corbanamePrefix_)) {
            return this.CORBANAMEToObject(oRBInstance);
        }
        if (this.scheme_.equals(filePrefix_)) {
            return this.OBFileToObject(oRBInstance, "/");
        }
        if (this.scheme_.equals(relfilePrefix_)) {
            return this.OBFileToObject(oRBInstance, null);
        }
        throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446343)) + ": `" + this.scheme_ + "'", 1330446343, CompletionStatus.COMPLETED_NO);
    }

    private Object OBFileToObject(ORBInstance oRBInstance, String string) {
        int n = this.scheme_.length() + 1;
        int n2 = 0;
        while (n2 < 3 && n < this.urlStr_.length()) {
            if (this.urlStr_.charAt(n) != '/') break;
            ++n2;
            ++n;
        }
        if (n >= this.urlStr_.length()) {
            throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": no file specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        String string2 = new String();
        if (string != null) {
            string2 = string;
        }
        string2 = String.valueOf(string2) + this.unescapeURL(this.urlStr_, n, -1);
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string3 = bufferedReader.readLine();
            fileInputStream.close();
            ObjectFactory objectFactory = oRBInstance.getObjectFactory();
            return objectFactory.stringToObject(string3);
        }
        catch (IOException iOException) {
            throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": file error", 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private Object CORBANAMEToObject(ORBInstance oRBInstance) {
        Object object = this.CORBALOCToObject(oRBInstance);
        if (this.fragmentStartIdx_ == -1) {
            return object;
        }
        try {
            DynAny dynAny;
            DynAny dynAny2;
            if (this.fragmentStartIdx_ + 1 >= this.urlStr_.length()) {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": stringified name is missing", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            InitialServiceManager initialServiceManager = oRBInstance.getInitialServiceManager();
            StructMember[] structMemberArray = new StructMember[2];
            structMemberArray[0] = new StructMember();
            structMemberArray[0].name = "id";
            structMemberArray[0].type = TypeCodeFactory.createStringTC(0);
            structMemberArray[1] = new StructMember();
            structMemberArray[1].name = "kind";
            structMemberArray[1].type = TypeCodeFactory.createStringTC(0);
            TypeCode typeCode = TypeCodeFactory.createStructTC("IDL:omg.org/CosNaming/NameComponent:1.0", "NameComponent", structMemberArray);
            TypeCode typeCode2 = TypeCodeFactory.createSequenceTC(0, typeCode);
            String string = this.unescapeURL(this.urlStr_, this.fragmentStartIdx_ + 1, -1);
            byte[] byArray = this.strToKey(string);
            CORBANameParser cORBANameParser = new CORBANameParser(byArray);
            if (!cORBANameParser.isValid()) {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": stringified name is invalid", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            String[] stringArray = cORBANameParser.getContents();
            Object object2 = initialServiceManager.resolveInitialReferences("DynAnyFactory");
            DynAnyFactory dynAnyFactory = DynAnyFactoryHelper.narrow(object2);
            Any[] anyArray = new Any[stringArray.length / 2];
            int n = 0;
            while (n < stringArray.length) {
                dynAny2 = dynAnyFactory.create_dyn_any_from_type_code(typeCode);
                dynAny = DynStructHelper.narrow(dynAny2);
                dynAny.insert_string(stringArray[n]);
                dynAny.next();
                dynAny.insert_string(stringArray[n + 1]);
                anyArray[n / 2] = dynAny.to_any();
                n += 2;
            }
            dynAny2 = dynAnyFactory.create_dyn_any_from_type_code(typeCode2);
            dynAny = DynSequenceHelper.narrow(dynAny2);
            dynAny.set_length(anyArray.length);
            dynAny.set_elements(anyArray);
            Request request = object._request("resolve");
            Any any = request.add_in_arg();
            Any any2 = dynAny.to_any();
            any.read_value(any2.create_input_stream(), any2.type());
            dynAny.destroy();
            request.set_return_type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_objref));
            request.invoke();
            if (request.env().exception() == null) {
                return request.return_value().extract_Object();
            }
        }
        catch (SystemException systemException) {
        }
        catch (UserException userException) {}
        throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": corbaname evaluation error", 1330446346, CompletionStatus.COMPLETED_NO);
    }

    private Object CORBALOCToObject(ORBInstance oRBInstance) {
        java.lang.Object object;
        int n = this.parseCORBALOCAddresses();
        if (this.addresses_.size() == 0) {
            throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": no protocol address", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        String string = null;
        if (n != -1 && this.urlStr_.charAt(n) == '/') {
            int n2 = n + 1;
            this.fragmentStartIdx_ = this.parseKey(n2);
            string = this.fragmentStartIdx_ == -1 ? this.urlStr_.substring(n2) : this.urlStr_.substring(n2, this.fragmentStartIdx_);
        } else if (n == -1 || this.urlStr_.charAt(n) == '#') {
            this.fragmentStartIdx_ = n;
            string = this.rirURL_ || this.scheme_.equals(corbanamePrefix_) ? "NameService" : "";
            this.key_ = this.strToKey(string);
        }
        if (string.length() == 0) {
            throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": no key specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        if (this.rirURL_) {
            try {
                InitialServiceManager initialServiceManager = oRBInstance.getInitialServiceManager();
                return initialServiceManager.resolveInitialReferences(string);
            }
            catch (InvalidName invalidName) {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": invalid initial reference token", 1330446345, CompletionStatus.COMPLETED_NO);
            }
        }
        IOR iOR = new IOR();
        iOR.type_id = "";
        iOR.profiles = new TaggedProfile[this.addresses_.size()];
        int n3 = 0;
        while (n3 < this.addresses_.size()) {
            object = (URLAddr)this.addresses_.elementAt(n3);
            ((URLAddr)object).setProfile(iOR, n3, this.key_);
            ++n3;
        }
        object = oRBInstance.getObjectFactory();
        return ((ObjectFactory)object).createObject(iOR);
    }

    private int parseKey(int n) {
        int n2 = this.urlStr_.indexOf(35, n);
        int n3 = n2 != -1 ? n2 : this.urlStr_.length();
        String string = this.unescapeURL(this.urlStr_, n, n3);
        this.key_ = this.strToKey(string);
        return n2;
    }

    private byte[] strToKey(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < byArray.length) {
            if (string.charAt(n) > '\u00ff') {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": key string characters out of range", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        return byArray;
    }

    private int parseCORBALOCAddresses() {
        int n = this.scheme_.length() + 1;
        if (n >= this.urlStr_.length()) {
            throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": incomplete, only scheme specified", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        this.rirURL_ = false;
        String string = this.urlStr_.substring(n);
        int n2 = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",/#", true);
        this.addresses_ = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) continue;
            if (string2.equals("#") || string2.equals("/")) {
                n2 = this.urlStr_.indexOf(string2.charAt(0));
                break;
            }
            this.addresses_.addElement(this.parseSingleProtocolAddr(string2));
        }
        return n2;
    }

    private Object IORToObject(ORBInstance oRBInstance) {
        byte[] byArray = HexConverter.asciiToOctets(this.urlStr_, 4);
        if (byArray == null) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345), 1330446345, CompletionStatus.COMPLETED_NO);
        }
        try {
            Buffer buffer = new Buffer(byArray, byArray.length);
            InputStream inputStream = new InputStream(buffer, 0, false, null, false);
            inputStream._OB_readEndian();
            ObjectFactory objectFactory = oRBInstance.getObjectFactory();
            return objectFactory.createObject(IORHelper.read(inputStream));
        }
        catch (MARSHAL mARSHAL) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345), 1330446345, CompletionStatus.COMPLETED_NO);
        }
    }

    private void parseScheme() {
        int n = -1;
        if (this.urlStr_ != null) {
            n = this.urlStr_.indexOf(58);
        }
        if (n == -1) {
            throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": no scheme found", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        this.scheme_ = this.urlStr_.substring(0, n).toLowerCase();
    }

    URLAddr parseSingleProtocolAddr(String string) {
        if ((string = this.unescapeURL(string, 0, -1)).startsWith(iiopProt_) || string.startsWith(iiopProtColon_)) {
            return new IIOPAddr(string);
        }
        if (string.startsWith(rirProt_)) {
            this.rirURL_ = true;
            return new RIRAddr(string);
        }
        throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446345)) + ": unknown protocol", 1330446345, CompletionStatus.COMPLETED_NO);
    }

    public String unescapeURL(String string, int n, int n2) {
        if (n2 == -1) {
            n2 = string.length();
        }
        char[] cArray = new char[n2 - n];
        int n3 = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '%') {
                if (n + 2 >= n2) {
                    throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446344)) + ": bad escape sequence length", 1330446344, CompletionStatus.COMPLETED_NO);
                }
                int n4 = Character.digit(string.charAt(++n), 16);
                int n5 = Character.digit(string.charAt(++n), 16);
                if (n4 == -1 || n5 == -1) {
                    throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": escape sequence contains invalid characters", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                c = (char)(n4 << 4 | n5);
            }
            cArray[n3++] = c;
            ++n;
        }
        return new String(cArray, 0, n3);
    }

    public static abstract class URLAddr {
        public abstract String getProtocolName();

        public abstract void setProfile(IOR var1, int var2, byte[] var3);
    }

    public static class RIRAddr
    extends URLAddr {
        public RIRAddr(String string) {
            if (string.length() > rirProt_.length()) {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": rir protocol does not allow an address", 1330446346, CompletionStatus.COMPLETED_NO);
            }
        }

        public String getProtocolName() {
            return rirProt_;
        }

        public void setProfile(IOR iOR, int n, byte[] byArray) {
            Assert.assert(false);
        }
    }

    public static class IIOPAddr
    extends URLAddr {
        private int major_;
        private int minor_;
        private String host_;
        private int port_;
        public static final int DEFAULT_PORT = 2809;

        public IIOPAddr(String string) {
            String string2;
            int n;
            int n2 = string.length();
            int n3 = string.charAt(0) == iiopProtColon_.charAt(0) ? iiopProtColon_.length() : iiopProt_.length();
            int n4 = string.indexOf(64, n3);
            if (n4 == -1) {
                this.major_ = 1;
                this.minor_ = 0;
            } else {
                n = string.indexOf(46, n3);
                if (n == -1) {
                    throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": iiop version must be of the form `X.Y@'", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                try {
                    string2 = string.substring(n3, n);
                    this.major_ = Integer.parseInt(string2);
                    string2 = string.substring(n + 1, n4);
                    this.minor_ = Integer.parseInt(string2);
                    if (this.major_ < 1 || this.major_ > 1 || this.minor_ < 0 || this.minor_ > 255) {
                        throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": iiop version unsupported `" + this.major_ + "." + this.minor_ + "'", 1330446346, CompletionStatus.COMPLETED_NO);
                    }
                    if (this.minor_ > 2) {
                        this.minor_ = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": iiop version format error", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                n3 = n4 + 1;
            }
            if (n3 >= n2 || string.charAt(n3) == ':') {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": iiop host must be specified", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            n = string.indexOf(58, n3);
            this.host_ = string.substring(n3, n == -1 ? n2 : n);
            if (n == -1) {
                this.port_ = 2809;
                return;
            }
            string2 = string.substring(n + 1, n2);
            try {
                this.port_ = Integer.parseInt(string2);
                if (this.port_ < 1 || this.port_ > 65535) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new BAD_PARAM(String.valueOf(MinorCodes.describeBadParam(1330446346)) + ": iiop bad port number " + string2, 1330446346, CompletionStatus.COMPLETED_NO);
            }
        }

        public String getProtocolName() {
            return iiopProtColon_;
        }

        public void setProfile(IOR iOR, int n, byte[] byArray) {
            Version version = new Version((byte)this.major_, (byte)this.minor_);
            short s = this.port_ > 32768 ? (short)(this.port_ - 65535 - 1) : (short)this.port_;
            iOR.profiles[n] = new TaggedProfile();
            iOR.profiles[n].tag = 0;
            if (this.major_ == 1 && this.minor_ == 0) {
                ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0();
                profileBody_1_0.iiop_version = version;
                profileBody_1_0.host = this.host_;
                profileBody_1_0.port = s;
                profileBody_1_0.object_key = byArray;
                Buffer buffer = new Buffer();
                OutputStream outputStream = new OutputStream(buffer);
                outputStream._OB_writeEndian();
                ProfileBody_1_0Helper.write(outputStream, profileBody_1_0);
                iOR.profiles[n].profile_data = new byte[buffer.length()];
                System.arraycopy(buffer.data(), 0, iOR.profiles[n].profile_data, 0, buffer.length());
                return;
            }
            ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1();
            profileBody_1_1.iiop_version = version;
            profileBody_1_1.host = this.host_;
            profileBody_1_1.port = s;
            profileBody_1_1.object_key = byArray;
            profileBody_1_1.components = new TaggedComponent[0];
            Buffer buffer = new Buffer();
            OutputStream outputStream = new OutputStream(buffer);
            outputStream._OB_writeEndian();
            ProfileBody_1_1Helper.write(outputStream, profileBody_1_1);
            iOR.profiles[n].profile_data = new byte[buffer.length()];
            System.arraycopy(buffer.data(), 0, iOR.profiles[n].profile_data, 0, buffer.length());
        }
    }
}

