/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.OB.Assert;
import com.ooc.OB.LocationForward;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.PIManager;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OBPortableServer.DefaultServantHolder;
import com.ooc.OBPortableServer.DirectSeqEntry;
import com.ooc.OBPortableServer.DirectServant;
import com.ooc.OBPortableServer.ObjectIdHasher;
import com.ooc.OBPortableServer.POAPolicies;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OBPortableServer.ServantLocationStrategy;
import com.ooc.OBPortableServer.ServantManagerStrategy;
import com.ooc.OBPortableServer.TableEntry;
import com.ooc.PortableServer.Current_impl;
import java.util.Hashtable;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManagerOperations;

class ActiveObjectOnlyStrategy
implements ServantLocationStrategy {
    protected Hashtable activeObjectTable_ = new Hashtable(1023);
    protected Hashtable servantIdTable_;
    private Hashtable directSeqTable_ = new Hashtable(1023);
    private ORBInstance orbInstance_;

    protected void completeActivation(ObjectIdHasher objectIdHasher, Servant servant) {
        Hashtable hashtable = this.directSeqTable_;
        synchronized (hashtable) {
            DirectSeqEntry directSeqEntry = (DirectSeqEntry)this.directSeqTable_.get(objectIdHasher);
            if (directSeqEntry != null) {
                directSeqEntry.deactivate();
                this.directSeqTable_.remove(objectIdHasher);
            }
        }
        if (this.servantIdTable_ != null) {
            Assert.assert(!this.servantIdTable_.containsKey(servant));
            this.servantIdTable_.put(servant, objectIdHasher.getObjectId());
        }
        ((ORB)this.orbInstance_.getORB()).set_delegate(servant);
    }

    protected void completeDeactivate(POA pOA, ObjectIdHasher objectIdHasher, TableEntry tableEntry) {
        Assert.assert(tableEntry.getOutstandingRequests() == 0);
        Assert.assert(!tableEntry.active());
        Object object = this.directSeqTable_;
        synchronized (object) {
            DirectSeqEntry directSeqEntry = (DirectSeqEntry)this.directSeqTable_.get(objectIdHasher);
            if (directSeqEntry != null) {
                directSeqEntry.deactivate();
                this.directSeqTable_.remove(objectIdHasher);
            }
        }
        if (this.servantIdTable_ != null) {
            object = tableEntry.getServant();
            Assert.assert(this.servantIdTable_.containsKey(object));
            this.servantIdTable_.remove(object);
        }
        tableEntry.clearServant();
        tableEntry.setDeactivated();
        this.activeObjectTable_.remove(objectIdHasher);
    }

    protected DirectServant completeDirectStubImpl(POA pOA, byte[] byArray, Servant servant, RefCountPolicyList refCountPolicyList) {
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        if (servant instanceof DynamicImplementation) {
            return null;
        }
        boolean bl = servant instanceof ServantManagerOperations;
        PIManager pIManager = this.orbInstance_.getPIManager();
        if (!bl && (refCountPolicyList.locationTransparency == 0 || pIManager.haveClientInterceptors() || pIManager.haveServerInterceptors())) {
            return null;
        }
        DirectServant directServant = new DirectServant((POA_impl)pOA, objectIdHasher.getObjectId(), servant);
        Hashtable hashtable = this.directSeqTable_;
        synchronized (hashtable) {
            DirectSeqEntry directSeqEntry = (DirectSeqEntry)this.directSeqTable_.get(objectIdHasher);
            if (directSeqEntry == null) {
                directSeqEntry = new DirectSeqEntry(objectIdHasher.getObjectId());
                this.directSeqTable_.put(objectIdHasher, directSeqEntry);
            }
            directSeqEntry.add(directServant);
        }
        return directServant;
    }

    ActiveObjectOnlyStrategy(POAPolicies pOAPolicies, ORBInstance oRBInstance) {
        this.orbInstance_ = oRBInstance;
        if (pOAPolicies.idUniquenessPolicy() == IdUniquenessPolicyValue.UNIQUE_ID) {
            this.servantIdTable_ = new Hashtable(1023);
            return;
        }
        this.servantIdTable_ = null;
    }

    public void destroy(POA pOA, boolean bl) {
        this.activeObjectTable_.clear();
        this.directSeqTable_.clear();
        if (this.servantIdTable_ != null) {
            this.servantIdTable_.clear();
        }
    }

    public void etherealize(POA pOA) {
    }

    public void activate(byte[] byArray, Servant servant) throws ServantAlreadyActive, WrongPolicy, ObjectAlreadyActive {
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        while (true) {
            Object var6_6;
            Object object;
            TableEntry tableEntry;
            if ((tableEntry = (TableEntry)this.activeObjectTable_.get(objectIdHasher)) != null) {
                object = tableEntry;
                synchronized (object) {
                    if (!tableEntry.active()) {
                        tableEntry.waitDeactivated();
                        var6_6 = null;
                        continue;
                    }
                    throw new ObjectAlreadyActive();
                }
            }
            object = this.activeObjectTable_;
            synchronized (object) {
                if (this.servantIdTable_ != null && this.servantIdTable_.containsKey(servant)) {
                    throw new ServantAlreadyActive();
                }
                if (!this.activeObjectTable_.containsKey(objectIdHasher)) {
                    tableEntry = new TableEntry(servant);
                    this.activeObjectTable_.put(objectIdHasher, tableEntry);
                    this.completeActivation(objectIdHasher, servant);
                    var6_6 = null;
                    return;
                }
            }
        }
    }

    public void deactivate(POA pOA, byte[] byArray) throws ObjectNotActive, WrongPolicy {
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        TableEntry tableEntry = (TableEntry)this.activeObjectTable_.get(objectIdHasher);
        if (tableEntry != null) {
            TableEntry tableEntry2 = tableEntry;
            synchronized (tableEntry2) {
                if (tableEntry.active()) {
                    tableEntry.setDeactivatePending();
                    if (tableEntry.getOutstandingRequests() == 0) {
                        this.completeDeactivate(pOA, objectIdHasher, tableEntry);
                    }
                }
                return;
            }
        }
        throw new ObjectNotActive();
    }

    public byte[] servantToId(Servant servant, Current_impl current_impl) {
        byte[] byArray = null;
        if (this.servantIdTable_ != null) {
            byArray = (byte[])this.servantIdTable_.get(servant);
        }
        return byArray;
    }

    public Servant idToServant(byte[] byArray, boolean bl) {
        TableEntry tableEntry;
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        while ((tableEntry = (TableEntry)this.activeObjectTable_.get(objectIdHasher)) != null) {
            TableEntry tableEntry2 = tableEntry;
            synchronized (tableEntry2) {
                Object var7_6;
                if (!tableEntry.active()) {
                    tableEntry.waitDeactivated();
                    var7_6 = null;
                    continue;
                }
                Servant servant = tableEntry.getServant();
                var7_6 = null;
                return servant;
            }
        }
        return null;
    }

    public Servant locate(byte[] byArray, POA pOA, String string, CookieHolder cookieHolder) throws LocationForward {
        TableEntry tableEntry;
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        while ((tableEntry = (TableEntry)this.activeObjectTable_.get(objectIdHasher)) != null) {
            TableEntry tableEntry2 = tableEntry;
            synchronized (tableEntry2) {
                Object var9_8;
                if (!tableEntry.active()) {
                    tableEntry.waitDeactivated();
                    var9_8 = null;
                    continue;
                }
                Servant servant = tableEntry.getServant();
                var9_8 = null;
                return servant;
            }
        }
        throw new OBJECT_NOT_EXIST();
    }

    public void preinvoke(byte[] byArray) {
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        TableEntry tableEntry = (TableEntry)this.activeObjectTable_.get(objectIdHasher);
        if (tableEntry != null) {
            TableEntry tableEntry2 = tableEntry;
            synchronized (tableEntry2) {
                tableEntry.incOutstandingRequest();
                return;
            }
        }
    }

    public void postinvoke(byte[] byArray, POA pOA, String string, Object object, Servant servant) {
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        TableEntry tableEntry = (TableEntry)this.activeObjectTable_.get(objectIdHasher);
        if (tableEntry != null) {
            TableEntry tableEntry2 = tableEntry;
            synchronized (tableEntry2) {
                if (tableEntry.decOutstandingRequest() == 0 && !tableEntry.active()) {
                    this.completeDeactivate(pOA, objectIdHasher, tableEntry);
                }
                return;
            }
        }
    }

    public DirectServant createDirectStubImpl(POA pOA, byte[] byArray, RefCountPolicyList refCountPolicyList) throws LocationForward {
        try {
            CookieHolder cookieHolder = null;
            Servant servant = this.locate(byArray, pOA, "", cookieHolder);
            return this.completeDirectStubImpl(pOA, byArray, servant, refCountPolicyList);
        }
        catch (SystemException systemException) {
            return null;
        }
    }

    public void removeDirectStubImpl(byte[] byArray, DirectServant directServant) {
        ObjectIdHasher objectIdHasher = new ObjectIdHasher(byArray);
        Hashtable hashtable = this.directSeqTable_;
        synchronized (hashtable) {
            DirectSeqEntry directSeqEntry = (DirectSeqEntry)this.directSeqTable_.get(objectIdHasher);
            if (directSeqEntry != null && directSeqEntry.remove(directServant)) {
                this.directSeqTable_.remove(objectIdHasher);
            }
            return;
        }
    }

    public ServantManagerStrategy getServantManagerStrategy() {
        return null;
    }

    public DefaultServantHolder getDefaultServantHolder() {
        return null;
    }
}

