/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.OB.DispatchStrategy;
import com.ooc.OB.DispatchStrategyFactory;
import com.ooc.OB.ORBInstance;
import com.ooc.OBPortableServer.DispatchStrategyPolicyHelper;
import com.ooc.OBPortableServer.DispatchStrategyPolicy_impl;
import com.ooc.OBPortableServer.InterceptorCallPolicyHelper;
import com.ooc.OBPortableServer.InterceptorCallPolicy_impl;
import com.ooc.OBPortableServer.SynchronizationPolicyHelper;
import com.ooc.OBPortableServer.SynchronizationPolicyValue;
import com.ooc.OBPortableServer.SynchronizationPolicy_impl;
import com.ooc.PortableServer.IdAssignmentPolicy_impl;
import com.ooc.PortableServer.IdUniquenessPolicy_impl;
import com.ooc.PortableServer.ImplicitActivationPolicy_impl;
import com.ooc.PortableServer.LifespanPolicy_impl;
import com.ooc.PortableServer.RequestProcessingPolicy_impl;
import com.ooc.PortableServer.ServantRetentionPolicy_impl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyHelper;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyHelper;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyHelper;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.RequestProcessingPolicyHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyHelper;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyHelper;
import org.omg.PortableServer.ThreadPolicyValue;

public final class POAPolicies {
    private boolean interceptorCallPolicyValue_ = true;
    private SynchronizationPolicyValue synchronizationPolicyValue_ = SynchronizationPolicyValue.NO_SYNCHRONIZATION;
    private DispatchStrategy dispatchStrategyPolicyValue_ = null;
    private LifespanPolicyValue lifespanPolicyValue_ = LifespanPolicyValue.TRANSIENT;
    private IdUniquenessPolicyValue idUniquenessPolicyValue_ = IdUniquenessPolicyValue.UNIQUE_ID;
    private IdAssignmentPolicyValue idAssignmentPolicyValue_ = IdAssignmentPolicyValue.SYSTEM_ID;
    private ImplicitActivationPolicyValue implicitActivationPolicyValue_ = ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION;
    private ServantRetentionPolicyValue servantRetentionPolicyValue_ = ServantRetentionPolicyValue.RETAIN;
    private RequestProcessingPolicyValue requestProcessingPolicyValue_ = RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY;

    POAPolicies(ORBInstance oRBInstance, Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            Policy policy;
            int n2 = policyArray[n].policy_type();
            if (n2 == 16) {
                policy = ThreadPolicyHelper.narrow(policyArray[n]);
                this.synchronizationPolicyValue_ = policy.value() == ThreadPolicyValue.ORB_CTRL_MODEL ? SynchronizationPolicyValue.NO_SYNCHRONIZATION : SynchronizationPolicyValue.SYNCHRONIZE_ON_ORB;
            } else if (n2 == 17) {
                policy = LifespanPolicyHelper.narrow(policyArray[n]);
                this.lifespanPolicyValue_ = policy.value();
            } else if (n2 == 18) {
                policy = IdUniquenessPolicyHelper.narrow(policyArray[n]);
                this.idUniquenessPolicyValue_ = policy.value();
            } else if (n2 == 19) {
                policy = IdAssignmentPolicyHelper.narrow(policyArray[n]);
                this.idAssignmentPolicyValue_ = policy.value();
            } else if (n2 == 20) {
                policy = ImplicitActivationPolicyHelper.narrow(policyArray[n]);
                this.implicitActivationPolicyValue_ = policy.value();
            } else if (n2 == 21) {
                policy = ServantRetentionPolicyHelper.narrow(policyArray[n]);
                this.servantRetentionPolicyValue_ = policy.value();
            } else if (n2 == 22) {
                policy = RequestProcessingPolicyHelper.narrow(policyArray[n]);
                this.requestProcessingPolicyValue_ = policy.value();
            } else if (n2 == 1330577665) {
                policy = SynchronizationPolicyHelper.narrow(policyArray[n]);
                this.synchronizationPolicyValue_ = policy.value();
            } else if (n2 == 1330577666) {
                policy = DispatchStrategyPolicyHelper.narrow(policyArray[n]);
                this.dispatchStrategyPolicyValue_ = policy.value();
            } else if (n2 == 1330577667) {
                policy = InterceptorCallPolicyHelper.narrow(policyArray[n]);
                this.interceptorCallPolicyValue_ = policy.value();
            } else {
                throw new BAD_PARAM("Unknown policy type: " + n2);
            }
            ++n;
        }
        if (this.dispatchStrategyPolicyValue_ == null) {
            DispatchStrategyFactory dispatchStrategyFactory = oRBInstance.getDispatchStrategyFactory();
            this.dispatchStrategyPolicyValue_ = dispatchStrategyFactory.create_default_dispatch_strategy();
        }
    }

    public boolean interceptorCallPolicy() {
        return this.interceptorCallPolicyValue_;
    }

    public SynchronizationPolicyValue synchronizationPolicy() {
        return this.synchronizationPolicyValue_;
    }

    public DispatchStrategy dispatchStrategyPolicy() {
        return this.dispatchStrategyPolicyValue_;
    }

    public LifespanPolicyValue lifespanPolicy() {
        return this.lifespanPolicyValue_;
    }

    public IdUniquenessPolicyValue idUniquenessPolicy() {
        return this.idUniquenessPolicyValue_;
    }

    public IdAssignmentPolicyValue idAssignmentPolicy() {
        return this.idAssignmentPolicyValue_;
    }

    public ImplicitActivationPolicyValue implicitActivationPolicy() {
        return this.implicitActivationPolicyValue_;
    }

    public ServantRetentionPolicyValue servantRetentionPolicy() {
        return this.servantRetentionPolicyValue_;
    }

    public RequestProcessingPolicyValue requestProcessingPolicy() {
        return this.requestProcessingPolicyValue_;
    }

    public Policy[] recreate() {
        Policy[] policyArray = new Policy[10];
        int n = 0;
        policyArray[n++] = new LifespanPolicy_impl(this.lifespanPolicyValue_);
        policyArray[n++] = new IdUniquenessPolicy_impl(this.idUniquenessPolicyValue_);
        policyArray[n++] = new IdAssignmentPolicy_impl(this.idAssignmentPolicyValue_);
        policyArray[n++] = new ImplicitActivationPolicy_impl(this.implicitActivationPolicyValue_);
        policyArray[n++] = new ServantRetentionPolicy_impl(this.servantRetentionPolicyValue_);
        policyArray[n++] = new RequestProcessingPolicy_impl(this.requestProcessingPolicyValue_);
        policyArray[n++] = new SynchronizationPolicy_impl(this.synchronizationPolicyValue_);
        policyArray[n++] = new DispatchStrategyPolicy_impl(this.dispatchStrategyPolicyValue_);
        policyArray[n] = new InterceptorCallPolicy_impl(this.interceptorCallPolicyValue_);
        return policyArray;
    }
}

