/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OCI.IIOP;

import com.ooc.CORBA.LocalObject;
import com.ooc.OB.MinorCodes;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.Connector;
import com.ooc.OCI.IIOP.InternalError;
import com.ooc.OCI.IIOP.TransportInfo_impl;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;

final class Transport_impl
extends LocalObject
implements Transport {
    Socket socket_;
    private InputStream in_;
    private boolean shutdown_;
    private int soTimeout_;
    private TransportInfo_impl info_;
    static /* synthetic */ Class class$java$net$Socket;

    private void setSoTimeout(int n) {
        if (this.soTimeout_ != n) {
            this.soTimeout_ = n;
            try {
                this.socket_.setSoTimeout(this.soTimeout_);
                return;
            }
            catch (SocketException socketException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577434)) + ": socket error during setSoTimeout: " + socketException.toString(), 1330577434, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException nullPointerException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577434)) + ": NullPointerException error during setSoTimeout: " + nullPointerException.toString(), 1330577434, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private void setBlock(boolean bl) {
        if (bl) {
            this.setSoTimeout(0);
            return;
        }
        this.setSoTimeout(1);
    }

    private static boolean shutdownSocket(Socket socket, int n) {
        if (socket == null) {
            return true;
        }
        if (n == 2) {
            return Transport_impl.shutdownSocket(socket, 0) && Transport_impl.shutdownSocket(socket, 1);
        }
        String string = null;
        if (n == 0) {
            string = "shutdownInput";
        } else if (n == 1) {
            string = "shutdownOutput";
        } else {
            throw new InternalError();
        }
        try {
            Class clazz = class$java$net$Socket != null ? class$java$net$Socket : (class$java$net$Socket = Transport_impl.class$("java.net.Socket"));
            Method method = clazz.getMethod(string, new Class[0]);
            Object[] objectArray = new Object[]{};
            method.invoke((Object)socket, objectArray);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InternalError(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SocketException) {
                return true;
            }
            throw new InternalError(throwable.toString());
        }
        return false;
    }

    public int id() {
        return 1330577409;
    }

    public int tag() {
        return 0;
    }

    public int handle() {
        throw new NO_IMPLEMENT();
    }

    public void close() {
        if (this.socket_ == null) {
            return;
        }
        this.info_._OB_callCloseCB(this.info_);
        this.info_._OB_destroy();
        Socket socket = this.socket_;
        this.socket_ = null;
        Transport_impl.shutdownSocket(socket, 2);
        try {
            socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void shutdown() {
        if (!Transport_impl.shutdownSocket(this.socket_, 1)) {
            this.close();
        }
    }

    public void receive(Buffer buffer, boolean bl) {
        this.setBlock(bl);
        while (!buffer.is_full()) {
            try {
                int n = this.in_.read(buffer.data(), buffer.pos(), buffer.rest_length());
                if (n <= 0) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577411), 1330577411, CompletionStatus.COMPLETED_NO);
                }
                buffer.advance(n);
            }
            catch (InterruptedIOException interruptedIOException) {
                buffer.advance(interruptedIOException.bytesTransferred);
                if (bl) continue;
                return;
            }
            catch (IOException iOException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577409)) + ": I/O error during read: " + iOException.toString(), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException nullPointerException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577409)) + ": NullPointerException during read", 1330577409, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public boolean receive_detect(Buffer buffer, boolean bl) {
        this.setBlock(bl);
        while (!buffer.is_full()) {
            try {
                int n = this.in_.read(buffer.data(), buffer.pos(), buffer.rest_length());
                if (n <= 0) {
                    return false;
                }
                buffer.advance(n);
            }
            catch (InterruptedIOException interruptedIOException) {
                buffer.advance(interruptedIOException.bytesTransferred);
                if (bl) continue;
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return true;
    }

    public void receive_timeout(Buffer buffer, int n) {
        if (n < 0) {
            throw new InternalError();
        }
        if (n < 1) {
            n = 1;
        }
        this.setSoTimeout(n);
        while (!buffer.is_full()) {
            try {
                int n2 = this.in_.read(buffer.data(), buffer.pos(), buffer.rest_length());
                if (n2 <= 0) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577411), 1330577411, CompletionStatus.COMPLETED_NO);
                }
                buffer.advance(n2);
            }
            catch (InterruptedIOException interruptedIOException) {
                buffer.advance(interruptedIOException.bytesTransferred);
                return;
            }
            catch (IOException iOException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577409)) + ": I/O error during read: " + iOException.toString(), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException nullPointerException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577409)) + ": NullPointerException during read", 1330577409, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public void send(Buffer buffer, boolean bl) {
        this.setBlock(bl);
        while (!buffer.is_full()) {
            try {
                OutputStream outputStream = this.socket_.getOutputStream();
                outputStream.write(buffer.data(), buffer.pos(), buffer.rest_length());
                outputStream.flush();
                buffer.pos(buffer.length());
            }
            catch (InterruptedIOException interruptedIOException) {
                buffer.advance(interruptedIOException.bytesTransferred);
                if (bl) continue;
                return;
            }
            catch (IOException iOException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577410)) + ": I/O error during write: " + iOException.toString(), 1330577410, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException nullPointerException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577410)) + ": NullPointerException during write", 1330577410, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public boolean send_detect(Buffer buffer, boolean bl) {
        this.setBlock(bl);
        while (!buffer.is_full()) {
            try {
                OutputStream outputStream = this.socket_.getOutputStream();
                outputStream.write(buffer.data(), buffer.pos(), buffer.rest_length());
                outputStream.flush();
                buffer.pos(buffer.length());
            }
            catch (InterruptedIOException interruptedIOException) {
                buffer.advance(interruptedIOException.bytesTransferred);
                if (bl) continue;
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return true;
    }

    public void send_timeout(Buffer buffer, int n) {
        if (n < 0) {
            throw new InternalError();
        }
        if (n < 1) {
            n = 1;
        }
        this.setSoTimeout(n);
        while (!buffer.is_full()) {
            try {
                OutputStream outputStream = this.socket_.getOutputStream();
                outputStream.write(buffer.data(), buffer.pos(), buffer.rest_length());
                outputStream.flush();
                buffer.pos(buffer.length());
            }
            catch (InterruptedIOException interruptedIOException) {
                buffer.advance(interruptedIOException.bytesTransferred);
                return;
            }
            catch (IOException iOException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577410)) + ": I/O error during write: " + iOException.toString(), 1330577410, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException nullPointerException) {
                throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577410)) + ": NullPointerException during write", 1330577410, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public TransportInfo get_info() {
        return this.info_;
    }

    public Transport_impl(Connector connector, Socket socket) {
        this.socket_ = socket;
        this.shutdown_ = false;
        try {
            this.in_ = this.socket_.getInputStream();
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577413)) + ": unable to obtain socket InputStream: " + iOException.toString(), 1330577413, CompletionStatus.COMPLETED_NO);
        }
        this.info_ = new TransportInfo_impl(this, connector);
    }

    public Transport_impl(Acceptor acceptor, Socket socket) {
        this.socket_ = socket;
        this.shutdown_ = false;
        try {
            this.in_ = this.socket_.getInputStream();
        }
        catch (IOException iOException) {
            throw new COMM_FAILURE(String.valueOf(MinorCodes.describeCommFailure(1330577413)) + ": unable to obtain socket InputStream: " + iOException.toString(), 1330577413, CompletionStatus.COMPLETED_NO);
        }
        this.info_ = new TransportInfo_impl(this, acceptor);
    }

    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        super.finalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

