/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.event.MagnitudeUtil;
import edu.iris.Fissures.model.LocationUtil;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.ParameterRefUtil;
import edu.iris.Fissures.model.UnitImpl;

public class OriginImpl
extends Origin {
    private MicroSecondDate time;

    private OriginImpl() {
    }

    public static OriginImpl createEmpty() {
        return new OriginImpl();
    }

    public OriginImpl(String id, String catalog, String contributor, Time origin_time, Location my_location, Magnitude[] magnitudes, ParameterRef[] parm_ids) {
        this.id = id;
        this.catalog = catalog;
        this.contributor = contributor;
        this.origin_time = origin_time;
        this.my_location = my_location;
        this.magnitudes = magnitudes;
        this.parm_ids = parm_ids;
    }

    public String get_id() {
        return this.id;
    }

    public boolean equals(Object o) {
        OriginImpl oOrigin;
        if (o == this) {
            return true;
        }
        return o instanceof OriginImpl && this.equalsExceptTime(oOrigin = (OriginImpl)o) && oOrigin.getTime().equals(this.getTime());
    }

    public boolean equalsExceptTime(OriginImpl oOrigin) {
        if (oOrigin == this) {
            return true;
        }
        return LocationUtil.areEqual(oOrigin.my_location, this.my_location) && oOrigin.catalog.equals(this.catalog) && oOrigin.contributor.equals(this.contributor) && MagnitudeUtil.areEqual(this.magnitudes, oOrigin.magnitudes) && ParameterRefUtil.areEqual(this.parm_ids, oOrigin.parm_ids);
    }

    public boolean close(OriginImpl oOrigin) {
        if (oOrigin == this) {
            return true;
        }
        if (this.equalsExceptTime(oOrigin)) {
            MicroSecondDate myOTime = new MicroSecondDate(this.origin_time);
            MicroSecondDate eventOTime = new MicroSecondDate(oOrigin.origin_time);
            if (myOTime.subtract((MicroSecondDate)eventOTime).convertTo((UnitImpl)UnitImpl.MICROSECOND).value < 1000.0) {
                return true;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 29;
        result += 89 * result + LocationUtil.hash(this.my_location);
        result += 89 * result + this.getTime().hashCode();
        result += 89 * result + this.contributor.hashCode();
        result += 89 * result + this.catalog.hashCode();
        result += 89 * result + ParameterRefUtil.hash(this.parm_ids);
        result += 89 * result + MagnitudeUtil.hash(this.magnitudes);
        return result;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getContributor() {
        return this.contributor;
    }

    public Time getFissuresTime() {
        return this.origin_time;
    }

    public Location getLocation() {
        return this.my_location;
    }

    public Magnitude[] getMagnitudes() {
        return this.magnitudes;
    }

    public MicroSecondDate getTime() {
        if (this.time == null) {
            this.time = new MicroSecondDate(this.origin_time);
        }
        return this.time;
    }
}

