package pickewanalysis.ewpicker;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class PickEWStationGroup extends ArrayList<PickEWStation> {
    
    public PickEWStationGroup() {
        //Do nothing;
    }

    public PickEWStationGroup(String stationFile) throws Exception {
        //Load stations from a file
        BufferedReader Finput = new BufferedReader(new FileReader(stationFile));
        String line;
        while ((line = Finput.readLine()) != null) {
            //Remove spaces in begining and end
            line = line.trim();
            //Remove comments
            int cPos = line.indexOf("#");
            if (cPos != -1) {
                line = line.substring(0, cPos).trim();
            }
            if (line.equals("")) {
                continue;
            }
            //Line is ready for processing
            add(new PickEWStation(line));
        }
        //Close file
        Finput.close();
    }

    /*
    public void saveStationFile(String filename) throws Exception {
        BufferedWriter Foutput = new BufferedWriter(new FileWriter(filename));
        for (int i = 0; i < stations.size(); i++) {
            Foutput.write(stations.get(i).toLine());
            Foutput.newLine();
        }
        Foutput.close();
    }
     * 
     */
}
