
DROP TABLE IF EXISTS `ew_arc_phase`;
CREATE TABLE `ew_arc_phase` (
    `id`                    BIGINT   NOT NULL AUTO_INCREMENT  COMMENT 'Unique incremental id',
    `fk_module`               BIGINT   NOT NULL COMMENT 'Foreign key to ew_module',
    `fk_sqkseq`               BIGINT   NOT NULL COMMENT 'Foreign key to ew_sqkseq',
    `fk_scnl`                BIGINT   NOT NULL COMMENT 'Foreign key to ew_scnl',
    `Plabel`                CHAR              COMMENT 'P phase label',
    `Slabel`                CHAR              COMMENT 'S phase label',
    `Ponset`                CHAR              COMMENT 'P phase onset',
    `Sonset`                CHAR              COMMENT 'S phase onset',
    `Pat_dt`                DATETIME          COMMENT 'P-arrival-time - datetime part',
    `Pat_usec`              INT               COMMENT 'P-arrival-time - useconds',
    `Sat_dt`                DATETIME          COMMENT 'S-arrival-time - datetime part',
    `Sat_usec`              INT               COMMENT 'S-arrival-time - useconds',
    `Pres`                  DOUBLE            COMMENT 'P travel time residual',
    `Sres`                  DOUBLE            COMMENT 'S travel time residual',
    `Pqual`                 INT               COMMENT 'Assigned P weight code',
    `Squal`                 INT               COMMENT 'Assigned S weight code',
    `codalen`               INT               COMMENT 'Coda duration time',
    `codawt`                INT               COMMENT 'Coda weight',
    `Pfm`                   CHAR              COMMENT 'P first motion',
    `Sfm`                   CHAR              COMMENT 'S first motion',
    `datasrc`               CHAR              COMMENT 'Data source code.',
    `Md`                    DOUBLE            COMMENT 'Station duration magnitude',
    `azm`                   INT               COMMENT 'azimuth',
    `takeoff`               INT               COMMENT 'emergence angle at source',
    `dist`                  DOUBLE            COMMENT 'epicentral distance (km)',
    `Pwt`                   DOUBLE            COMMENT 'P weight actually used.',
    `Swt`                   DOUBLE            COMMENT 'S weight actually used.',
    `pamp`                  INT               COMMENT 'peak P-wave half amplitude',
    `codalenObs`            INT               COMMENT 'Coda duration time (Measured)',
    `ccntr_0`               INT               COMMENT 'Window center from P time',
    `ccntr_1`               INT               COMMENT 'Window center from P time',
    `ccntr_2`               INT               COMMENT 'Window center from P time',
    `ccntr_3`               INT               COMMENT 'Window center from P time',
    `ccntr_4`               INT               COMMENT 'Window center from P time',
    `ccntr_5`               INT               COMMENT 'Window center from P time',
    `caav_0`                INT               COMMENT 'Average Amplitude for ccntr[x]',
    `caav_1`                INT               COMMENT 'Average Amplitude for ccntr[x]',
    `caav_2`                INT               COMMENT 'Average Amplitude for ccntr[x]',
    `caav_3`                INT               COMMENT 'Average Amplitude for ccntr[x]',
    `caav_4`                INT               COMMENT 'Average Amplitude for ccntr[x]',
    `caav_5`                INT               COMMENT 'Average Amplitude for ccntr[x]',
    `version`               BIGINT   NOT NULL COMMENT 'version number of the origin',
    `modified`              TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last Review',            
    PRIMARY KEY  (`id`),
    FOREIGN KEY (`fk_module`) REFERENCES ew_module(`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (`fk_sqkseq`) REFERENCES ew_sqkseq(`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (`fk_scnl`) REFERENCES ew_scnl(`id`)   ON DELETE CASCADE ON UPDATE CASCADE,
    INDEX (`fk_module`, `fk_sqkseq`, `version`),
    INDEX (`modified`)
)                       
ENGINE = InnoDB COMMENT 'Automatic arc phase from EW arc messages';

