      SUBROUTINE HYATE
C--CALLED FROM HYCMD TO INITIALLY READ FILE OF STATION ATTENUATIONS AND
C  THEIR EXPIRATION DATES.
      INCLUDE 'common.inc'
      CHARACTER STN*5, SNET*2, SCOMP*3, SLOC*2
      DIMENSION IATN(7),IAEXP(7),ITEXP(7),IYEARI(7)
      KOUNT=0

      IF (JSTA.EQ.0) THEN
        WRITE (6,1001)
1001    FORMAT (' *** ERROR: YOU CANT READ ATTENUATIONS BEFORE',
     2  ' READING THE STATION FILE')
          IRES=-35
        RETURN
      END IF

C--OPEN THE STATION ATTENUATION FILE
      CALL OPENR (13,ATNFIL,'F',IOS)
      IF (IOS.NE.0) GOTO 90

C--LOOP TO READ STATION ATTENUATIONS
5     IF (L2000) THEN
        READ (13,1020,END=80) STN, SNET, SLOC, SCOMP,
     2  (IATN(I),IYEARI(I),ITEXP(I),I=1,7)
1020    FORMAT (A5,1X, A2,A2, A3,1X, 7(I2,1X,I4,I6,1X))

      ELSE
        READ (13,1000,END=80) STN, SNET, SCOMP,
     2  (IATN(I),IYEARI(I),ITEXP(I),I=1,7)
1000    FORMAT (A5,1X, A2,2X, A3,1X, 7(I2,1X,I2,I6,3X))
        SLOC='  '
      END IF

C--ATTENUATIONS:     0     6    12    18   24  30   36    42
C      DATA CALSV/23.2, 11.6, 5.58, 2.8, 1.4, .7, .352, .176,
C           48    54    60     66     72     78
C     2  .089, .044, .0224, .0112, .0056, .0028/

C--CHECK ALL ATTENUATIONS TO BE A VALID MULTIPLE OF 6
      DO I=1,7
        KTEMP=IATN(I)/6
        IF (IATN(I).LT.0 .OR. IATN(I).GT.78
     2    .OR. (IATN(I)-KTEMP*6) .NE.0) THEN
          WRITE (6,1108) STN,SNET,SCOMP, IATN(I),IYEARI(I),ITEXP(I)
1108      FORMAT (' *** ILLEGAL ATTENUATION VALUE FOR ',A5,A3,A4,
     2    ':',I4,' EXPIRES ',I4,I6)
          IRES=-93
          STOP
        END IF
        IF (IYEARI(I).EQ.0 .AND. ITEXP(I).EQ.0) GOTO 8
      END DO
8     CONTINUE

C--SEARCH STATION LIST IN MEMORY FOR A MATCH
      DO J=1,JSTA
        IF (STN(1:NSTLET) .EQ. STANAM(J)(1:NSTLET) .AND.
     2  SNET(1:NETLET) .EQ. JNET(J)(1:NETLET) .AND.
     3  (SLOC(1:NSLOC2) .EQ. JSLOC(J)(1:NSLOC2) .OR.
     3  SLOC(1:NSLOC2) .EQ. JSLOC2(J)(1:NSLOC2)) .AND.
     4  SCOMP(1:NCOMP) .EQ. JCOMP3(J)(1:NCOMP)) THEN

C--MAKE SURE IYEARI IS THE FULL 4-DIGIT YEAR
C--TRUNCATE YEAR TO 2146, THE LARGEST STORABLE IN I*4, STORE WHOLE DATE
          DO I=1,7
            IF (IYEARI(I).LT.100 .AND. IYEARI(I).GT.0) 
     2      IYEARI(I)=IYEARI(I)+ICENT
            IF (IYEARI(I).GT.2146) THEN
              WRITE (6,1200) STN, SNET, SCOMP, IYEARI(I)
1200          FORMAT ('*** ATTEN EXPIRATION YEAR TOO LARGE,',
     2        ' RESET TO 2146:'/1X,A5,1X,A2,1X,A3,1X,I4)
              IYEARI(I)=2146
            END IF
            IAEXP(I)=IYEARI(I)*1000000 +ITEXP(I)
          END DO

C--IF THE TARGET DATE IS 0, JUST TAKE THE FIRST ATTEN & EXPIRATION DATE
          IF (ICDATE.EQ.0) THEN
            I=1
          ELSE

C--SEARCH FOR THE FIRST EXPIRATION DATE AFTER THE TARGET DATE
            DO I=1,7
              IF (IAEXP(I).EQ.0 .OR. IAEXP(I).GT.ICDATE) GOTO 10
            END DO
            IAEXP(7)=0
          END IF

C--ISSUE A WARNING IF INSTRUMENT TYPE IS NOT 1
10        IF (JTYPE(J).NE.1) WRITE (6,1030) STN,SNET,SCOMP
1030      FORMAT (' *** WARNING: SHOULD BE READING ',
     1    'ATTENUATIONS ONLY FOR'/
     2    ' TYPE 1 STATIONS, NOT ',A,'-',A,'-',A)

C--STORE THE CAL FACTOR & ITS EXPIRATION DATE
          JCEXP(J)=IAEXP(I)
          KTEMP=IATN(I)/6
          JCAL(J)=CALSV(KTEMP)*1000.
          KOUNT=KOUNT+1
C          GOTO 5  !COMMENT OUT TO STORE DATA FOR ALL CHANNELS THAT APPLY
        END IF
      END DO
      GOTO 5

C--END OF ATTENUATION FILE
80    CLOSE (13)
      WRITE (6,1002) KOUNT
1002  FORMAT (I6,' STATION ATTENUATIONS SET')
      RETURN

C--ERROR FOR NON-EXISTENT FILE
90    WRITE (6,1010)
1010  FORMAT (' *** ERROR: STATION ATTENUATION FILE DOES NOT EXIST')
      IRES=-36
      RETURN
      END
