      SUBROUTINE HYOPEN
C--CALLED BY HYPOINV TO OPEN FILES
      INCLUDE 'common.inc'
C--ISTAT2 IS USED BY HYOPEN TO TELL HYP WHETHER FILES COULD BE OPENED.
C--IRES IS USED BY HYOPEN TO TELL HYP WHICH FILE COULD NOT BE OPENED.

      CHARACTER CHEAD*8,CHEADC*8
      DIMENSION CHEAD(5),CHEADC(5)
      DATA CHEAD/'DUR-MAG1','DUR-MAG2','AMP-MAG1','AMP-MAG2','EXT-MAG '/
      DATA CHEADC/'DUR,MAG1','DUR,MAG2','AMP,MAG1','AMP,MAG2',
     2 'EXT,MAG '/

C--ASSUME THERE IS A FILE OPEN ERROR
        ISTAT2=0

C--OPEN INPUT FILES

C--OPEN PHASE FILE
      IF (JCP.LT.6) CALL OPENR (14,PHSFIL,'F',IOS)
      IF (IOS.NE.0) THEN
C--HERE IS THE ERROR MESSAGE FOR NON-EXISTENT PHASE FILES
        WRITE (6,1010) 'PHASE', IOS
1010    FORMAT (' *** ERROR - ', A, ' FILE DOES NOT EXIST ***'/
     1          ' *** IOSTAT = ', I5, ' ***')
        IRES=-61
        RETURN
      END IF

C--OPEN CUSP-ID FILE
C      IF (JCP.EQ.7) CALL OPENR (14,PHSFIL,'F',IOS)
C      IF (IOS.NE.0) THEN
CC--HERE IS THE ERROR MESSAGE FOR NON-EXISTENT CUSP-ID FILE
C        WRITE (6,1010) 'CUSP-ID', IOS
C        IRES=-62
C        RETURN
C      END IF

C--OPEN OUTPUT FILES

C--OPEN SUMMARY FILE
      IF (LSUM) THEN
        IF (LAPP(2)) THEN
          CALL OPENW (12,SUMFIL,'F',IOS,'A')
        ELSE
          CALL OPENW (12,SUMFIL,'F',IOS,'S')
          IF (IOS.EQ.0) THEN

C--WRITE HEADER LINE IN READABLE SUMMARY FILES
            IF (IH71S.EQ.3)
     1        WRITE (12,1003) (CHEAD(MRDMAG(I)),I=1,NRDMAG)
1003        FORMAT ('   DATE     TIME  SEC     LAT      LON    ',
     2      ' DEPTH PREF-MAG NM NUM GAP  DMIN  RMS    ERH   ERZ QASR ',
     3      4X,'ID-NUM LOC',5(' ',A8))

            IF (IH71S.EQ.4)
     1        WRITE (12,1004) (CHEADC(MRDMAG(I)),I=1,NRDMAG)
1004        FORMAT ('   DATE     TIME, SEC ,   LAT  ,   LON   ,',
     2      ' DEPTH,PREF,MAG,NM,NUM,GAP, DMIN, RMS ,  ERH,  ERZ,QASR,',
     3      4X,'ID-NUM,LOC',5(',',A8))

          END IF
        END IF
        IF (IOS.NE.0) THEN
C--HERE IS THE ERROR MESSAGE FOR SUMMARY FILE OPEN FAILURE
          WRITE (6,1011) 'SUM', IOS
1011      FORMAT (' *** ERROR - CANNOT OPEN ', A, ' OUTPUT FILE ***'/
     1            ' *** IOSTAT = ', I5, ' ***')
          IRES=-81
          RETURN
        END IF
      END IF

C--OPEN ARC FILE
      IF (LARC) THEN
        IF (LAPP(3)) THEN
          CALL OPENW (7,ARCFIL,'F',IOS,'A')
        ELSE
          CALL OPENW (7,ARCFIL,'F',IOS,'S')
        END IF
        IF (IOS.NE.0) THEN
C--HERE IS THE ERROR MESSAGE FOR ARC FILE OPEN FAILURE
          WRITE (6,1011) 'ARC', IOS
          IRES=-82
          RETURN
        END IF
      END IF

C--OPEN PRT FILE
      IF (LPRT) THEN
        IF (LAPP(1)) THEN
          CALL OPENW (15,PRTFIL,'F',IOS,'A')
        ELSE
          CALL OPENW (15,PRTFIL,'F',IOS,'S')
        END IF
        IF (IOS.NE.0) THEN
C--HERE IS THE ERROR MESSAGE FOR PRT FILE OPEN FAILURE
          WRITE (6,1011) 'PRT', IOS
          IRES=-83
          RETURN
        END IF
      END IF

C--OPEN MAG FILE
      IF (LMAG) THEN
        CALL OPENW (16,MAGFIL,'F',IOS,'S')
        IF (IOS.NE.0) THEN
C--HERE IS THE ERROR MESSAGE FOR MAG FILE OPEN FAILURE
          WRITE (6,1011) 'MAG', IOS
          IRES=-84
          RETURN
        END IF
      END IF

C--THERE WERE NO FILE OPEN ERRORS
      ISTAT2=1

      RETURN

      END
