package pickstatistics;

import java.io.File;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JFileChooser;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;

@Root
public class PickStatistics extends javax.swing.JFrame {

    // Variables
    @Element(required = false)
    int BufferSize = 1024;
    @Element(required = false)
    long binDuration = 1L;
    @Element(required = false)
    int pickMsgCode = 8;
    @Element(required = false)
    int output = 2;
    // Unreferenced variables
    StationGroup stations;
    File[] currentFile;
    public static final SimpleDateFormat pf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
    public static PickStatistics ps;

    public PickStatistics() {
        initComponents();
        //AvgTable.setAutoCreateRowSorter(true);
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        AvgTable = new javax.swing.JTable();
        StatusLabel = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        exitMenuItem = new javax.swing.JMenuItem();
        helpMenu = new javax.swing.JMenu();
        aboutMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        AvgTable.setModel(new StatTableModel(null));
        AvgTable.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        AvgTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                AvgTableMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(AvgTable);
        AvgTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)
            {
                ps.stationSelected(e);
            }
        });

        StatusLabel.setText(" ");

        fileMenu.setMnemonic('f');
        fileMenu.setText("File");

        openMenuItem.setMnemonic('o');
        openMenuItem.setText("Open");
        openMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(openMenuItem);

        exitMenuItem.setMnemonic('x');
        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setMnemonic('h');
        helpMenu.setText("Help");

        aboutMenuItem.setMnemonic('a');
        aboutMenuItem.setText("About");
        aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutMenuItemActionPerformed(evt);
            }
        });
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        setJMenuBar(menuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(StatusLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 266, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(StatusLabel))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void AvgTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_AvgTableMouseClicked
        if (evt.getClickCount() != 2) {
            return;
        }
        int selectedRow = AvgTable.getSelectedRow();
        if (selectedRow == -1) {
            //There is no selected row
            return;
        }
        int rowIndex = AvgTable.convertRowIndexToModel(selectedRow);
        if (output < 1) {
            return;
        }
        Station station = stations.get(rowIndex);
        if (output >= 1) {
            System.out.println(station.getSCNLString());
            station.printStatistics();
        }
        if (output >= 2) {
            new TimeSeriesPlot(this, false, station).setVisible(true);
        }
    }//GEN-LAST:event_AvgTableMouseClicked

    private void openMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openMenuItemActionPerformed
        new Thread() {

            public void run() {
                JFileChooser filechooser = new JFileChooser();
                if (currentFile != null && currentFile.length > 0) {
                    filechooser.setCurrentDirectory(currentFile[0].getParentFile());
                } else {
                    filechooser.setCurrentDirectory(new File("./"));
                }
                filechooser.setDialogType(JFileChooser.OPEN_DIALOG);
                filechooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
                filechooser.setMultiSelectionEnabled(true);
                int aux = filechooser.showOpenDialog(null);
                if (aux == JFileChooser.APPROVE_OPTION) {
                    currentFile = filechooser.getSelectedFiles();
                    update();
                }
            }
        }.start();
    }//GEN-LAST:event_openMenuItemActionPerformed

    private void aboutMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutMenuItemActionPerformed
        new AboutDialog(this, true).setVisible(true);
    }//GEN-LAST:event_aboutMenuItemActionPerformed

    public static void main(final String args[]) {
        // Set UTC Time
        System.setProperty("user.timezone", "Etc/Universal");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));


        // Load configuration, if existing
        File configfile = new File("pickstatistics.xml");
        if (!configfile.exists()) {
            // Assume default configuration
            ps = new PickStatistics();
        } else {
            // Try to load configuration file
            try {
                Serializer serializer = new Persister();
                ps = serializer.read(PickStatistics.class, configfile);
            } catch (Exception e) {
                // Something went wrong when reading the file
                ps = new PickStatistics();
            }
        }

        //Start stations object
        ps.stations = new StationGroup(ps.binDuration * 3600000L);

        // Check if two arguments
        if (args != null && args.length == 2) {
            // This means simply display the statistics for one station
            ps.currentFile = new File[]{new File(args[0])};
            if (ps.update() < 0) {
                System.err.println("Unable to process input argument: " + args[0]);
                System.exit(1);
            }
            // Find station in results
            for (Station station : ps.stations) {
                if (station.getSCNLString().equalsIgnoreCase(args[1])) {
                    station.printStatistics();
                    System.exit(0);
                }
            }
            System.err.println("Unable to find " + args[1] + " within available stations.");
            System.exit(1);
        }


        //Center on screen
        ps.setLocationRelativeTo(null);
        // Start plotting window
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    ps.setVisible(true);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (args.length > 0 && !args[0].isEmpty()) {
            ps.currentFile = new File[]{new File(args[0])};
            if (ps.update() < 0) {
                System.err.println("Unable to process input argument: " + args[0]);
                System.exit(1);
            }
        }
    }

    private int update() {
        if (currentFile == null || currentFile.length == 0) {
            return -1;
        }
        // Check existance of the files
        boolean exist = true;
        for (int i = 0; i < currentFile.length; i++) {
            if (currentFile[i].exists()) {
                exist = true;
            }
        }
        if (!exist) {
            return -1;
        }

        // Clear current analysis results
        clearAnalysis();

        // Collect an array of files to analyse
        List<File> files = new ArrayList<File>();
        for (int i = 0; i < currentFile.length; i++) {
            if (currentFile[i].isDirectory()) {
                files = GetAllChildren(currentFile[i]);
            } else if (currentFile[i].isFile()) {
                files.add(currentFile[i]);
            } else {
                return -2;
            }
        }

        // Analyse each file
        for (int i = 0; i < files.size(); i++) {
            status("Processing file " + (i + 1) + " of " + files.size() + ": " + files.get(i).getName());
            addToAnalysis(files.get(i));
            if (stations.size() > 0) {
                try {
                    java.awt.EventQueue.invokeAndWait(new Runnable() {

                        public void run() {
                            AvgTable.setModel(new StatTableModel(stations));
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        status("Ready");
        if (stations.size() > 0) {
            AvgTable.setAutoCreateRowSorter(true);
        }
        return 0;
    }

    private void clearAnalysis() {
        stations.clear();
    }

    private int addToAnalysis(final File file) {
        // Basic checks
        if (!file.exists()
                || !file.canRead()) {
            return -1;
        }
        // Create buffer
        byte[] buffer = new byte[BufferSize * 1024];

        try {
            // Open file
            RandomAccessFile Finput = new RandomAccessFile(file, "r");

            // Read blocks of data
            int readBytes = 0;
            int writePos = 0;
            int nPicks = 0;
            while ((readBytes = Finput.read(buffer, writePos, buffer.length - writePos)) != -1) {
                readBytes += writePos; //Set the real bytes to read

                // Create giant string for processing
                String s = new String(buffer, 0, readBytes);
                //System.out.println("s:"+s);
                // Find next pick start code
                int startpos = 0; // Initial starting position
                int endpos = 0; // Initial ending position
                while ((startpos = s.indexOf(pickMsgCode + " ", endpos)) != -1) {
                    endpos = s.indexOf("\n", startpos);
                    if (endpos == -1) {
                        endpos = startpos;
                        break;
                    }
                    String pickStr = new String(buffer, startpos, endpos - startpos);
                    //Try to process pick
                    try {
                        String[] parts = pickStr.split("[\\s]+");
                        if (parts.length == 10) {
                            long time = pf.parse(parts[6]).getTime();
                            String[] scnl = parts[4].split("[.]+");
                            stations.addPick(scnl, time);
                        }
                    } catch (Exception e) {
                        // Error processing pick... do nothing
                    }
                }

                // set extra bytes to begining of buffer
                System.arraycopy(buffer, endpos, buffer, 0, readBytes - endpos);
                writePos = readBytes - endpos;
            }
            Finput.close();
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private List<File> GetAllChildren(File folder) {
        List<File> templist = new ArrayList<File>();
        if (folder.isDirectory()) {
            File[] children = folder.listFiles();
            for (int i = 0; i < children.length; i++) {
                if (children[i].isFile()) {
                    templist.add(children[i]);
                } else if (children[i].isDirectory()) {
                    templist.addAll(GetAllChildren(children[i]));
                }
            }
        }
        return templist;
    }

    private void status(final String status) {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    ps.StatusLabel.setText(status);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stationSelected(ListSelectionEvent e) {
        // Find which station is selected
        //Set the current station
        int selectedRow = AvgTable.getSelectedRow();
        if (selectedRow == -1) {
            //There is no selected row
            return;
        }
        int rowIndex = AvgTable.convertRowIndexToModel(selectedRow);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable AvgTable;
    private javax.swing.JLabel StatusLabel;
    private javax.swing.JMenuItem aboutMenuItem;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem openMenuItem;
    // End of variables declaration//GEN-END:variables
}
