/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/

package ewquakealert;

//import java.net.PasswordAuthentication;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message.RecipientType;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/**
 *
 * @author RL197718
 */
public class sendEmailAttach extends Thread{
    String msgBody;
    String filename;
    String subject;

    sendEmailAttach(String subject, String msgBody, String filename) {
        this.msgBody = msgBody;
        this.filename = filename;
        this.subject = subject;
    }

    public void run(){
        String to = Configuration.destEmail[0];
        String from = Configuration.email;


        // create some properties and get the default Session
        //Properties props = System.getProperties();
        //props.put("mail.smtp.host", Configuration.host);

        //Session session = Session.getInstance(props, null);
        Session session = getSession();

        try {
            // create a message
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom(new InternetAddress(from));
            
            for(int i=0; i<Configuration.destEmail.length; i++) {
                if (Configuration.destEmail[i].length()>0)
                    msg.addRecipient(RecipientType.TO, new InternetAddress(Configuration.destEmail[i]));
            }

            msg.setSubject(subject);

            // create and fill the first message part
            MimeBodyPart mbp1 = new MimeBodyPart();
            //mbp1.setText(msgBody);
            mbp1.setContent(msgBody, "text/html");

            // create the Multipart and add its parts to it
            Multipart mp = new MimeMultipart();
            mp.addBodyPart(mbp1);

            if ((Configuration.useWaveServer)&&(!filename.equals(""))) {
                try {
                    // create the second message part
                    MimeBodyPart mbp2 = new MimeBodyPart();

                    // attach the file to the message
                    FileDataSource fds = new FileDataSource(filename);
                    mbp2.setDataHandler(new DataHandler(fds));
                    mbp2.setFileName(fds.getName());

                    //add part to message
                    mp.addBodyPart(mbp2);
                }
                catch (Exception e) {
                }
            }
            // add the Multipart to the message
            msg.setContent(mp);

            // set the Date: header
            msg.setSentDate(new Date());

            // send the message
            Transport.send(msg);
            
            for (int i=0; i<Configuration.destEmail.length; i++)
                if (Configuration.destEmail[i].length()>0)
                    EWQuakeAlertView.println("Email sent to " + Configuration.destEmail[i] + ".");
             

        }
        catch (MessagingException mex) {
            EWQuakeAlertView.println("Unable to send email.");
            
        }
    }




    private Session getSession() {
        Authenticator authenticator = new Authenticator();

        Properties properties = new Properties();
        properties.setProperty("mail.smtp.submitter", authenticator.getPasswordAuthentication().getUserName());
        properties.setProperty("mail.smtp.auth", "true");

        properties.setProperty("mail.smtp.host", Configuration.host);
        properties.setProperty("mail.smtp.port", "25");

        return Session.getInstance(properties, authenticator);
    }



    private class Authenticator extends javax.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator() {
            authentication = new PasswordAuthentication(Configuration.username, Configuration.password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return authentication;
        }
    }
}
