/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm.message;

import gov.usgs.earthworm.message.MessageType;
import gov.usgs.util.Util;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MessageLogo {
    private MessageType type;
    private byte module;
    private byte installationID;
    private NumberFormat numberFormat;

    public MessageLogo() {
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType t) {
        this.type = t;
    }

    public void setModule(byte b) {
        this.module = b;
    }

    public byte getModule() {
        return this.module;
    }

    public void setInstallationId(byte b) {
        this.installationID = b;
    }

    public byte getInstallationId() {
        return this.installationID;
    }

    public MessageLogo(byte[] b) {
        this(b, 0);
    }

    public MessageLogo(byte[] b, int offset) {
        String s = new String(b, offset, 9);
        this.installationID = Util.intToByte(Integer.parseInt(s.substring(0, 3).trim()));
        this.module = Util.intToByte(Integer.parseInt(s.substring(3, 6).trim()));
        this.type = MessageType.fromInt(Integer.parseInt(s.substring(6, 9).trim()));
    }

    public byte[] toDataStreamBytes() {
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat("000");
        }
        String message = this.numberFormat.format(Util.byteToInt(this.installationID)) + this.numberFormat.format(Util.byteToInt(this.module)) + this.numberFormat.format(this.type.getType());
        byte[] b = new byte[9];
        for (int i = 0; i < b.length; ++i) {
            b[i] = Util.intToByte(message.charAt(i));
        }
        return b;
    }

    public String toString() {
        return "Message: type=" + (Object)((Object)this.type) + " module=" + this.module + " inst=" + this.installationID;
    }
}

