/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

import gov.usgs.math.Complex;

public class DFT {
    private static final double TWOPI = Math.PI * 2;
    private double[] data;
    private int numData;

    public DFT(double[] d) {
        this.data = d;
        this.numData = this.data.length;
    }

    public Complex getDFTPoint(int m) {
        Complex cx = new Complex();
        if (m >= 0 && m < this.numData) {
            double r = 0.0;
            double i = 0.0;
            if (m == 0) {
                for (int n = 0; n < this.numData; ++n) {
                    r += this.data[n];
                }
            } else {
                for (int n = 0; n < this.numData; ++n) {
                    double x = this.data[n];
                    double scale = Math.PI * 2 * (double)n * (double)m / (double)this.numData;
                    r += x * Math.cos(scale);
                    i -= x * Math.sin(scale);
                }
            }
            cx.re = r;
            cx.im = i;
        }
        return cx;
    }

    public Complex[] getFullDFT() {
        Complex[] dft = new Complex[this.numData / 2];
        for (int i = 0; i < this.numData / 2; ++i) {
            dft[i] = this.getDFTPoint(i);
        }
        return dft;
    }
}

