/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.ConnectionStatistics;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Connections {
    private Map<SocketChannel, ConnectionStatistics> connectionStats = Collections.synchronizedMap(new HashMap());
    private long connectionIndex = 0L;
    private int maxConnections = 20;

    private Connections() {
    }

    public static Connections getInstance() {
        return ConnectionsHolder.instance;
    }

    public int getNumConnections() {
        return this.connectionStats.size();
    }

    public Collection<ConnectionStatistics> getConnectionStats() {
        return this.connectionStats.values();
    }

    public Map<SocketChannel, ConnectionStatistics> getConnections() {
        return this.connectionStats;
    }

    public ConnectionStatistics getConnectionStatistics(SocketChannel channel) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs == null) {
            cs = new ConnectionStatistics(channel);
            cs.address = Connections.getHost(channel);
            cs.index = this.connectionIndex++;
            cs.connectTime = System.currentTimeMillis();
            this.connectionStats.put(channel, cs);
        }
        return cs;
    }

    public static String getHost(SocketChannel channel) {
        String addr;
        try {
            addr = channel.socket().getInetAddress().getHostAddress();
        }
        catch (NullPointerException e) {
            addr = "(closed)";
        }
        return addr;
    }

    public void remove(SocketChannel channel) {
        this.connectionStats.remove(channel);
    }

    public void sent(SocketChannel channel, int bytesSent) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs != null) {
            cs.sent(bytesSent);
        }
    }

    public void read(SocketChannel channel, int bytesRead) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs != null) {
            cs.read(bytesRead);
        }
    }

    public void beginCommand(SocketChannel channel, String commandString) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs != null) {
            cs.beginCommand(commandString);
        }
    }

    public String printConnections(String s) {
        char col = 'T';
        if (s.length() > 1) {
            col = s.charAt(1);
        }
        boolean desc = s.endsWith("-");
        ArrayList<ConnectionStatistics> css = new ArrayList<ConnectionStatistics>(this.connectionStats.size());
        css.addAll(this.connectionStats.values());
        Collections.sort(css, ConnectionStatistics.getComparator(ConnectionStatistics.SortOrder.parse(col), desc));
        StringBuffer sb = new StringBuffer();
        sb.append("------- Connections --------\n");
        sb.append(ConnectionStatistics.getHeaderString());
        for (ConnectionStatistics cs : css) {
            sb.append(cs.getConnectionString() + "\n");
        }
        sb.append(ConnectionStatistics.getHeaderString());
        sb.append("\n\nOpen client connections:    " + this.connectionStats.size() + "/" + this.maxConnections + "\n");
        return sb.toString();
    }

    public String printCommands(String s) {
        char col = 'T';
        if (s.length() > 1) {
            col = s.charAt(1);
        }
        boolean desc = s.endsWith("-");
        ArrayList<ConnectionStatistics> css = new ArrayList<ConnectionStatistics>(this.connectionStats.size());
        css.addAll(this.connectionStats.values());
        Collections.sort(css, ConnectionStatistics.getComparator(ConnectionStatistics.SortOrder.parse(col), desc));
        StringBuffer sb = new StringBuffer();
        sb.append("\n------- Running Commands --------\n");
        sb.append(ConnectionStatistics.getCommandHeaderString());
        int runningCount = 0;
        for (ConnectionStatistics cs : css) {
            String command = cs.getCommandString();
            if (command == null) continue;
            sb.append(command);
            ++runningCount;
        }
        if (runningCount == 0) {
            sb.append("\n  < All handlers are idle >  \n");
        }
        return sb.toString();
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int connectionCount() {
        return this.connectionStats.size();
    }

    public void toggleTrace(int index) {
        for (SocketChannel sc : this.connectionStats.keySet()) {
            ConnectionStatistics cs = this.connectionStats.get(sc);
            if (cs.index != (long)index) continue;
            cs.isTraced = !cs.isTraced;
        }
    }

    public boolean isTraced(SocketChannel channel) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        return cs.isTraced;
    }

    public void endCommand(SocketChannel channel) {
        ConnectionStatistics cs = this.connectionStats.get(channel);
        if (cs != null) {
            cs.endCommand();
        }
    }

    private static class ConnectionsHolder {
        public static Connections instance = new Connections();

        private ConnectionsHolder() {
        }
    }
}

