/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.math.Butterworth;
import gov.usgs.math.Filter;
import gov.usgs.plot.data.BinaryDataSet;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;

public class GenericDataMatrix
implements BinaryDataSet {
    protected static final Logger logger = Log.getLogger("gov.usgs.vdx.data.GenericDataMatrix");
    protected DoubleMatrix2D data = null;
    protected HashMap<String, Integer> columnMap = new HashMap();

    public GenericDataMatrix() {
        this.setColumnNames();
    }

    public GenericDataMatrix(DoubleMatrix2D d) {
        this();
        this.data = d;
    }

    public GenericDataMatrix(ByteBuffer bb) {
        this();
        this.fromBinary(bb);
    }

    public GenericDataMatrix(List<double[]> list) {
        this();
        if (list == null || list.size() == 0) {
            return;
        }
        int rows = list.size();
        int cols = list.get(0).length;
        this.data = DoubleFactory2D.dense.make(rows, cols);
        for (int i = 0; i < rows; ++i) {
            double[] d = list.get(i);
            for (int j = 0; j < cols; ++j) {
                this.data.setQuick(i, j, d[j]);
            }
        }
    }

    @Override
    public ByteBuffer toBinary() {
        int rows = this.rows();
        int cols = this.columns();
        ByteBuffer bb = ByteBuffer.allocate(4 + rows * cols * 8);
        bb.putInt(rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                bb.putDouble(this.data.getQuick(i, j));
            }
        }
        return bb;
    }

    @Override
    public void fromBinary(ByteBuffer bb) {
        int rows = bb.getInt();
        int cols = (bb.limit() - 4) / rows / 8;
        this.data = DoubleFactory2D.dense.make(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data.setQuick(i, j, bb.getDouble());
            }
        }
    }

    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.rows(); ++i) {
            sb.append(Util.j2KToDateString(this.data.getQuick(i, 0)) + ",");
            for (int j = 1; j < this.columns(); ++j) {
                sb.append(this.data.getQuick(i, j));
                sb.append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setData(DoubleMatrix2D d) {
        this.data = d;
    }

    public void setColumnNames() {
    }

    public void setColumnNames(String[] s) {
        int i = 0;
        for (String name : s) {
            this.columnMap.put(name, i++);
        }
    }

    public String[] getColumnNames() {
        String[] c = new String[this.columnMap.size()];
        Iterator<String> i$ = this.columnMap.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            c[this.columnMap.get((Object)s).intValue()] = s = i$.next();
        }
        return c;
    }

    public int rows() {
        if (this.data != null) {
            return this.data.rows();
        }
        return 0;
    }

    public int columns() {
        if (this.data != null) {
            return this.data.columns();
        }
        return 0;
    }

    public void doArithmetic(String c, String o, double v) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            this.doArithmetic(i, o, v);
        }
    }

    public void doArithmetic(int c, String o, double v) {
        if (o.equalsIgnoreCase("multiply")) {
            this.mult(c, v);
        } else if (o.equalsIgnoreCase("divide")) {
            this.mult(c, 1.0 / v);
        }
    }

    public void add(String c, double v) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            this.add(i, v);
        }
    }

    public void add(int c, double v) {
        for (int i = 0; i < this.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            this.data.setQuick(i, c, this.data.getQuick(i, c) + v);
        }
    }

    public void mult(String c, double v) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            this.mult(i, v);
        }
    }

    public void mult(int c, double v) {
        for (int i = 0; i < this.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            this.data.setQuick(i, c, this.data.getQuick(i, c) * v);
        }
    }

    public void sum(int c) {
        for (int i = 1; i < this.rows(); ++i) {
            double d = this.data.getQuick(i - 1, c);
            this.data.setQuick(i, c, d += this.data.getQuick(i, c));
        }
    }

    public void accumulate(int c) {
        if (this.data.rows() > 0) {
            double total = 0.0;
            double r = 0.0;
            double last = this.data.getQuick(0, c);
            this.data.setQuick(0, c, 0.0);
            for (int i = 1; i < this.data.rows(); ++i) {
                r = this.data.getQuick(i, c);
                if (Double.isNaN(r)) continue;
                if (r < last) {
                    last = 0.0;
                }
                last = r;
                this.data.setQuick(i, c, total += r - last);
            }
        }
    }

    public void detrend(int c) {
        double xm = this.mean(0);
        double ym = this.mean(c);
        double ssxx = 0.0;
        double ssxy = 0.0;
        for (int i = 0; i < this.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            ssxy += (this.data.getQuick(i, 0) - xm) * (this.data.getQuick(i, c) - ym);
            ssxx += (this.data.getQuick(i, 0) - xm) * (this.data.getQuick(i, 0) - xm);
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        for (int i = 0; i < this.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            this.data.setQuick(i, c, this.data.getQuick(i, c) - (this.data.getQuick(i, 0) * m + b));
        }
    }

    public void despike(int c, double p) {
        this.set2mean(c, p);
    }

    public void filter(Butterworth bw, int columnIndex, boolean zeroPhaseShift) {
        int i;
        double mean = this.mean(columnIndex);
        double[] dBuf = new double[this.data.rows() + (int)((double)this.data.rows() * 0.5)];
        Arrays.fill(dBuf, mean);
        int trueStart = (int)((double)this.data.rows() * 0.25);
        for (i = 0; i < this.data.rows(); ++i) {
            if (this.data.getQuick(i, columnIndex) == Double.NaN) continue;
            dBuf[i + trueStart] = this.data.getQuick(i, columnIndex);
        }
        bw.create();
        Filter.filter(dBuf, bw.getSize(), bw.getXCoeffs(), bw.getYCoeffs(), bw.getGain(), 0.0, 0.0);
        if (zeroPhaseShift) {
            double[] dBuf2 = new double[dBuf.length];
            int i2 = 0;
            int j = dBuf.length - 1;
            while (i2 < dBuf.length) {
                dBuf2[j] = dBuf[i2];
                ++i2;
                --j;
            }
            Filter.filter(dBuf2, bw.getSize(), bw.getXCoeffs(), bw.getYCoeffs(), bw.getGain(), 0.0, 0.0);
            i2 = 0;
            j = dBuf2.length - 1 - trueStart;
            while (i2 < this.data.rows()) {
                this.data.setQuick(i2, columnIndex, dBuf2[j]);
                ++i2;
                --j;
            }
        } else {
            for (i = 0; i < this.data.rows(); ++i) {
                this.data.setQuick(i, columnIndex, dBuf[i + trueStart]);
            }
        }
    }

    public void set2mean(int c, double p) {
        int j = 0;
        double jtime = this.data.getQuick(0, 0);
        Meaner window = new Meaner();
        window.add(this.data.getQuick(0, c));
        int r = this.rows();
        for (int i = 1; i < r; ++i) {
            double itime = this.data.getQuick(i, 0);
            double ival = this.data.getQuick(i, c);
            window.add(ival);
            while (itime - jtime > p) {
                window.removeOldest();
                jtime = this.data.getQuick(++j, 0);
            }
            this.data.setQuick(i, c, window.avg());
        }
    }

    public void set2median(int c, double p) {
        int j = 0;
        double jtime = this.data.getQuick(0, 0);
        Medianer window = new Medianer();
        window.add(this.data.getQuick(0, c));
        int r = this.rows();
        for (int i = 1; i < r; ++i) {
            double itime = this.data.getQuick(i, 0);
            double ival = this.data.getQuick(i, c);
            window.add(ival);
            while (itime - jtime > p) {
                window.removeOldest();
                jtime = this.data.getQuick(++j, 0);
            }
            this.data.setQuick(i, c, window.avg());
        }
    }

    public double first(int c) {
        if (this.rows() == 0) {
            return Double.NaN;
        }
        return this.data.getQuick(0, c);
    }

    public double max(int c) {
        double m = -1.0E300;
        for (int i = 0; i < this.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            m = Math.max(m, this.data.getQuick(i, c));
        }
        if (m == -1.0E300) {
            m = 0.0;
        }
        return m;
    }

    public double min(int c) {
        double m = 1.0E300;
        for (int i = 0; i < this.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            m = Math.min(m, this.data.getQuick(i, c));
        }
        if (m == 1.0E300) {
            m = 0.0;
        }
        return m;
    }

    public double mean(int c) {
        double t = 0.0;
        double j = 0.0;
        int r = this.rows();
        for (int i = 0; i < r; ++i) {
            double val = this.data.getQuick(i, c);
            if (Double.isNaN(val)) continue;
            t += val;
            j += 1.0;
        }
        if (j == 0.0) {
            return 0.0;
        }
        return t / j;
    }

    public double[] leastSquares(int c) {
        double ym = this.mean(c);
        double xm = this.mean(0);
        double ssxy = 0.0;
        double ssxx = 0.0;
        for (int i = 0; i < this.data.rows(); ++i) {
            if (Double.isNaN(this.data.getQuick(i, c))) continue;
            ssxy += (this.data.getQuick(i, 0) - xm) * (this.data.getQuick(i, c) - ym);
            ssxx += (this.data.getQuick(i, 0) - xm) * (this.data.getQuick(i, 0) - xm);
        }
        double m = ssxy / ssxx;
        double b = ym - m * xm;
        return new double[]{m, b};
    }

    public double getStartTime() {
        if (this.data == null || this.data.size() == 0) {
            return Double.NaN;
        }
        if (this.data.rows() == 1 && Double.isNaN(this.data.get(0, 0))) {
            return 0.0;
        }
        return this.data.get(0, 0);
    }

    public double getEndTime() {
        if (this.data == null || this.data.size() == 0) {
            return Double.NaN;
        }
        if (this.data.rows() == 1 && Double.isNaN(this.data.get(0, 0))) {
            return 0.0;
        }
        return this.data.get(this.rows() - 1, 0);
    }

    public void adjustTime(double adj) {
        this.add(0, adj);
    }

    public DoubleMatrix2D getTimes() {
        return this.data.viewPart(0, 0, this.rows(), 1);
    }

    public DoubleMatrix2D getColumn(int c) {
        return this.data.viewPart(0, c, this.rows(), 1);
    }

    public DoubleMatrix2D getColumn(String c) {
        Integer i = this.columnMap.get(c);
        if (i != null) {
            return this.getColumn(i);
        }
        return null;
    }

    public DoubleMatrix2D getData() {
        return this.data;
    }

    public void concatenate(GenericDataMatrix dm) {
        DoubleMatrix2D[][] ms = new DoubleMatrix2D[2][1];
        ms[0][0] = this.data;
        ms[1][0] = dm.getData();
        this.data = DoubleFactory2D.dense.compose(ms);
    }

    public int getMemorySize() {
        return this.data.rows() * this.data.columns() * 8;
    }

    private class Medianer {
        private MultiMap loHalf = new MultiMap();
        private MultiMap hiHalf = new MultiMap();
        private int idx1 = 0;
        private int idx2 = -1;

        Medianer() {
        }

        public void add(double val) {
            ++this.idx2;
            if (this.loHalf.size() == this.hiHalf.size()) {
                this.loHalf.addLo(val, this.idx2, this.hiHalf);
            } else {
                this.hiHalf.addHi(val, this.idx2, this.loHalf);
            }
        }

        public void dump() {
            System.out.print("[");
            this.loHalf.dump();
            System.out.print("]:[");
            this.hiHalf.dump();
            System.out.println("]");
        }

        public void removeOldest() {
            int hiSize;
            if (!this.loHalf.removeIndex(this.idx1)) {
                this.hiHalf.removeIndex(this.idx1);
            }
            ++this.idx1;
            int loSize = this.loHalf.size();
            if (loSize < (hiSize = this.hiHalf.size())) {
                Double d = this.hiHalf.firstKey();
                Integer ix = this.hiHalf.removeFirstIndex(d);
                this.loHalf.put(d, ix);
            } else if (loSize > hiSize + 1) {
                Double d = this.loHalf.lastKey();
                Integer ix = this.loHalf.removeLastIndex(d);
                this.hiHalf.put(d, ix);
            }
        }

        public double avg() {
            if (this.loHalf.size() == this.hiHalf.size()) {
                return (this.loHalf.lastKey() + this.hiHalf.firstKey()) / 2.0;
            }
            return this.loHalf.lastKey();
        }

        private class MultiMap {
            private TreeMap<Double, LinkedList<Integer>> mm = new TreeMap();
            private TreeMap<Integer, Double> unmm = new TreeMap();

            MultiMap() {
            }

            protected void put(Double key, Integer val) {
                LinkedList<Integer> entry = this.mm.get(key);
                if (entry == null) {
                    entry = new LinkedList();
                }
                this.unmm.put(val, key);
                if (entry.size() == 0) {
                    entry.add(val);
                    this.mm.put(key, entry);
                    return;
                }
                if (val < entry.getFirst()) {
                    entry.addFirst(val);
                } else {
                    entry.addLast(val);
                }
            }

            protected Double lastKey() {
                return this.mm.lastKey();
            }

            protected Integer removeLastIndex(Double key) {
                LinkedList<Integer> entry = this.mm.get(key);
                Integer index = entry.removeLast();
                if (entry.size() == 0) {
                    this.mm.remove(key);
                }
                this.unmm.remove(index);
                return index;
            }

            protected Double firstKey() {
                return this.mm.firstKey();
            }

            protected Integer removeFirstIndex(Double key) {
                LinkedList<Integer> entry = this.mm.get(key);
                Integer index = entry.removeFirst();
                if (entry.size() == 0) {
                    this.mm.remove(key);
                }
                this.unmm.remove(index);
                return index;
            }

            public int size() {
                return this.unmm.size();
            }

            public void addLo(Double key, Integer val, MultiMap other) {
                if (other.size() > 0 && key >= other.firstKey()) {
                    other.put(key, val);
                    key = other.firstKey();
                    val = other.removeFirstIndex(key);
                }
                this.put(key, val);
            }

            public void addHi(Double key, Integer val, MultiMap other) {
                if (other.size() > 0 && key <= other.lastKey()) {
                    other.put(key, val);
                    key = other.lastKey();
                    val = other.removeLastIndex(key);
                }
                this.put(key, val);
            }

            public boolean indexIsMember(Integer val) {
                return this.unmm.containsKey(val);
            }

            public boolean removeIndex(Integer val) {
                Double key = this.unmm.remove(val);
                if (key == null) {
                    return false;
                }
                List entry = this.mm.get(key);
                if (entry.size() == 1) {
                    this.mm.remove(key);
                } else {
                    entry.remove(val);
                }
                return true;
            }

            public void dump() {
                for (Double d : this.mm.keySet()) {
                    List d_ids = this.mm.get(d);
                    if (d_ids == null || d_ids.size() == 0) continue;
                    System.out.print(d);
                    if (d_ids.size() > 1) {
                        System.out.print("x" + this.mm.get(d).size());
                    }
                    System.out.print(" ");
                }
            }
        }
    }

    private class Meaner {
        private LinkedList<Double> data = new LinkedList();
        private double sum = 0.0;

        Meaner() {
        }

        public void add(double val) {
            this.data.addLast(val);
            this.sum += val;
        }

        public double removeOldest() {
            Double datum = this.data.removeFirst();
            this.sum -= datum.doubleValue();
            return datum;
        }

        public double avg() {
            return this.sum / (double)this.data.size();
        }
    }
}

