/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.plot.render.HistogramRenderer;
import gov.usgs.vdx.data.Exportable;
import hep.aida.ref.Histogram1D;

public class HistogramExporter
extends HistogramRenderer
implements Exportable {
    protected Histogram1D myHistogram;
    protected int expIndex;
    protected int bins;
    protected double time;

    public HistogramExporter(Histogram1D h) {
        super(h);
        this.myHistogram = h;
        this.bins = h.xAxis().bins();
        this.resetExport();
    }

    @Override
    public void resetExport() {
        this.expIndex = 0;
        this.time = 0.0;
    }

    @Override
    public Double[] getNextExportRow() {
        if (this.expIndex >= this.bins) {
            return null;
        }
        Double[] row = new Double[2];
        row[0] = new Double(this.time) + this.getMinX();
        this.time += this.myHistogram.xAxis().binWidth(this.expIndex);
        row[1] = this.myHistogram.binHeight(this.expIndex);
        ++this.expIndex;
        return row;
    }

    @Override
    public int length() {
        return -1;
    }
}

