/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

public class MetaDatum {
    public int cmid;
    public int cid;
    public String chName;
    public int colid;
    public String colName;
    public int rid;
    public String rkName;
    public String name;
    public String value;

    public MetaDatum() {
    }

    public MetaDatum(int cid, int colid, int rid) {
        this.cmid = 0;
        this.cid = cid;
        this.chName = null;
        this.colid = colid;
        this.colName = null;
        this.rid = rid;
        this.rkName = null;
        this.name = null;
        this.value = null;
    }

    public MetaDatum(String chName, String colName, String rkName) {
        this.cmid = 0;
        this.cid = -1;
        this.chName = chName;
        this.colid = -1;
        this.colName = colName;
        this.rid = -1;
        this.rkName = rkName;
        this.name = null;
        this.value = null;
    }

    public MetaDatum(String str) {
        String[] qp = str.replace('\u0000', '\n').split("\"");
        this.name = qp[1];
        this.value = qp[3];
        this.chName = qp[5];
        this.colName = qp[7];
        this.rkName = qp[9];
        qp = qp[0].split(",");
        this.cmid = Integer.parseInt(qp[0]);
        this.cid = Integer.parseInt(qp[1]);
        this.colid = Integer.parseInt(qp[2]);
        this.rid = Integer.parseInt(qp[3]);
    }

    public String toXML() {
        String[] names;
        StringBuffer sb = new StringBuffer();
        sb.append("<metadatum>\n");
        sb.append("<![CDATA[" + this.cmid + "\"" + this.cid + "\"" + this.colid + "\"" + this.rid);
        for (String s : names = new String[]{this.name, this.value, this.chName, this.colName, this.rkName}) {
            sb.append("\"" + (s == null ? "" : s));
        }
        sb.append("]]>\n</metadatum>\n");
        return sb.toString();
    }
}

