/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Rank {
    private int rid;
    private String name;
    private int rank;
    private int user_default;

    public Rank() {
    }

    public Rank(int rid, String name, int rank, int user_default) {
        this.rid = rid;
        this.name = name;
        this.rank = rank;
        this.user_default = user_default;
    }

    public Rank(String rk) {
        String[] parts = rk.split(":");
        this.rid = Integer.parseInt(parts[0]);
        this.name = parts[1];
        this.rank = Integer.parseInt(parts[2]);
        this.user_default = Integer.parseInt(parts[3]);
    }

    public Rank bestPossible() {
        return new Rank(0, "Best Possible Rank", 0, 0);
    }

    public int getId() {
        return this.rid;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public int getUserDefault() {
        return this.user_default;
    }

    public static Map<Integer, Rank> fromStringsToMap(List<String> ss) {
        HashMap<Integer, Rank> map = new HashMap<Integer, Rank>();
        for (String s : ss) {
            Rank rk = new Rank(s);
            map.put(rk.getId(), rk);
        }
        return map;
    }

    public String toString() {
        return String.format("%d:%s:%d:%d", this.getId(), this.getName(), this.getRank(), this.getUserDefault());
    }
}

