/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo.plot;

import gov.usgs.plot.color.Jet;
import gov.usgs.plot.color.Spectrum;
import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.render.ArbDepthFrameRenderer;
import gov.usgs.plot.render.Renderer;
import gov.usgs.plot.transform.Transformer;
import gov.usgs.vdx.data.hypo.HypocenterList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

public class HypocenterRenderer
implements Renderer {
    private HypocenterList data;
    private Transformer transformer;
    private AxesOption axesOption;
    private static NumberFormat numberFormat;
    private ColorOption colorOption;
    private double minTime;
    private double maxTime;
    private static final Spectrum spectrum;
    private Renderer colorScaleRenderer;
    private Renderer magnitudeScaleRenderer;
    public static Ellipse2D.Float[] circles;
    public static final int[] circleScaleOffset;
    public static Color[] colors;
    public static double[] depths;
    public static String[] depthStrings;

    public HypocenterRenderer(HypocenterList d, Transformer fr, AxesOption v) {
        this.data = d;
        this.transformer = fr;
        this.axesOption = v;
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(0);
        }
        this.colorOption = ColorOption.chooseAuto(v);
    }

    public void setColorTime(double min, double max) {
        this.colorOption = ColorOption.TIME;
        this.minTime = min;
        this.maxTime = max;
    }

    public void setMonochrome() {
        this.colorOption = ColorOption.MONOCHROME;
    }

    public void setColorDepth() {
        this.colorOption = ColorOption.DEPTH;
    }

    public void setColorOption(ColorOption c) {
        this.colorOption = c;
    }

    public void createMagnitudeScaleRenderer(final double xStart, final double yStart) {
        this.magnitudeScaleRenderer = new Renderer(){

            @Override
            public void render(Graphics2D g) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.BLACK);
                g.setStroke(new BasicStroke(2.0f));
                g.setFont(new Font("Arial", 0, 10));
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                g.drawString("Magnitude", (float)xStart - 80.0f, (float)yStart);
                for (int i = 0; i < circles.length; ++i) {
                    g.translate(xStart - (double)HypocenterRenderer.circles[i].x + (double)circleScaleOffset[i], yStart + (double)HypocenterRenderer.circles[i].y - 15.0);
                    g.setPaint(Color.WHITE);
                    g.fill(circles[i]);
                    g.setPaint(Color.BLACK);
                    g.draw(circles[i]);
                    g.drawString("" + i, (float)(-(metrics.stringWidth("" + i) / 2)), -HypocenterRenderer.circles[i].y + 15.0f);
                    g.translate(-(xStart - (double)HypocenterRenderer.circles[i].x + (double)circleScaleOffset[i]), -(yStart + (double)HypocenterRenderer.circles[i].y - 15.0));
                }
            }
        };
    }

    public void createColorScaleRenderer(final double xStart, final double yStart) {
        this.colorScaleRenderer = new Renderer(){

            @Override
            public void render(Graphics2D g) {
                g.setStroke(new BasicStroke(1.0f));
                g.setFont(new Font("Arial", 0, 10));
                if (HypocenterRenderer.this.colorOption == ColorOption.DEPTH) {
                    Rectangle2D.Double rect = new Rectangle2D.Double();
                    double yoff = 0.0;
                    double ty = (depths.length - 2) * 18;
                    g.drawString("Depth (km)", (float)xStart + 60.0f, (float)yStart);
                    for (int i = 1; i < depths.length - 1; ++i) {
                        rect.setRect(xStart, yStart - ty + yoff, 10.0, 18.0);
                        g.drawString(depthStrings[i], (float)xStart + 18.0f, (float)(yStart - ty + 4.0 + yoff));
                        g.setPaint(colors[i]);
                        g.fill(rect);
                        g.setPaint(Color.BLACK);
                        g.draw(rect);
                        yoff += 18.0;
                    }
                    g.drawString(depthStrings[depths.length - 1], (float)xStart + 18.0f, (float)yStart);
                }
                if (HypocenterRenderer.this.colorOption == ColorOption.TIME) {
                    spectrum.renderScale(g, xStart, yStart - 90.0, 10.0, 90.0, true, true);
                    Object[] t = SmartTick.autoTimeTick(HypocenterRenderer.this.minTime, HypocenterRenderer.this.maxTime, 5);
                    double[] ticks = (double[])t[0];
                    String[] labels = (String[])t[1];
                    double dt = HypocenterRenderer.this.maxTime - HypocenterRenderer.this.minTime;
                    Line2D.Double line = new Line2D.Double();
                    g.drawString("Time", (float)xStart + 60.0f, (float)yStart);
                    for (int i = 0; i < ticks.length; ++i) {
                        double yl = (ticks[i] - HypocenterRenderer.this.minTime) / dt * 90.0;
                        line.setLine(xStart + 10.0, yStart - 90.0 + yl, xStart + 13.0, yStart - 90.0 + yl);
                        g.draw(line);
                        g.drawString(labels[i], (float)xStart + 16.0f, (float)(yl + yStart - 90.0 + 3.0));
                    }
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void render(Graphics2D g) {
        origColor = g.getColor();
        origAT = g.getTransform();
        origStroke = g.getStroke();
        origFont = g.getFont();
        aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f));
        xt = 0.0;
        yt = 0.0;
        color = null;
        dt = this.maxTime - this.minTime;
        hcs = this.data.getHypocenters();
        adfr = null;
        skippedCount = 0;
        block13: for (i = 0; i < hcs.size(); ++i) {
            hc = hcs.get(i);
            if (hc.prefmag == -99.99) continue;
            switch (3.$SwitchMap$gov$usgs$vdx$data$hypo$plot$HypocenterRenderer$AxesOption[this.axesOption.ordinal()]) {
                case 1: 
                case 7: {
                    xt = this.transformer.getXPixel(hc.lon);
                    yt = this.transformer.getYPixel(hc.lat);
                    ** GOTO lbl84
                }
                case 4: {
                    xt = this.transformer.getXPixel(hc.lon);
                    yt = this.transformer.getYPixel(hc.depth);
                    ** GOTO lbl84
                }
                case 5: {
                    xt = this.transformer.getXPixel(hc.lat);
                    yt = this.transformer.getYPixel(hc.depth);
                    ** GOTO lbl84
                }
                case 6: {
                    adfr = null;
                    if (this.transformer instanceof ArbDepthFrameRenderer) {
                        adfr = (ArbDepthFrameRenderer)this.transformer;
                        adc = adfr.getArbDepthCalc();
                        if (adc != null) {
                            projectedDist = adc.getScaledProjectedDistance(hc.lat, hc.lon);
                            if (projectedDist < 0.0) {
                                ++skippedCount;
                                continue block13;
                            }
                            if (projectedDist > adc.getMaxDist()) {
                                ++skippedCount;
                                continue block13;
                            }
                            projectedWidth = Math.abs(adc.getScalePojectedWidth(hc.lat, hc.lon));
                            tmpWidth = adc.getWidth();
                            if (tmpWidth > 0.0 && projectedWidth > tmpWidth) {
                                ++skippedCount;
                                continue block13;
                            }
                            xt = this.transformer.getXPixel(projectedDist);
                        } else {
                            xt = 0.0;
                        }
                    } else {
                        xt = this.transformer.getXPixel(hc.lat);
                    }
                    yt = this.transformer.getYPixel(hc.depth);
                    ** GOTO lbl84
                }
                case 2: {
                    xt = this.transformer.getXPixel(hc.j2ksec);
                    yt = this.transformer.getYPixel(hc.depth);
                    ** GOTO lbl84
                }
                case 3: {
                    adfr = null;
                    if (this.transformer instanceof ArbDepthFrameRenderer) {
                        adfr = (ArbDepthFrameRenderer)this.transformer;
                        adc = adfr.getArbDepthCalc();
                        if (adc != null) {
                            projectedDist = adc.getScaledProjectedDistance(hc.lat, hc.lon);
                            if (projectedDist < 0.0) {
                                ++skippedCount;
                                continue block13;
                            }
                            if (projectedDist > adc.getMaxDist()) {
                                ++skippedCount;
                                continue block13;
                            }
                            projectedWidth = Math.abs(adc.getScalePojectedWidth(hc.lat, hc.lon));
                            tmpWidth = adc.getWidth();
                            if (tmpWidth > 0.0 && projectedWidth > tmpWidth) {
                                ++skippedCount;
                                continue block13;
                            }
                            yt = this.transformer.getYPixel(projectedDist);
                        } else {
                            yt = 0.0;
                        }
                    } else {
                        yt = this.transformer.getXPixel(hc.lat);
                    }
                    xt = this.transformer.getXPixel(hc.j2ksec);
                }
lbl84:
                // 7 sources

                default: {
                    g.translate(xt, yt);
                    block8 : switch (3.$SwitchMap$gov$usgs$vdx$data$hypo$plot$HypocenterRenderer$ColorOption[this.colorOption.ordinal()]) {
                        case 1: {
                            for (j = 0; j < HypocenterRenderer.depths.length - 1; ++j) {
                                if (!(hc.depth >= HypocenterRenderer.depths[j]) || !(hc.depth < HypocenterRenderer.depths[j + 1])) continue;
                                color = HypocenterRenderer.colors[j];
                                break block8;
                            }
                            break;
                        }
                        case 2: {
                            ci = (int)((hc.j2ksec - this.minTime) / dt * ((double)HypocenterRenderer.spectrum.colors.length - 1.0));
                            color = HypocenterRenderer.spectrum.colors[ci];
                            break;
                        }
                        case 3: {
                            color = Color.BLUE;
                        }
                    }
                    g.setColor(color);
                    ci = (int)Math.floor(hc.prefmag);
                    if (ci < 0) {
                        ci = 0;
                    }
                    g.draw(HypocenterRenderer.circles[ci]);
                    g.translate(-xt, -yt);
                }
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setColor(origColor);
        g.setTransform(origAT);
        if (this.colorScaleRenderer != null) {
            this.colorScaleRenderer.render(g);
        }
        if (this.magnitudeScaleRenderer != null) {
            this.magnitudeScaleRenderer.render(g);
        }
        g.setStroke(origStroke);
        g.setFont(origFont);
    }

    static {
        spectrum = Jet.getInstance();
        circles = new Ellipse2D.Float[]{new Ellipse2D.Float(-1.5f, -1.5f, 3.0f, 3.0f), new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f), new Ellipse2D.Float(-5.5f, -5.5f, 11.0f, 11.0f), new Ellipse2D.Float(-9.0f, -9.0f, 18.0f, 18.0f), new Ellipse2D.Float(-13.5f, -13.5f, 27.0f, 27.0f), new Ellipse2D.Float(-19.0f, -19.0f, 38.0f, 38.0f), new Ellipse2D.Float(-25.5f, -25.5f, 51.0f, 51.0f), new Ellipse2D.Float(-34.0f, -34.0f, 68.0f, 68.0f)};
        circleScaleOffset = new int[]{0, 30, 60, 90, 120, 150, 180, 210};
        colors = new Color[]{Color.BLACK, Color.GREEN, Color.RED, new Color(1.0f, 0.91f, 0.0f), Color.BLUE, new Color(0.8f, 0.0f, 1.0f)};
        depths = new double[]{-10000.0, 0.0, 5.0, 13.0, 20.0, 40.0, 10000.0};
        depthStrings = new String[]{"", "0", "5", "13", "20", "40", "70+"};
    }

    public static enum ColorOption {
        DEPTH,
        TIME,
        MONOCHROME;


        public static ColorOption fromString(String c) {
            if (c == null) {
                return null;
            }
            switch (c.charAt(0)) {
                case 'D': {
                    return DEPTH;
                }
                case 'T': {
                    return TIME;
                }
                case 'M': {
                    return MONOCHROME;
                }
            }
            return null;
        }

        public static ColorOption chooseAuto(AxesOption ax) {
            if (ax == null) {
                return null;
            }
            switch (ax) {
                case MAP_VIEW: 
                case TIME_DEPTH: 
                case ARB_TIME: {
                    return DEPTH;
                }
                case LON_DEPTH: 
                case LAT_DEPTH: 
                case ARB_DEPTH: {
                    return TIME;
                }
            }
            return MONOCHROME;
        }
    }

    public static enum AxesOption {
        MAP_VIEW,
        LON_DEPTH,
        LAT_DEPTH,
        TIME_DEPTH,
        TRIPLE_VIEW,
        ARB_DEPTH,
        ARB_TIME;


        public static AxesOption fromString(String c) {
            if (c == null) {
                return null;
            }
            switch (c.charAt(0)) {
                case 'M': {
                    return MAP_VIEW;
                }
                case 'E': {
                    return LON_DEPTH;
                }
                case 'N': {
                    return LAT_DEPTH;
                }
                case 'D': {
                    return TIME_DEPTH;
                }
                case 'A': {
                    return ARB_DEPTH;
                }
                case 'T': {
                    return ARB_TIME;
                }
                case '3': {
                    return TRIPLE_VIEW;
                }
            }
            return null;
        }
    }
}

