/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SQLEWRSAMDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "ewrsam";
    public static final boolean channels = true;
    public static final boolean translations = false;
    public static final boolean channelTypes = false;
    public static final boolean ranks = false;
    public static final boolean columns = true;
    public static final boolean menuColumns = false;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "rsam", "rsam", "", false, true, false)};
    private String tableSuffix;

    public SQLEWRSAMDataSource() {
    }

    public SQLEWRSAMDataSource(String s) {
        if (s.equals("Events")) {
            this.tableSuffix = "_events";
        } else if (s.equals("Values")) {
            this.tableSuffix = "_values";
        }
    }

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return false;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        this.defaultCreateDatabase(true, false, false, false, true, false);
        for (int i = 0; i < DATA_COLUMNS.length; ++i) {
            this.defaultInsertColumn(DATA_COLUMNS[i]);
        }
        return true;
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int active) {
        this.defaultCreateChannel(channelCode, channelName, lon, lat, height, active, 0, true, false, false, true);
        this.defaultCreateChannel(channelCode + "_values", null, Double.NaN, Double.NaN, Double.NaN, 0, 0, false, false, false, true);
        this.defaultCreateChannel(channelCode + "_events", null, Double.NaN, Double.NaN, Double.NaN, 0, 0, false, false, false, true);
        return true;
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("data")) {
            int cid = Integer.parseInt(params.get("channel"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            String plotType = params.get("plotType");
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            RSAMData data = null;
            try {
                data = this.getEWRSAMData(cid, st, et, plotType, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return SQLEWRSAMDataSource.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else {
            if (action.equals("ewRsamMenu")) {
                return new TextResult(this.getTypes());
            }
            if (action.equals("supptypes")) {
                return this.getSuppTypes(true);
            }
            if (action.equals("suppdata")) {
                return this.getSuppData(params, false);
            }
            if (action.equals("metadata")) {
                return this.getMetaData(params, false);
            }
        }
        return null;
    }

    public List<String> getTypes() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SHOW TABLES LIKE '%_events'";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result.add("EVENTS");
            }
            this.sql = "SHOW TABLES LIKE '%_values'";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result.add("VALUES");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLEWRSAMDataSource.getTypes()", e);
        }
        return result;
    }

    public RSAMData getEWRSAMData(int cid, double st, double et, String plotType, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        ArrayList<Object> pts = new ArrayList<double[]>();
        RSAMData result = null;
        try {
            this.database.useDatabase(this.dbName);
            Channel ch = this.defaultGetChannel(cid, false);
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 ";
            if (plotType.equals("VALUES")) {
                this.sql = "SELECT j2ksec, rsam ";
                this.sql = this.sql + "FROM   ?_values ";
                this.sql = this.sql + "WHERE  j2ksec >= ? and j2ksec <= ? ";
                this.sql = this.sql + "ORDER BY j2ksec";
                this.sqlCount = this.sqlCount + this.sql.substring(this.sql.indexOf("FROM"));
                try {
                    this.sql = SQLEWRSAMDataSource.getDownsamplingSQL(this.sql, "j2ksec", ds, dsInt);
                }
                catch (UtilException e) {
                    throw new UtilException("Can't downsample dataset: " + e.getMessage());
                }
                if (maxrows != 0) {
                    this.sql = this.sql + " LIMIT " + (maxrows + 1);
                    if (ds.equals((Object)DownsamplingType.NONE)) {
                        this.ps = this.database.getPreparedStatement(this.sqlCount + " LIMIT " + (maxrows + 1) + ") as T");
                        this.ps.setString(1, ch.getCode());
                        this.ps.setDouble(2, st);
                        this.ps.setDouble(3, et);
                        this.rs = this.ps.executeQuery();
                        if (this.rs.next() && this.rs.getInt(1) > maxrows) {
                            throw new UtilException("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded. Please use downsampling.");
                        }
                    }
                }
                this.ps = this.database.getPreparedStatement(this.sql);
                if (ds.equals((Object)DownsamplingType.MEAN)) {
                    this.ps.setDouble(1, st);
                    this.ps.setInt(2, dsInt);
                    this.ps.setString(3, ch.getCode());
                    this.ps.setDouble(4, st);
                    this.ps.setDouble(5, et);
                } else {
                    this.ps.setString(1, ch.getCode());
                    this.ps.setDouble(2, st);
                    this.ps.setDouble(3, et);
                }
                this.rs = this.ps.executeQuery();
                if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && SQLEWRSAMDataSource.getResultSetSize(this.rs) > maxrows) {
                    throw new UtilException("Max rows (" + maxrows + " rows) for source '" + this.vdxName + "' exceeded. Please downsample further.");
                }
                pts = new ArrayList();
                while (this.rs.next()) {
                    double[] dataRow = new double[]{this.getDoubleNullCheck(this.rs, 1), this.getDoubleNullCheck(this.rs, 2)};
                    pts.add(dataRow);
                }
                this.rs.close();
            } else if (plotType.equals("EVENTS")) {
                this.sql = "SELECT j2ksec, rsam ";
                this.sql = this.sql + "FROM   ?_events ";
                this.sql = this.sql + "WHERE  j2ksec >= ? and j2ksec <= ? and rsam != 0";
                if (maxrows != 0) {
                    this.sql = this.sql + " LIMIT " + (maxrows + 1);
                    this.ps = this.database.getPreparedStatement(this.sqlCount + this.sql.substring(this.sql.indexOf("FROM")) + ") as T");
                    this.ps.setString(1, ch.getCode());
                    this.ps.setDouble(2, st);
                    this.ps.setDouble(3, et);
                    this.rs = this.ps.executeQuery();
                    if (this.rs.next() && this.rs.getInt(1) > maxrows) {
                        throw new UtilException("Max rows (" + maxrows + " rows) for data source '" + this.vdxName + "' exceeded.");
                    }
                }
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setString(1, ch.getCode());
                this.ps.setDouble(2, st);
                this.ps.setDouble(3, et);
                this.rs = this.ps.executeQuery();
                double count = 0.0;
                double[] dataRow = new double[]{st, count};
                pts.add(dataRow);
                while (this.rs.next()) {
                    double t = this.rs.getDouble(1);
                    double c = this.rs.getDouble(2);
                    int i = 0;
                    while ((double)i < c) {
                        dataRow = new double[]{t, count += 1.0};
                        pts.add(dataRow);
                        ++i;
                    }
                }
                this.rs.close();
                dataRow = new double[]{et, count};
                pts.add(dataRow);
            }
            if (pts.size() > 0) {
                result = new RSAMData(pts);
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLEWRSAMDataSource.getEWRSAMData()", e);
        }
        return result;
    }

    public void insertData(String channelCode, GenericDataMatrix gdm, boolean translations, boolean ranks, int rid) {
        try {
            this.database.useDatabase(this.dbName);
            DoubleMatrix2D data = gdm.getData();
            this.sql = "REPLACE INTO ";
            this.sql = this.sql + channelCode + this.tableSuffix + " (j2ksec, rsam) VALUES (?,?)";
            this.ps = this.database.getPreparedStatement(this.sql);
            for (int i = 0; i < data.rows(); ++i) {
                if (i % 100 == 0) {
                    System.out.print(".");
                }
                this.ps.setDouble(1, data.getQuick(i, 0));
                this.ps.setDouble(2, data.getQuick(i, 1));
                this.ps.execute();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLEWRSAMDataSource.insertData()", e);
        }
    }
}

