/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.tensorstrain;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.data.GenericDataMatrix;
import java.util.List;

public class TensorstrainData
extends GenericDataMatrix {
    public TensorstrainData() {
    }

    public TensorstrainData(List<double[]> pts) {
        super(pts);
    }

    @Override
    public void setColumnNames() {
        this.columnMap.put("time", 0);
        this.columnMap.put("rank", 1);
        this.columnMap.put("ch0", 2);
        this.columnMap.put("ch1", 3);
        this.columnMap.put("ch2", 4);
        this.columnMap.put("ch3", 5);
        this.columnMap.put("eEEpeNN", 6);
        this.columnMap.put("eEEmeNN", 7);
        this.columnMap.put("e2EN", 8);
        this.columnMap.put("barometer", 9);
        this.columnMap.put("rainfall", 10);
        this.columnMap.put("pore", 11);
    }

    public DoubleMatrix2D getRainDataWithoutTime() {
        DoubleMatrix2D rain = DoubleFactory2D.dense.make(this.data.rows(), 1, Double.NaN);
        double total = 0.0;
        double r = 0.0;
        double last = this.data.getQuick(0, 10);
        rain.setQuick(0, 0, 0.0);
        for (int i = 1; i < this.data.rows(); ++i) {
            r = this.data.getQuick(i, 10);
            if (Double.isNaN(r)) continue;
            if (r < last) {
                last = 0.0;
            }
            last = r;
            rain.setQuick(i, 0, total += r - last);
        }
        return rain;
    }

    public DoubleMatrix2D getAllData(double theta) {
        return DoubleFactory2D.dense.compose((DoubleMatrix2D[][])new DoubleMatrix2D[][]{{this.data.viewPart(0, 0, this.data.rows(), 9), this.getRotatedDataWithoutTime(theta), this.data.viewPart(0, 9, this.data.rows(), 1), this.getRainDataWithoutTime(), this.data.viewPart(0, 11, this.data.rows(), 1)}});
    }

    public DoubleMatrix2D getRotatedDataWithoutTime(double theta) {
        DoubleMatrix2D en = DoubleFactory2D.dense.make(this.data.rows(), 2);
        double tr = Math.toRadians(theta);
        for (int i = 0; i < this.data.rows(); ++i) {
            en.setQuick(i, 0, this.data.getQuick(i, 7) * Math.cos(2.0 * tr) + this.data.getQuick(i, 8) * Math.sin(2.0 * tr));
            en.setQuick(i, 1, -this.data.getQuick(i, 7) * Math.sin(2.0 * tr) + this.data.getQuick(i, 8) * Math.cos(2.0 * tr));
        }
        return en;
    }
}

