/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.conn;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.in.conn.Connection;
import gov.usgs.vdx.in.hw.Device;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class IPConnection
extends Thread
implements Connection {
    protected String host;
    protected int port;
    protected int timeout;
    private Socket socket;
    private PrintWriter out;
    private InputStreamReader in;
    private char[] buffer;
    private static final int BUFFER_SIZE = 2048;
    protected volatile boolean stopThread = true;
    protected boolean open;
    protected Vector<String> msgQueue;
    protected boolean lockQueue;

    public IPConnection() {
        super("IPConnection");
    }

    public IPConnection(String name) {
        super(name);
    }

    @Override
    public void initialize(ConfigFile params) throws Exception {
        this.host = params.getString("host");
        this.port = Util.stringToInt(params.getString("port"));
        this.timeout = Util.stringToInt(params.getString("timeout"), 30000);
        this.buffer = new char[2048];
        this.msgQueue = new Vector(100);
    }

    @Override
    public void connect() throws Exception {
        try {
            this.open();
        }
        catch (UnknownHostException e) {
            throw new Exception("Unknown host: " + this.host + ":" + this.port);
        }
        catch (IOException e) {
            throw new Exception("Couldn't open socket input/output streams");
        }
    }

    @Override
    public void disconnect() {
        this.close();
    }

    public boolean open() throws UnknownHostException, IOException {
        boolean result = false;
        this.socket = new Socket(this.host, this.port);
        this.out = new PrintWriter(this.socket.getOutputStream());
        this.in = new InputStreamReader(this.socket.getInputStream());
        result = true;
        this.open = true;
        this.stopThread = false;
        this.socket.setSoLinger(true, 0);
        if (!this.isAlive()) {
            this.start();
        }
        return result;
    }

    public void close() {
        try {
            this.open = false;
            this.stopThread = true;
            this.out.close();
            this.in.close();
            this.socket.close();
            this.msgQueue.removeAllElements();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (!this.stopThread) {
            try {
                int count = this.in.read(this.buffer);
                this.receiveData(this.buffer, count);
            }
            catch (Exception exception) {}
        }
    }

    private synchronized void receiveData(char[] buffer, int count) {
        this.lockQueue = true;
        String msg = new String(buffer, 0, count);
        this.msgQueue.add(msg);
        this.lockQueue = false;
    }

    @Override
    public void writeString(String msg) throws Exception {
        if (!this.open) {
            throw new Exception("Connection not open");
        }
        int len = msg.length();
        int idx = 0;
        while (idx < len) {
            this.out.write(msg.charAt(idx++));
        }
        this.out.flush();
    }

    public String readString(Device device, int dataTimeout) throws Exception {
        if (!this.open) {
            throw new Exception("Connection not open");
        }
        long start = System.currentTimeMillis();
        long end = start + (long)dataTimeout;
        long now = start;
        long delay = 10L;
        if (dataTimeout > 0 && (long)dataTimeout < delay) {
            delay = dataTimeout;
        }
        StringBuffer sb = new StringBuffer();
        while (now < end || -1L == (long)dataTimeout) {
            if (!this.lockQueue && !this.msgQueue.isEmpty()) {
                sb.append(this.msgQueue.elementAt(0));
                this.msgQueue.removeElementAt(0);
                if (device != null) {
                    if (device.messageCompleted(sb.toString())) {
                        return sb.toString();
                    }
                } else {
                    return sb.toString();
                }
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        String txt = "Timeout while waiting for data.\n" + sb.toString();
        throw new Exception(txt);
    }

    public String readString(int dataTimeout) throws Exception {
        return this.readString(null, dataTimeout);
    }

    @Override
    public String readString(Device device) throws Exception {
        return this.readString(device, device.getTimeout());
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public String toString() {
        String settings = "host:" + this.host + "/";
        settings = settings + "port:" + this.port + "/";
        settings = settings + "timeout:" + this.timeout + "/";
        return settings;
    }

    @Override
    public String getMsgQueue() {
        return this.msgQueue.toString();
    }

    @Override
    public void emptyMsgQueue() {
        this.msgQueue.removeAllElements();
    }
}

