/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.generic.fixed;

import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.generic.fixed.SQLGenericFixedDataSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportYVOTemp {
    protected SQLGenericFixedDataSource dataSource;
    protected static Set<String> flags;
    protected static Set<String> keys;
    private SimpleDateFormat dateIn;
    private int timeZoneIndex;
    private int headerRows;
    private String table;
    private Double lon;
    private Double lat;
    private static final String CONFIG_FILE = "importGenericCSV.config";
    private ConfigFile params;
    private ConfigFile vdxParams;
    private List<Column> fileCols;
    protected Logger logger = Log.getLogger("gov.usgs.vdx");

    public ImportYVOTemp(String cf) {
        this.params = new ConfigFile(cf);
        this.logger.finer("Processing config file");
        this.processConfigFile();
        this.dataSource = new SQLGenericFixedDataSource();
        this.logger.finer("initalizing VDX params");
        this.logger.finest("exiting constructor");
    }

    private void processConfigFile() {
        this.fileCols = new ArrayList<Column>();
        this.vdxParams = new ConfigFile(this.params.getString("vdxConfig"));
        this.headerRows = Integer.parseInt(this.params.getString("headerRows"));
        this.table = this.params.getString("channel");
        ConfigFile sub = this.params.getSubConfig(this.table);
        this.lon = Double.parseDouble(sub.getString("lon"));
        this.lat = Double.parseDouble(sub.getString("lat"));
        sub = this.params.getSubConfig("tz");
        this.timeZoneIndex = Integer.parseInt(sub.getString("index"));
        this.dateIn = new SimpleDateFormat(sub.getString("format"));
        this.dateIn.setTimeZone(TimeZone.getTimeZone(sub.getString("zone")));
        List<String> columns = this.params.getList("column");
        for (String column : columns) {
            this.logger.finest("found column: " + column);
            sub = this.params.getSubConfig(column);
            int index = Integer.parseInt(sub.getString("index"));
            String description = sub.getString("description");
            String unit = sub.getString("unit");
            boolean checked = sub.getString("checked").equals("1");
            boolean active = sub.getString("active").equals("1");
            boolean bypassmanipulations = sub.getString("bypassmanipulations").equals("1");
            Column gc = new Column(index, column, description, unit, checked, active, bypassmanipulations);
            this.fileCols.add(gc);
        }
    }

    public void process(String f) {
        this.logger.fine("processing " + f);
        ArrayList<double[]> pts = new ArrayList<double[]>();
        try {
            ResourceReader rr = ResourceReader.getResourceReader(f);
            if (rr == null) {
                return;
            }
            this.logger.info("importing: " + f);
            String line = rr.nextLine();
            for (int i = 0; i < this.headerRows; ++i) {
                line = rr.nextLine();
            }
            while (line != null) {
                String[] s = line.split(",");
                this.logger.info("timestamp " + s[this.timeZoneIndex]);
                int i = 0;
                double[] d = new double[this.fileCols.size() + 1];
                Date date = this.dateIn.parse(s[this.timeZoneIndex]);
                d[i++] = Util.dateToJ2K(date);
                for (Column c : this.fileCols) {
                    this.logger.info(c.description + " = " + s[c.idx]);
                    d[i++] = Double.parseDouble(s[c.idx]);
                }
                pts.add(d);
                line = rr.nextLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GenericDataMatrix gd = new GenericDataMatrix(pts);
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add("t");
        for (Column c : this.fileCols) {
            colNames.add(c.name);
        }
        gd.setColumnNames(colNames.toArray(new String[0]));
    }

    protected static void outputInstructions() {
        System.out.println("<importer> -c [vdx config] -n [database name] files...");
        System.exit(-1);
    }

    protected static void process(Arguments args, SQLGenericFixedDataSource ds) {
        List<String> resources;
        if (args.size() == 0) {
            ImportYVOTemp.outputInstructions();
        }
        if ((resources = args.unused()) == null || resources.size() == 0) {
            System.out.println("no files");
            System.exit(-1);
        }
        for (String res : resources) {
            System.out.println("Reading resource: " + res);
        }
    }

    public List<Column> importResource(String resource) {
        String s;
        ResourceReader rr = ResourceReader.getResourceReader(resource);
        if (rr == null) {
            return null;
        }
        ArrayList<Column> hypos = new ArrayList<Column>();
        int lines = 0;
        while ((s = rr.nextLine()) != null) {
            try {
                ++lines;
                String year = s.substring(0, 4);
                String monthDay = s.substring(4, 8);
                if (!s.substring(8, 9).equals(" ")) {
                    throw new Exception("corrupt data at column 9");
                }
                String hourMin = s.substring(9, 13);
                String sec = s.substring(13, 19).trim();
                Date date = this.dateIn.parse(year + monthDay + hourMin + sec);
                double j2ksec = Util.dateToJ2K(date);
                double latdeg = Double.parseDouble(s.substring(19, 22).trim());
                double latmin = Double.parseDouble(s.substring(23, 28).trim());
                double lat = latdeg + latmin / 60.0;
                char ns = s.charAt(22);
                if (ns == 'S') {
                    lat *= -1.0;
                }
                double londeg = Double.parseDouble(s.substring(28, 32).trim());
                char ew = s.charAt(32);
                double lonmin = Double.parseDouble(s.substring(33, 38).trim());
                double lon = londeg + lonmin / 60.0;
                if (ew != 'W') {
                    lon *= -1.0;
                }
                double depth = -Double.parseDouble(s.substring(38, 45).trim());
                double mag = Double.parseDouble(s.substring(47, 52).trim());
                if (!s.substring(45, 46).equals(" ")) {
                    throw new Exception("corrupt data at column 46");
                }
                System.out.println("HC: " + j2ksec + " : " + lon + " : " + lat + " : " + depth + " : " + mag);
            }
            catch (Exception e) {
                System.err.println("Line " + lines + ": " + e.getMessage());
            }
        }
        rr.close();
        return hypos;
    }

    public void create() {
        this.logger.info("Creating channel " + this.table);
        this.dataSource.createChannel(this.table, this.table, this.lon, this.lat, Double.NaN, 1, 0);
    }

    public static void main(String[] as) {
        Logger logger = Log.getLogger("gov.usgs.vdx");
        logger.setLevel(Level.INFO);
        String cf = CONFIG_FILE;
        boolean createDatabase = false;
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> keys = new HashSet<String>();
        keys.add("-c");
        flags.add("-h");
        flags.add("--help");
        flags.add("-g");
        flags.add("--generate");
        flags.add("-v");
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h") || args.flagged("--help")) {
            System.err.println("java gov.usgs.vdx.data.generic.ImportCSV [-c configFile] [-g]");
            System.exit(-1);
        }
        if (args.flagged("-g") || args.flagged("--generate")) {
            createDatabase = true;
        }
        if (args.contains("-c")) {
            cf = args.get("-c");
        }
        if (args.flagged("-v")) {
            logger.setLevel(Level.ALL);
        }
        ImportYVOTemp in = new ImportYVOTemp(cf);
        List<String> files = args.unused();
        if (createDatabase) {
            in.create();
        }
        for (String file : files) {
            in.process(file);
        }
    }
}

