/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.generic.variable;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.ResourceReader;
import gov.usgs.vdx.data.generic.variable.DataType;
import gov.usgs.vdx.data.generic.variable.SQLGenericVariableDataSource;
import gov.usgs.vdx.data.generic.variable.Station;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportNWIS {
    private static final String CONFIG_FILE = "NWIS.config";
    private Logger logger;
    private List<Station> stations;
    private SQLGenericVariableDataSource dataSource = new SQLGenericVariableDataSource();
    private ConfigFile params;

    public ImportNWIS(String cf) {
        this.params = new ConfigFile(cf);
    }

    public void importWeb(Station st, int period) {
        if (!st.getActive()) {
            return;
        }
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        this.logger = Log.getLogger("gov.usgs.vdx");
        String fn = this.params.getString("url") + "&period=" + period + "&site_no=" + st.getSiteNo();
        try {
            ResourceReader rr = ResourceReader.getResourceReader(fn);
            if (rr == null) {
                return;
            }
            this.logger.info("importing: " + fn);
            SimpleDateFormat dateIn = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            dateIn.setTimeZone(TimeZone.getTimeZone(st.getTz()));
            String s = rr.nextLine();
            Pattern p = Pattern.compile("^#\\s+(\\d+)\\s+(\\d+)\\s+(.*)$");
            Pattern p1 = Pattern.compile("^#.*$");
            while (s != null && p1.matcher(s).matches()) {
                Matcher m = p.matcher(s);
                if (m.matches()) {
                    int dataType = Integer.parseInt(m.group(2));
                    String name = m.group(3);
                    dataTypes.add(new DataType(dataType, name));
                }
                s = rr.nextLine();
            }
            String[] ss = s.split("\t");
            for (int i = 0; i < dataTypes.size(); ++i) {
                int index = i * 2 + 3;
                int id = Integer.parseInt(ss[index].substring(3));
                if (((DataType)dataTypes.get(i)).getId() != id) {
                    for (int j = i; j < dataTypes.size(); ++j) {
                        if (((DataType)dataTypes.get(j)).getId() != id) continue;
                        DataType t = (DataType)dataTypes.get(i);
                        dataTypes.set(i, (DataType)dataTypes.get(j));
                        dataTypes.set(j, t);
                    }
                }
                ++i;
            }
            s = rr.nextLine();
            s = rr.nextLine();
            while (s != null) {
                ss = s.split("\t", -1);
                if (!ss[2].contains(" ")) {
                    ss[2] = ss[2] + " 00:00";
                }
                Date date = dateIn.parse(ss[2]);
                for (int i = 0; i < dataTypes.size(); ++i) {
                    int index = i * 2 + 3;
                    if (ss[index].length() > 0 && ss[index].indexOf(95) == -1) {
                        this.dataSource.insertRecord(date, st, (DataType)dataTypes.get(i), Double.parseDouble(ss[index]));
                    } else {
                        System.out.println("skipping " + ss[index] + " idex: " + ss[index].indexOf(95));
                    }
                    s = rr.nextLine();
                }
            }
            for (DataType dt : dataTypes) {
                this.dataSource.insertDataType(dt);
            }
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] as) {
        String cf = CONFIG_FILE;
        int period = 1;
        HashSet<String> flags = new HashSet<String>();
        HashSet<String> keys = new HashSet<String>();
        keys.add("-c");
        keys.add("-h");
        keys.add("-p");
        Arguments args = new Arguments(as, flags, keys);
        if (args.contains("-h")) {
            System.err.println("java gov.usgs.vdx.data.gps.ImportNWIS [-c configFile] [-p period]");
            System.exit(-1);
        }
        if (args.contains("-c")) {
            cf = args.get("-c");
        }
        if (args.contains("-p")) {
            period = Integer.parseInt(args.get("-p"));
        }
        ImportNWIS in = new ImportNWIS(cf);
        List<String> files = args.unused();
        for (Station station : in.stations) {
            in.importWeb(station, period);
        }
    }
}

