/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.gps;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.data.gps.GPS;
import gov.usgs.vdx.data.gps.SQLGPSDataSource;
import gov.usgs.vdx.data.gps.SolutionPoint;
import gov.usgs.vdx.in.Importer;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportStacov
implements Importer {
    public ResourceReader rr;
    public static Set<String> flags = new HashSet<String>();
    public static Set<String> keys = new HashSet<String>();
    public String vdxConfig;
    public ConfigFile params;
    public ConfigFile vdxParams;
    public ConfigFile rankParams;
    public ConfigFile columnParams;
    public ConfigFile channelParams;
    public ConfigFile dataSourceParams;
    public ConfigFile translationParams;
    public String driver;
    public String prefix;
    public String url;
    public SimpleDateFormat dateIn;
    public SimpleDateFormat dateOut;
    public Date date;
    public Double j2ksec;
    public String filenameMask;
    public int headerLines;
    public String timeZone;
    public String importColumns;
    public String[] importColumnArray;
    public Map<Integer, String> importColumnMap;
    public String dataSource;
    public SQLGPSDataSource sqlDataSource;
    public SQLDataSourceHandler sqlDataSourceHandler;
    public SQLDataSourceDescriptor sqlDataSourceDescriptor;
    public List<String> dataSourceList;
    public Iterator<String> dsIterator;
    public Map<String, SQLDataSource> sqlDataSourceMap;
    public Map<String, String> dataSourceColumnMap;
    public Map<String, String> dataSourceChannelMap;
    public Map<String, Integer> dataSourceRankMap;
    public Rank rank;
    public String rankName;
    public int rankValue;
    public int rankDefault;
    public int rid;
    public String channels;
    public String[] channelArray;
    public Map<String, Channel> channelMap;
    public Channel channel;
    public String channelCode;
    public String channelName;
    public double channelLon;
    public double channelLat;
    public double channelHeight;
    public List<String> channelList;
    public Iterator<String> chIterator;
    public String defaultChannels;
    public String columns;
    public String[] columnArray;
    public HashMap<String, Column> columnMap;
    public Column column;
    public String columnName;
    public String columnDescription;
    public String columnUnit;
    public int columnIdx;
    public boolean columnActive;
    public boolean columnChecked;
    public List<String> columnList;
    public Iterator<String> coIterator;
    public String defaultColumns;
    public String importerType = "gps";
    public Logger logger;

    @Override
    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.logger.log(Level.INFO, "ImportStacov.initialize() succeeded.");
        this.processConfigFile(configFile);
    }

    @Override
    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    @Override
    public void processConfigFile(String configFile) {
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, configFile + " was not successfully read");
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), "VDX.config");
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.sqlDataSourceHandler = new SQLDataSourceHandler(this.driver, this.url, this.prefix);
        this.dataSource = this.params.getString("dataSource");
        this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(this.dataSource);
        if (this.sqlDataSourceDescriptor == null) {
            this.logger.log(Level.SEVERE, this.dataSource + " sql data source does not exist in vdxSources.config");
        }
        this.sqlDataSource = (SQLGPSDataSource)this.sqlDataSourceDescriptor.getSQLDataSource();
        if (!this.sqlDataSource.getType().equals(this.importerType)) {
            this.logger.log(Level.SEVERE, "dataSource not a " + this.importerType + " data source");
            System.exit(-1);
        }
        this.dateIn = new SimpleDateFormat("yyMMMdd");
        this.dateIn.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "Raw Data");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
        if (this.sqlDataSource.getRanksFlag()) {
            Rank tempRank = this.sqlDataSource.defaultGetRank(this.rank);
            if (tempRank == null) {
                tempRank = this.sqlDataSource.defaultInsertRank(this.rank);
            }
            if (tempRank == null) {
                this.logger.log(Level.SEVERE, "invalid rank for dataSource " + this.dataSource);
                System.exit(-1);
            }
            this.rid = tempRank.getId();
        }
        List<Channel> chs = this.sqlDataSource.getChannelsList();
        this.channelMap = new HashMap<String, Channel>();
        for (Channel ch : chs) {
            this.channelMap.put(ch.getCode(), ch);
        }
    }

    @Override
    public void process(String filename) {
        try {
            SolutionPoint sp;
            double j2ksec1;
            double j2ksec0;
            this.rr = ResourceReader.getResourceReader(filename);
            if (this.rr == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is invalid)");
                return;
            }
            String line = this.rr.nextLine();
            if (line == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is empty)");
                return;
            }
            int numParams = Integer.parseInt(line.substring(0, 5).trim());
            SolutionPoint[] points = new SolutionPoint[numParams / 3];
            try {
                String timestamp = line.substring(20, 27);
                this.date = this.dateIn.parse(timestamp);
                this.date.setTime(this.date.getTime());
                j2ksec0 = Util.dateToJ2K(this.date);
                j2ksec1 = j2ksec0 + 86400.0;
            }
            catch (ParseException e) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + "  (timestamp not valid)");
                return;
            }
            int sid = this.sqlDataSource.insertSource(new File(filename).getName(), Util.md5Resource(filename), j2ksec0, j2ksec1, this.rid);
            if (sid == -1) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (hash already exists)");
                return;
            }
            this.logger.log(Level.INFO, "importing: " + filename);
            for (int i = 0; i < numParams / 3; ++i) {
                String sx = this.rr.nextLine();
                String sy = this.rr.nextLine();
                String sz = this.rr.nextLine();
                sp = new SolutionPoint();
                sp.channel = sx.substring(7, 11).trim();
                sp.dp.t = (j2ksec0 + j2ksec1) / 2.0;
                sp.dp.x = Double.parseDouble(sx.substring(25, 47).trim());
                sp.dp.sxx = Double.parseDouble(sx.substring(53, 74).trim());
                sp.dp.y = Double.parseDouble(sy.substring(25, 47).trim());
                sp.dp.syy = Double.parseDouble(sy.substring(53, 74).trim());
                sp.dp.z = Double.parseDouble(sz.substring(25, 47).trim());
                sp.dp.szz = Double.parseDouble(sz.substring(53, 74).trim());
                points[i] = sp;
            }
            boolean done = false;
            while (!done) {
                try {
                    String sc = this.rr.nextLine();
                    if (sc != null && sc.length() >= 2) {
                        int p1 = Integer.parseInt(sc.substring(0, 5).trim()) - 1;
                        int p2 = Integer.parseInt(sc.substring(5, 11).trim()) - 1;
                        double data = Double.parseDouble(sc.substring(13).trim());
                        if (p1 / 3 != p2 / 3) continue;
                        sp = points[p1 / 3];
                        int i1 = Math.min(p1 % 3, p2 % 3);
                        int i2 = Math.max(p1 % 3, p2 % 3);
                        if (i1 == 0 && i2 == 1) {
                            sp.dp.sxy = data;
                            continue;
                        }
                        if (i1 == 0 && i2 == 2) {
                            sp.dp.sxz = data;
                            continue;
                        }
                        if (i1 != 1 || i2 != 2) continue;
                        sp.dp.syz = data;
                        continue;
                    }
                    done = true;
                }
                catch (NumberFormatException e) {
                    done = true;
                }
            }
            this.rr.close();
            for (SolutionPoint spt : points) {
                spt.dp.sxy = spt.dp.sxy * spt.dp.sxx * spt.dp.syy;
                spt.dp.sxz = spt.dp.sxz * spt.dp.sxx * spt.dp.szz;
                spt.dp.syz = spt.dp.syz * spt.dp.syy * spt.dp.szz;
                spt.dp.sxx *= spt.dp.sxx;
                spt.dp.syy *= spt.dp.syy;
                spt.dp.szz *= spt.dp.szz;
                Channel channel = this.channelMap.get(spt.channel);
                if (channel == null) {
                    double[] llh = GPS.xyz2LLH(spt.dp.x, spt.dp.y, spt.dp.z);
                    this.sqlDataSource.createChannel(spt.channel, spt.channel, llh[0], llh[1], llh[2], 1);
                    channel = this.sqlDataSource.getChannel(spt.channel);
                    this.channelMap.put(spt.channel, channel);
                }
                this.sqlDataSource.insertSolution(sid, channel.getCID(), spt.dp);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "ImportStacov.process(" + filename + ") failed.", e);
        }
    }

    @Override
    public void outputInstructions(String importerClass, String message) {
        if (message == null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile filelist");
    }

    public static void main(String[] as) {
        ImportStacov importer = new ImportStacov();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        List<String> files = args.unused();
        for (String file : files) {
            importer.process(file);
        }
        importer.deinitialize();
    }

    static {
        keys.add("-c");
        flags.add("-h");
        flags.add("-v");
    }
}

