/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.gps;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.data.gps.GPS;
import gov.usgs.vdx.data.gps.SQLGPSDataSource;
import gov.usgs.vdx.data.gps.SolutionPoint;
import gov.usgs.vdx.in.Importer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportTDP
implements Importer {
    public ResourceReader rr;
    public static Set<String> flags = new HashSet<String>();
    public static Set<String> keys = new HashSet<String>();
    public String vdxConfig;
    public ConfigFile params;
    public ConfigFile vdxParams;
    public ConfigFile rankParams;
    public ConfigFile columnParams;
    public ConfigFile channelParams;
    public ConfigFile dataSourceParams;
    public ConfigFile translationParams;
    public String driver;
    public String prefix;
    public String url;
    public SimpleDateFormat dateIn;
    public SimpleDateFormat dateOut;
    public Date date;
    public Double j2ksec;
    public String filenameMask;
    public int headerLines;
    public String timeZone;
    public String importColumns;
    public String[] importColumnArray;
    public Map<Integer, String> importColumnMap;
    public String dataSource;
    public SQLGPSDataSource sqlDataSource;
    public SQLDataSourceHandler sqlDataSourceHandler;
    public SQLDataSourceDescriptor sqlDataSourceDescriptor;
    public List<String> dataSourceList;
    public Iterator<String> dsIterator;
    public Map<String, SQLDataSource> sqlDataSourceMap;
    public Map<String, String> dataSourceColumnMap;
    public Map<String, String> dataSourceChannelMap;
    public Map<String, Integer> dataSourceRankMap;
    public Rank rank;
    public String rankName;
    public int rankValue;
    public int rankDefault;
    public int rid;
    public String channels;
    public String[] channelArray;
    public Map<String, Channel> channelMap;
    public Channel channel;
    public String channelCode;
    public String channelName;
    public double channelLon;
    public double channelLat;
    public double channelHeight;
    public List<String> channelList;
    public Iterator<String> chIterator;
    public String defaultChannels;
    public String columns;
    public String[] columnArray;
    public HashMap<String, Column> columnMap;
    public Column column;
    public String columnName;
    public String columnDescription;
    public String columnUnit;
    public int columnIdx;
    public boolean columnActive;
    public boolean columnChecked;
    public List<String> columnList;
    public Iterator<String> coIterator;
    public String defaultColumns;
    public String importerType = "gps";
    public Logger logger;

    @Override
    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.logger.log(Level.INFO, "ImportTDP.initialize() succeeded.");
        this.processConfigFile(configFile);
    }

    @Override
    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    @Override
    public void processConfigFile(String configFile) {
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, configFile + " was not successfully read");
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), "VDX.config");
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.sqlDataSourceHandler = new SQLDataSourceHandler(this.driver, this.url, this.prefix);
        this.dataSource = this.params.getString("dataSource");
        this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(this.dataSource);
        if (this.sqlDataSourceDescriptor == null) {
            this.logger.log(Level.SEVERE, this.dataSource + " sql data source does not exist in vdxSources.config");
        }
        this.sqlDataSource = (SQLGPSDataSource)this.sqlDataSourceDescriptor.getSQLDataSource();
        if (!this.sqlDataSource.getType().equals(this.importerType)) {
            this.logger.log(Level.SEVERE, "dataSource not a " + this.importerType + " data source");
            System.exit(-1);
        }
        this.dateIn = new SimpleDateFormat("yyyy-M-d H:m:s");
        this.dateIn.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "Raw Data");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
        if (this.sqlDataSource.getRanksFlag()) {
            Rank tempRank = this.sqlDataSource.defaultGetRank(this.rank);
            if (tempRank == null) {
                tempRank = this.sqlDataSource.defaultInsertRank(this.rank);
            }
            if (tempRank == null) {
                this.logger.log(Level.SEVERE, "invalid rank for dataSource " + this.dataSource);
                System.exit(-1);
            }
            this.rid = tempRank.getId();
        }
        List<Channel> chs = this.sqlDataSource.getChannelsList();
        this.channelMap = new HashMap<String, Channel>();
        for (Channel ch : chs) {
            this.channelMap.put(ch.getCode(), ch);
        }
    }

    @Override
    public void process(String filename) {
        try {
            Channel channel;
            double j2ksec;
            String oneLine;
            this.rr = ResourceReader.getResourceReader(filename);
            if (this.rr == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is invalid)");
                return;
            }
            int numberOfLines = 0;
            while (this.rr.nextLine() != null) {
                ++numberOfLines;
            }
            this.rr.close();
            if (numberOfLines == 0) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + "(resource has 0 lines)");
                return;
            }
            this.logger.log(Level.INFO, "filename:" + filename);
            this.logger.log(Level.INFO, "lines:" + numberOfLines);
            this.rr = ResourceReader.getResourceReader(filename);
            Object[] observations = new Observation[numberOfLines];
            SolutionPoint[] points = new SolutionPoint[numberOfLines / 3];
            int count = 0;
            while ((oneLine = this.rr.nextLine()) != null) {
                String[] oneLineArray = oneLine.split(",");
                Date date = this.dateIn.parse(oneLineArray[0]);
                date.setTime(date.getTime());
                j2ksec = Util.dateToJ2K(date);
                double val = Double.parseDouble(oneLineArray[2]) * 1000.0;
                double sval = Double.parseDouble(oneLineArray[3]);
                String direction = oneLineArray[5].trim();
                String code = oneLineArray[6].trim();
                channel = this.channelMap.get(code);
                String sortValue = String.valueOf(j2ksec) + "  " + code + "  " + direction;
                observations[count] = new Observation(sortValue, j2ksec, code, direction, val, sval);
                ++count;
            }
            Arrays.sort(observations);
            for (int i = 0; i < numberOfLines / 3; ++i) {
                SolutionPoint sp = new SolutionPoint();
                sp.channel = ((Observation)observations[i * 3 + 0]).code;
                sp.dp.t = ((Observation)observations[i * 3 + 0]).j2ksec;
                sp.dp.x = ((Observation)observations[i * 3 + 0]).val;
                sp.dp.sxx = ((Observation)observations[i * 3 + 0]).sval;
                sp.dp.y = ((Observation)observations[i * 3 + 1]).val;
                sp.dp.syy = ((Observation)observations[i * 3 + 1]).sval;
                sp.dp.z = ((Observation)observations[i * 3 + 2]).val;
                sp.dp.szz = ((Observation)observations[i * 3 + 2]).sval;
                points[i] = sp;
            }
            this.rr.close();
            double prevj2ksec = -1.0;
            int sid = -1;
            for (SolutionPoint spt : points) {
                channel = this.channelMap.get(spt.channel);
                if (channel == null) {
                    double[] llh = GPS.xyz2LLH(spt.dp.x, spt.dp.y, spt.dp.z);
                    this.sqlDataSource.createChannel(spt.channel, spt.channel, llh[0], llh[1], llh[2], 1);
                    channel = this.sqlDataSource.getChannel(spt.channel);
                    this.channelMap.put(spt.channel, channel);
                }
                if ((j2ksec = spt.dp.t) != prevj2ksec) {
                    sid = this.sqlDataSource.insertSourceSimple(new File(filename).getName(), j2ksec, j2ksec, this.rid);
                    prevj2ksec = j2ksec;
                }
                this.sqlDataSource.insertSolution(sid, channel.getCID(), spt.dp);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "ImportTDP.process(" + filename + ") failed.", e);
        }
    }

    @Override
    public void outputInstructions(String importerClass, String message) {
        if (message == null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile filelist");
    }

    public static void main(String[] as) {
        ImportTDP importer = new ImportTDP();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        List<String> files = args.unused();
        for (String file : files) {
            importer.process(file);
        }
        importer.deinitialize();
    }

    static {
        keys.add("-c");
        flags.add("-h");
        flags.add("-v");
    }

    public class Observation
    implements Comparable {
        public String sortValue;
        public String code;
        public String direction;
        public double j2ksec;
        public double val;
        public double sval;

        public Observation(String sortValue, double j2ksec, String code, String direction, double val, double sval) {
            this.sortValue = sortValue;
            this.j2ksec = j2ksec;
            this.code = code;
            this.direction = direction;
            this.val = val;
            this.sval = sval;
        }

        public int compareTo(Object obj) {
            Observation tmp = (Observation)obj;
            return this.sortValue.compareTo(tmp.sortValue);
        }
    }
}

