/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hypo;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.SQLHypocenterDataSource;
import gov.usgs.vdx.in.Importer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportHypoInverse
implements Importer {
    public ResourceReader rr;
    public static Set<String> flags = new HashSet<String>();
    public static Set<String> keys = new HashSet<String>();
    public String vdxConfig;
    public ConfigFile params;
    public ConfigFile vdxParams;
    public ConfigFile rankParams;
    public ConfigFile columnParams;
    public ConfigFile channelParams;
    public ConfigFile dataSourceParams;
    public ConfigFile translationParams;
    public String driver;
    public String prefix;
    public String url;
    public SimpleDateFormat dateIn;
    public SimpleDateFormat dateOut;
    public Date date;
    public Double j2ksec;
    public String filenameMask;
    public int headerLines;
    public String importColumns;
    public String[] importColumnArray;
    public Map<Integer, String> importColumnMap;
    public String dataSource;
    public SQLHypocenterDataSource sqlDataSource;
    public SQLDataSourceHandler sqlDataSourceHandler;
    public SQLDataSourceDescriptor sqlDataSourceDescriptor;
    public List<String> dataSourceList;
    public Iterator<String> dsIterator;
    public Map<String, SQLDataSource> sqlDataSourceMap;
    public Map<String, String> dataSourceColumnMap;
    public Map<String, String> dataSourceChannelMap;
    public Map<String, Integer> dataSourceRankMap;
    public Rank rank;
    public String rankName;
    public int rankValue;
    public int rankDefault;
    public int rid;
    public String channels;
    public String[] channelArray;
    public Map<String, Channel> channelMap;
    public Channel channel;
    public String channelCode;
    public String channelName;
    public double channelLon;
    public double channelLat;
    public double channelHeight;
    public List<String> channelList;
    public Iterator<String> chIterator;
    public String defaultChannels;
    public String columns;
    public String[] columnArray;
    public HashMap<String, Column> columnMap;
    public Column column;
    public String columnName;
    public String columnDescription;
    public String columnUnit;
    public int columnIdx;
    public boolean columnActive;
    public boolean columnChecked;
    public List<String> columnList;
    public Iterator<String> coIterator;
    public String defaultColumns;
    public String importerType = "hypocenters";
    public Logger logger;

    @Override
    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.logger.log(Level.INFO, "ImportHypoInverse.initialize() succeeded.");
        this.processConfigFile(configFile);
    }

    @Override
    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    @Override
    public void processConfigFile(String configFile) {
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, configFile + " was not successfully read");
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), "VDX.config");
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.sqlDataSourceHandler = new SQLDataSourceHandler(this.driver, this.url, this.prefix);
        this.dataSource = this.params.getString("dataSource");
        this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(this.dataSource);
        if (this.sqlDataSourceDescriptor == null) {
            this.logger.log(Level.SEVERE, this.dataSource + " sql data source does not exist in vdxSources.config");
        }
        this.sqlDataSource = (SQLHypocenterDataSource)this.sqlDataSourceDescriptor.getSQLDataSource();
        if (!this.sqlDataSource.getType().equals(this.importerType)) {
            this.logger.log(Level.SEVERE, "dataSource not a " + this.importerType + " data source");
            System.exit(-1);
        }
        this.dateIn = new SimpleDateFormat(Util.stringToString(this.params.getString("timestamp"), "yyyyMMddHHmmssSS"));
        this.dateIn.setTimeZone(TimeZone.getTimeZone(Util.stringToString(this.params.getString("timezone"), "GMT")));
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "Raw Data");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
        if (this.sqlDataSource.getRanksFlag()) {
            Rank tempRank = this.sqlDataSource.defaultGetRank(this.rank);
            if (tempRank == null) {
                tempRank = this.sqlDataSource.defaultInsertRank(this.rank);
            }
            if (tempRank == null) {
                this.logger.log(Level.SEVERE, "invalid rank for dataSource " + this.dataSource);
                System.exit(-1);
            }
            this.rid = tempRank.getId();
        }
    }

    @Override
    public void process(String filename) {
        Double ampmag = Double.NaN;
        Double codamag = Double.NaN;
        Double dmin = Double.NaN;
        Double rms = Double.NaN;
        Double herr = Double.NaN;
        Double verr = Double.NaN;
        String magtype = null;
        String rmk = null;
        Integer nphases = null;
        Integer azgap = null;
        Integer nstimes = null;
        try {
            this.rr = ResourceReader.getResourceReader(filename);
            if (this.rr == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is invalid)");
                return;
            }
            String line = this.rr.nextLine();
            int lineNumber = 0;
            if (line == null) {
                this.logger.log(Level.SEVERE, "skipping: " + filename + " (resource is empty)");
                return;
            }
            this.logger.log(Level.INFO, "importing: " + filename);
            while (line != null) {
                double prefmag;
                double depth;
                double j2ksec;
                ++lineNumber;
                try {
                    String timestamp = line.substring(0, 16) + "0";
                    this.date = this.dateIn.parse(timestamp);
                    j2ksec = Util.dateToJ2K(this.date);
                }
                catch (ParseException e) {
                    this.logger.log(Level.SEVERE, "skipping: line number " + lineNumber + ".  Timestamp not valid.");
                    line = this.rr.nextLine();
                    continue;
                }
                String eid = line.substring(136, 146).trim();
                if (eid.trim().length() == 0) {
                    this.logger.log(Level.SEVERE, "skipping: line number " + lineNumber + ".  Event ID not valid.");
                    line = this.rr.nextLine();
                    continue;
                }
                double latdeg = Double.parseDouble(line.substring(16, 18).trim());
                double latmin = Double.parseDouble(line.substring(19, 21).trim() + "." + line.substring(21, 23).trim());
                double lat = latdeg + latmin / 60.0;
                char ns = line.charAt(18);
                if (ns == 'S') {
                    lat *= -1.0;
                }
                double londeg = Double.parseDouble(line.substring(23, 26).trim());
                double lonmin = Double.parseDouble(line.substring(27, 29).trim() + "." + line.substring(29, 31).trim());
                double lon = londeg + lonmin / 60.0;
                char ew = line.charAt(26);
                if (ew != 'E') {
                    lon *= -1.0;
                }
                try {
                    depth = Double.parseDouble(line.substring(31, 34).trim() + "." + line.substring(34, 36).trim());
                }
                catch (NumberFormatException e) {
                    this.logger.log(Level.SEVERE, "skipping: line number " + lineNumber + ".  Depth not valid.");
                    line = this.rr.nextLine();
                    continue;
                }
                try {
                    prefmag = Double.parseDouble(line.substring(147, 150).trim()) / 100.0;
                }
                catch (NumberFormatException e) {
                    prefmag = Double.NaN;
                }
                try {
                    ampmag = Double.parseDouble(line.substring(36, 39).trim()) / 100.0;
                }
                catch (NumberFormatException e) {
                    ampmag = Double.NaN;
                }
                try {
                    codamag = Double.parseDouble(line.substring(70, 73).trim()) / 100.0;
                }
                catch (NumberFormatException e) {
                    codamag = Double.NaN;
                }
                try {
                    nphases = Integer.parseInt(line.substring(39, 42).trim());
                }
                catch (NumberFormatException e) {
                    nphases = 0;
                }
                try {
                    azgap = Integer.parseInt(line.substring(42, 45).trim());
                }
                catch (NumberFormatException e) {
                    azgap = null;
                }
                try {
                    dmin = Double.parseDouble(line.substring(45, 48).trim());
                }
                catch (NumberFormatException e) {
                    dmin = Double.NaN;
                }
                try {
                    rms = Double.parseDouble(line.substring(48, 52).trim()) / 100.0;
                }
                catch (NumberFormatException e) {
                    rms = Double.NaN;
                }
                try {
                    nstimes = Integer.parseInt(line.substring(82, 85).trim());
                }
                catch (NumberFormatException e) {
                    nstimes = 0;
                }
                try {
                    herr = Double.parseDouble(line.substring(85, 89).trim()) / 100.0;
                }
                catch (NumberFormatException e) {
                    herr = Double.NaN;
                }
                try {
                    verr = Double.parseDouble(line.substring(89, 93).trim()) / 100.0;
                }
                catch (NumberFormatException e) {
                    verr = Double.NaN;
                }
                rmk = line.substring(80, 81).trim();
                if (rmk.trim().length() == 0) {
                    rmk = null;
                }
                if ((magtype = line.substring(146, 147).trim()).trim().length() == 0) {
                    magtype = null;
                }
                Hypocenter hc = new Hypocenter(j2ksec, eid, this.rid, lat, lon, depth, prefmag, ampmag, codamag, nphases, azgap, dmin, rms, nstimes, herr, verr, magtype, rmk);
                int result = this.sqlDataSource.insertHypocenter(hc);
                this.logger.log(Level.INFO, result + ":" + hc.toString());
                line = this.rr.nextLine();
            }
            this.rr.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "ImportHypoInverse.process(" + filename + ") failed.", e);
        }
    }

    @Override
    public void outputInstructions(String importerClass, String message) {
        if (message == null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile filelist");
    }

    public static void main(String[] as) {
        ImportHypoInverse importer = new ImportHypoInverse();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (!args.contains("-c")) {
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        List<String> files = args.unused();
        for (String file : files) {
            importer.process(file);
        }
        importer.deinitialize();
    }

    static {
        keys.add("-c");
        flags.add("-h");
        flags.add("-v");
    }
}

