/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.server;

import gov.usgs.net.NetTools;
import gov.usgs.plot.data.BinaryDataSet;
import gov.usgs.util.Util;
import gov.usgs.vdx.server.RequestResult;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class BinaryResult
extends RequestResult {
    protected BinaryDataSet data;
    private transient ByteBuffer compressedBytes;

    public BinaryResult(BinaryDataSet d) {
        this.data = d;
    }

    public BinaryDataSet getData() {
        return this.data;
    }

    @Override
    public void prepare() {
        ByteBuffer buffer = this.data.toBinary();
        byte[] cb = Util.compress(buffer.array(), 1);
        this.compressedBytes = ByteBuffer.wrap(cb);
        this.set("bytes", Integer.toString(this.compressedBytes.limit()));
    }

    @Override
    protected void writeBody(NetTools netTools, SocketChannel channel) {
        netTools.writeByteBuffer(this.compressedBytes, channel);
    }
}

