/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.winston.in.ew.Options;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public abstract class TraceBufFilter
implements Comparable<TraceBufFilter> {
    protected boolean keepRejects = false;
    protected Level logLevel = Level.FINEST;
    protected boolean accept = true;
    protected int order = 1;
    protected boolean terminal = true;
    private Map<String, String> metadata;

    protected abstract boolean match(TraceBuf var1, Options var2);

    public void configure(ConfigFile cf) {
        if (cf == null) {
            return;
        }
        this.order = Util.stringToInt(cf.getString("order"), -1);
        String action = cf.getString("action");
        if (action == null) {
            this.accept = true;
            return;
        }
        if (action.toLowerCase().equals("reject")) {
            this.accept = false;
        }
        int log = Util.stringToInt(cf.getString("log"), 0);
        switch (log) {
            case 0: {
                this.logLevel = Level.FINEST;
                break;
            }
            case 1: {
                this.logLevel = Level.FINE;
                break;
            }
            case 2: {
                this.logLevel = Level.WARNING;
            }
        }
    }

    public void setKeepRejects(boolean b) {
        this.keepRejects = b;
    }

    public boolean keepRejects() {
        return this.keepRejects;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String n, String v) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(n, v);
    }

    @Override
    public int compareTo(TraceBufFilter other) {
        return this.order - other.order;
    }
}

