/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraphConstants;

class RrdFetchCmd
extends RrdToolCmd
implements RrdGraphConstants {
    RrdFetchCmd() {
    }

    String getCmdType() {
        return "fetch";
    }

    Object execute() throws IOException {
        String startStr = this.getOptionValue("s", "start", "end-1d");
        String endStr = this.getOptionValue("e", "end", "now");
        long[] timestamps = Util.getTimestamps(startStr, endStr);
        String resolutionStr = this.getOptionValue("r", "resolution", "1");
        long resolution = RrdFetchCmd.parseLong(resolutionStr);
        String[] words = this.getRemainingWords();
        if (words.length != 3) {
            throw new IllegalArgumentException("Invalid rrdfetch syntax");
        }
        String path = words[1];
        ConsolFun consolFun = ConsolFun.valueOf(words[2]);
        RrdDb rrdDb = RrdFetchCmd.getRrdDbReference(path);
        try {
            FetchRequest fetchRequest = rrdDb.createFetchRequest(consolFun, timestamps[0], timestamps[1], resolution);
            System.out.println(fetchRequest.dump());
            FetchData fetchData = fetchRequest.fetchData();
            RrdFetchCmd.println(fetchData.toString());
            FetchData fetchData2 = fetchData;
            return fetchData2;
        }
        finally {
            RrdFetchCmd.releaseRrdDbReference(rrdDb);
        }
    }
}

