/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;

class RrdGraphCmd
extends RrdToolCmd
implements RrdGraphConstants {
    static final Color BLIND_COLOR = new Color(0, 0, 0, 0);
    private RrdGraphDef gdef;

    RrdGraphCmd() {
    }

    String getCmdType() {
        return "graph";
    }

    Object execute() throws IOException {
        String[] words;
        this.gdef = new RrdGraphDef();
        String t1 = this.getOptionValue("s", "start", "end-1d");
        String t2 = this.getOptionValue("e", "end", "now");
        this.gdef.setTimeSpan(Util.getTimestamps(t1, t2));
        this.parseXGrid(this.getOptionValue("x", "x-grid"));
        this.parseYGrid(this.getOptionValue("y", "y-grid"));
        this.gdef.setAltYGrid(this.getBooleanOption("Y", "alt-y-grid"));
        this.gdef.setNoMinorGrid(this.getBooleanOption(null, "no-minor"));
        this.gdef.setAltYMrtg(this.getBooleanOption("R", "alt-y-mrtg"));
        this.gdef.setAltAutoscale(this.getBooleanOption("A", "alt-autoscale"));
        this.gdef.setAltAutoscaleMax(this.getBooleanOption("M", "alt-autoscale-max"));
        String opt = this.getOptionValue("X", "units-exponent");
        if (opt != null) {
            this.gdef.setUnitsExponent(RrdGraphCmd.parseInt(opt));
        }
        if ((opt = this.getOptionValue("L", "units-length")) != null) {
            this.gdef.setUnitsLength(RrdGraphCmd.parseInt(opt));
        }
        if ((opt = this.getOptionValue("v", "vertical-label")) != null) {
            this.gdef.setVerticalLabel(opt);
        }
        if ((opt = this.getOptionValue("w", "width")) != null) {
            this.gdef.setWidth(RrdGraphCmd.parseInt(opt));
        }
        if ((opt = this.getOptionValue("h", "height")) != null) {
            this.gdef.setHeight(RrdGraphCmd.parseInt(opt));
        }
        this.gdef.setInterlaced(this.getBooleanOption("i", "interlaced"));
        opt = this.getOptionValue("f", "imginfo");
        if (opt != null) {
            this.gdef.setImageInfo(opt);
        }
        if ((opt = this.getOptionValue("a", "imgformat")) != null) {
            this.gdef.setImageFormat(opt);
        }
        if ((opt = this.getOptionValue("B", "background")) != null) {
            this.gdef.setBackgroundImage(opt);
        }
        if ((opt = this.getOptionValue("O", "overlay")) != null) {
            this.gdef.setOverlayImage(opt);
        }
        if ((opt = this.getOptionValue("U", "unit")) != null) {
            this.gdef.setUnit(opt);
        }
        this.gdef.setLazy(this.getBooleanOption("z", "lazy"));
        opt = this.getOptionValue("u", "upper-limit");
        if (opt != null) {
            this.gdef.setMaxValue(RrdGraphCmd.parseDouble(opt));
        }
        if ((opt = this.getOptionValue("l", "lower-limit")) != null) {
            this.gdef.setMinValue(RrdGraphCmd.parseDouble(opt));
        }
        this.gdef.setRigid(this.getBooleanOption("r", "rigid"));
        opt = this.getOptionValue("b", "base");
        if (opt != null) {
            this.gdef.setBase(RrdGraphCmd.parseDouble(opt));
        }
        this.gdef.setLogarithmic(this.getBooleanOption("o", "logarithmic"));
        this.parseColors(this.getMultipleOptionValues("c", "color"));
        this.gdef.setNoLegend(this.getBooleanOption("g", "no-legend"));
        this.gdef.setOnlyGraph(this.getBooleanOption("j", "only-graph"));
        this.gdef.setForceRulesLegend(this.getBooleanOption("F", "force-rules-legend"));
        opt = this.getOptionValue("t", "title");
        if (opt != null) {
            this.gdef.setTitle(opt);
        }
        if ((opt = this.getOptionValue("S", "step")) != null) {
            this.gdef.setStep(RrdGraphCmd.parseLong(opt));
        }
        if ((words = this.getRemainingWords()).length < 2) {
            throw new IllegalArgumentException("Image filename must be specified");
        }
        this.gdef.setFilename(words[1]);
        int i = 2;
        while (i < words.length) {
            if (words[i].startsWith("DEF:")) {
                this.parseDef(words[i]);
            } else if (words[i].startsWith("CDEF:")) {
                this.parseCDef(words[i]);
            } else if (words[i].startsWith("PRINT:")) {
                this.parsePrint(words[i]);
            } else if (words[i].startsWith("GPRINT:")) {
                this.parseGPrint(words[i]);
            } else if (words[i].startsWith("COMMENT:")) {
                this.parseComment(words[i]);
            } else if (words[i].startsWith("HRULE:")) {
                this.parseHRule(words[i]);
            } else if (words[i].startsWith("VRULE:")) {
                this.parseVRule(words[i]);
            } else if (words[i].startsWith("LINE1:") || words[i].startsWith("LINE2:") || words[i].startsWith("LINE3:")) {
                this.parseLine(words[i]);
            } else if (words[i].startsWith("AREA:")) {
                this.parseArea(words[i]);
            } else if (words[i].startsWith("STACK:")) {
                this.parseStack(words[i]);
            } else {
                throw new IllegalArgumentException("Unexpected GRAPH token encountered: " + words[i]);
            }
            ++i;
        }
        RrdGraphInfo info = new RrdGraph(this.gdef).getRrdGraphInfo();
        if (info.getFilename().equals("-")) {
            RrdGraphCmd.println(new String(info.getBytes()));
        } else {
            String[] plines;
            RrdGraphCmd.println(String.valueOf(info.getWidth()) + "x" + info.getHeight());
            String[] stringArray = plines = info.getPrintLines();
            int n = plines.length;
            int n2 = 0;
            while (n2 < n) {
                String pline = stringArray[n2];
                RrdGraphCmd.println(pline);
                ++n2;
            }
            if (info.getImgInfo() != null && info.getImgInfo().length() > 0) {
                RrdGraphCmd.println(info.getImgInfo());
            }
        }
        return info;
    }

    private void parseLine(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2 && tokens1.length != 3) {
            throw new IllegalArgumentException("Invalid LINE statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 1 && tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid LINE statement: " + word);
        }
        float width = Integer.parseInt(tokens1[0].substring(tokens1[0].length() - 1));
        String name = tokens2[0];
        Color color = tokens2.length == 2 ? Util.parseColor(tokens2[1]) : BLIND_COLOR;
        String legend = tokens1.length == 3 ? tokens1[2] : null;
        this.gdef.line(name, color, legend, width);
    }

    private void parseArea(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2 && tokens1.length != 3) {
            throw new IllegalArgumentException("Invalid AREA statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 1 && tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid AREA statement: " + word);
        }
        String name = tokens2[0];
        Color color = tokens2.length == 2 ? Util.parseColor(tokens2[1]) : BLIND_COLOR;
        String legend = tokens1.length == 3 ? tokens1[2] : null;
        this.gdef.area(name, color, legend);
    }

    private void parseStack(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2 && tokens1.length != 3) {
            throw new IllegalArgumentException("Invalid STACK statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 1 && tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid STACK statement: " + word);
        }
        String name = tokens2[0];
        Color color = tokens2.length == 2 ? Util.parseColor(tokens2[1]) : BLIND_COLOR;
        String legend = tokens1.length == 3 ? tokens1[2] : null;
        this.gdef.stack(name, color, legend);
    }

    private void parseHRule(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length < 2 || tokens1.length > 3) {
            throw new IllegalArgumentException("Invalid HRULE statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid HRULE statement: " + word);
        }
        double value = RrdGraphCmd.parseDouble(tokens2[0]);
        Paint color = Util.parseColor(tokens2[1]);
        this.gdef.hrule(value, color, tokens1.length == 3 ? tokens1[2] : null);
    }

    private void parseVRule(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length < 2 || tokens1.length > 3) {
            throw new IllegalArgumentException("Invalid VRULE statement: " + word);
        }
        String[] tokens2 = tokens1[1].split("#");
        if (tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid VRULE statement: " + word);
        }
        long timestamp = Util.getTimestamp(tokens2[0]);
        Paint color = Util.parseColor(tokens2[1]);
        this.gdef.vrule(timestamp, color, tokens1.length == 3 ? tokens1[2] : null);
    }

    private void parseComment(String word) {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid COMMENT specification: " + word);
        }
        this.gdef.comment(tokens[1]);
    }

    private void parseDef(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 4) {
            throw new IllegalArgumentException("Invalid DEF specification: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid DEF specification: " + word);
        }
        this.gdef.datasource(tokens2[0], tokens2[1], tokens1[2], ConsolFun.valueOf(tokens1[3]));
    }

    private void parseCDef(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2) {
            throw new IllegalArgumentException("Invalid CDEF specification: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid DEF specification: " + word);
        }
        this.gdef.datasource(tokens2[0], tokens2[1]);
    }

    private void parsePrint(String word) {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 4) {
            throw new IllegalArgumentException("Invalid PRINT specification: " + word);
        }
        this.gdef.print(tokens[1], ConsolFun.valueOf(tokens[2]), tokens[3]);
    }

    private void parseGPrint(String word) {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 4) {
            throw new IllegalArgumentException("Invalid GPRINT specification: " + word);
        }
        this.gdef.gprint(tokens[1], ConsolFun.valueOf(tokens[2]), tokens[3]);
    }

    private void parseColors(String[] colorOptions) {
        if (colorOptions == null) {
            return;
        }
        String[] stringArray = colorOptions;
        int n = colorOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String colorOption = stringArray[n2];
            String[] tokens = colorOption.split("#");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Invalid COLOR specification: " + colorOption);
            }
            String colorName = tokens[0];
            Paint paint = Util.parseColor(tokens[1]);
            this.gdef.setColor(colorName, paint);
            ++n2;
        }
    }

    private void parseYGrid(String ygrid) {
        if (ygrid == null) {
            return;
        }
        if (ygrid.equalsIgnoreCase("none")) {
            this.gdef.setDrawYGrid(false);
            return;
        }
        String[] tokens = new ColonSplitter(ygrid).split();
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid YGRID settings: " + ygrid);
        }
        double gridStep = RrdGraphCmd.parseDouble(tokens[0]);
        int labelFactor = RrdGraphCmd.parseInt(tokens[1]);
        this.gdef.setValueAxis(gridStep, labelFactor);
    }

    private void parseXGrid(String xgrid) {
        if (xgrid == null) {
            return;
        }
        if (xgrid.equalsIgnoreCase("none")) {
            this.gdef.setDrawXGrid(false);
            return;
        }
        String[] tokens = new ColonSplitter(xgrid).split();
        if (tokens.length != 8) {
            throw new IllegalArgumentException("Invalid XGRID settings: " + xgrid);
        }
        int minorUnit = this.resolveUnit(tokens[0]);
        int majorUnit = this.resolveUnit(tokens[2]);
        int labelUnit = this.resolveUnit(tokens[4]);
        int minorUnitCount = RrdGraphCmd.parseInt(tokens[1]);
        int majorUnitCount = RrdGraphCmd.parseInt(tokens[3]);
        int labelUnitCount = RrdGraphCmd.parseInt(tokens[5]);
        int labelSpan = RrdGraphCmd.parseInt(tokens[6]);
        String fmt = tokens[7];
        this.gdef.setTimeAxis(minorUnit, minorUnitCount, majorUnit, majorUnitCount, labelUnit, labelUnitCount, labelSpan, fmt);
    }

    private int resolveUnit(String unitName) {
        String[] unitNames = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR"};
        int[] units = new int[]{13, 12, 11, 5, 3, 2, 1};
        int i = 0;
        while (i < unitNames.length) {
            if (unitName.equalsIgnoreCase(unitNames[i])) {
                return units[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown time unit specified: " + unitName);
    }
}

