/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.RrdDb;

class RrdRestoreCmd
extends RrdToolCmd {
    RrdRestoreCmd() {
    }

    String getCmdType() {
        return "restore";
    }

    Object execute() throws IOException {
        boolean check = this.getBooleanOption("r", "range-check");
        String[] words = this.getRemainingWords();
        if (words.length != 3) {
            throw new IllegalArgumentException("Invalid rrdrestore syntax");
        }
        String xmlPath = words[1];
        String rrdPath = words[2];
        RrdDb rrdDb = RrdRestoreCmd.getRrdDbReference(rrdPath, xmlPath);
        try {
            if (check) {
                int dsCount = rrdDb.getHeader().getDsCount();
                int i = 0;
                while (i < dsCount) {
                    Datasource ds = rrdDb.getDatasource(i);
                    double minValue = ds.getMinValue();
                    double maxValue = ds.getMaxValue();
                    ds.setMinMaxValue(minValue, maxValue, true);
                    ++i;
                }
            }
            String string = rrdPath;
            return string;
        }
        finally {
            RrdRestoreCmd.releaseRrdDbReference(rrdDb);
        }
    }
}

