/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.rrd4j.ConsolFun;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.RrdGraphConstants;

class RrdXportCmd
extends RrdToolCmd
implements RrdGraphConstants {
    private DataProcessor dproc;
    private List<XPort> xports;

    RrdXportCmd() {
    }

    String getCmdType() {
        return "xport";
    }

    Object execute() throws IOException {
        String startStr = this.getOptionValue("s", "start", "end-1d");
        String endStr = this.getOptionValue("e", "end", "now");
        long[] span = Util.getTimestamps(startStr, endStr);
        this.dproc = new DataProcessor(span[0], span[1]);
        this.xports = new ArrayList<XPort>();
        long step = RrdXportCmd.parseLong(this.getOptionValue(null, "step", "1"));
        int maxRows = RrdXportCmd.parseInt(this.getOptionValue("m", "maxrows", "400"));
        long minStep = (long)Math.ceil((double)(span[1] - span[0]) / (double)(maxRows - 1));
        step = Math.max(step, minStep);
        this.dproc.setStep(step);
        String[] words = this.getRemainingWords();
        if (words.length < 2) {
            throw new IllegalArgumentException("Incomplete XPORT command");
        }
        int i = 1;
        while (i < words.length) {
            if (words[i].startsWith("DEF:")) {
                this.parseDef(words[i]);
            } else if (words[i].startsWith("CDEF:")) {
                this.parseCDef(words[i]);
            } else if (words[i].startsWith("XPORT:")) {
                this.parseXport(words[i]);
            } else {
                throw new IllegalArgumentException("Invalid XPORT syntax: " + words[i]);
            }
            ++i;
        }
        String result = this.xports.size() == 0 ? null : this.xport();
        RrdXportCmd.println(this.xports.size() == 0 ? "No XPORT statement found, nothing done" : result);
        return result;
    }

    private String xport() throws IOException {
        this.dproc.processData();
        long[] timestamps = this.dproc.getTimestamps();
        for (XPort xport : this.xports) {
            xport.values = this.dproc.getValues(xport.name);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XmlWriter w = new XmlWriter(stream);
        w.startTag("xport");
        w.startTag("meta");
        w.writeTag("start", timestamps[0]);
        w.writeTag("step", timestamps[1] - timestamps[0]);
        w.writeTag("end", timestamps[timestamps.length - 1]);
        w.writeTag("rows", timestamps.length);
        w.writeTag("columns", this.xports.size());
        w.startTag("legend");
        for (XPort xport1 : this.xports) {
            w.writeTag("entry", xport1.legend);
        }
        w.closeTag();
        w.closeTag();
        w.startTag("data");
        int i = 0;
        while (i < timestamps.length) {
            w.startTag("row");
            w.writeComment(new Date(timestamps[i] * 1000L));
            w.writeTag("t", timestamps[i]);
            for (XPort xport : this.xports) {
                w.writeTag("v", xport.values[i]);
            }
            w.closeTag();
            ++i;
        }
        w.closeTag();
        w.closeTag();
        w.flush();
        String result = stream.toString();
        stream.close();
        return result;
    }

    private void parseDef(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 4) {
            throw new IllegalArgumentException("Invalid DEF syntax: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid DEF syntax: " + word);
        }
        this.dproc.addDatasource(tokens2[0], tokens2[1], tokens1[2], ConsolFun.valueOf(tokens1[3]));
    }

    private void parseCDef(String word) {
        String[] tokens1 = new ColonSplitter(word).split();
        if (tokens1.length != 2) {
            throw new IllegalArgumentException("Invalid CDEF syntax: " + word);
        }
        String[] tokens2 = tokens1[1].split("=");
        if (tokens2.length != 2) {
            throw new IllegalArgumentException("Invalid CDEF syntax: " + word);
        }
        this.dproc.addDatasource(tokens2[0], tokens2[1]);
    }

    private void parseXport(String word) {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length != 2 && tokens.length != 3) {
            throw new IllegalArgumentException("Invalid XPORT syntax: " + word);
        }
        XPort xport = new XPort(tokens[1], tokens.length == 3 ? tokens[2] : null);
        this.xports.add(xport);
    }

    static class XPort {
        String name;
        String legend;
        double[] values;

        XPort(String name, String legend) {
            this.name = name;
            this.legend = legend != null ? legend : "";
        }
    }
}

