/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import org.rrd4j.ConsolFun;

public class ArcDef {
    private ConsolFun consolFun;
    private double xff;
    private int steps;
    private int rows;

    public ArcDef(ConsolFun consolFun, double xff, int steps, int rows) {
        if (consolFun == null) {
            throw new IllegalArgumentException("Null consolidation function specified");
        }
        if (Double.isNaN(xff) || xff < 0.0 || xff >= 1.0) {
            throw new IllegalArgumentException("Invalid xff, must be >= 0 and < 1: " + xff);
        }
        if (steps < 1 || rows < 2) {
            throw new IllegalArgumentException("Invalid steps/rows settings: " + steps + "/" + rows + ". Minimal values allowed are steps=1, rows=2");
        }
        this.consolFun = consolFun;
        this.xff = xff;
        this.steps = steps;
        this.rows = rows;
    }

    public ConsolFun getConsolFun() {
        return this.consolFun;
    }

    public double getXff() {
        return this.xff;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getRows() {
        return this.rows;
    }

    public String dump() {
        return "RRA:" + (Object)((Object)this.consolFun) + ":" + this.xff + ":" + this.steps + ":" + this.rows;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArcDef) {
            ArcDef arcObj = (ArcDef)obj;
            return this.consolFun == arcObj.consolFun && this.steps == arcObj.steps;
        }
        return false;
    }

    void setRows(int rows) {
        this.rows = rows;
    }

    boolean exactlyEqual(ArcDef def) {
        return this.consolFun == def.consolFun && this.xff == def.xff && this.steps == def.steps && this.rows == def.rows;
    }
}

