/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.Archive;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;
import org.rrd4j.data.Aggregates;
import org.rrd4j.data.DataProcessor;

public class FetchData {
    private static final String RPN_SOURCE_NAME = "WHERE THE SPEECHLES UNITE IN A SILENT ACCORD";
    private FetchRequest request;
    private String[] dsNames;
    private long[] timestamps;
    private double[][] values;
    private Archive matchingArchive;
    private long arcStep;
    private long arcEndTime;

    FetchData(Archive matchingArchive, FetchRequest request) throws IOException {
        this.matchingArchive = matchingArchive;
        this.arcStep = matchingArchive.getArcStep();
        this.arcEndTime = matchingArchive.getEndTime();
        this.dsNames = request.getFilter();
        if (this.dsNames == null) {
            this.dsNames = matchingArchive.getParentDb().getDsNames();
        }
        this.request = request;
    }

    void setTimestamps(long[] timestamps) {
        this.timestamps = timestamps;
    }

    void setValues(double[][] values) {
        this.values = values;
    }

    public int getRowCount() {
        return this.timestamps.length;
    }

    public int getColumnCount() {
        return this.dsNames.length;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long getStep() {
        return this.timestamps[1] - this.timestamps[0];
    }

    public double[] getValues(int dsIndex) {
        return this.values[dsIndex];
    }

    public double[][] getValues() {
        return this.values;
    }

    public double[] getValues(String dsName) {
        int dsIndex = 0;
        while (dsIndex < this.getColumnCount()) {
            if (dsName.equals(this.dsNames[dsIndex])) {
                return this.getValues(dsIndex);
            }
            ++dsIndex;
        }
        throw new IllegalArgumentException("Datasource [" + dsName + "] not found");
    }

    public double[] getRpnValues(String rpnExpression) {
        DataProcessor dataProcessor = this.createDataProcessor(rpnExpression);
        return dataProcessor.getValues(RPN_SOURCE_NAME);
    }

    public FetchRequest getRequest() {
        return this.request;
    }

    public long getFirstTimestamp() {
        return this.timestamps[0];
    }

    public long getLastTimestamp() {
        return this.timestamps[this.timestamps.length - 1];
    }

    public Archive getMatchingArchive() {
        return this.matchingArchive;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public int getDsIndex(String dsName) {
        int i = 0;
        while (i < this.dsNames.length) {
            if (this.dsNames[i].equals(dsName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder("");
        int row = 0;
        while (row < this.getRowCount()) {
            buffer.append(this.timestamps[row]);
            buffer.append(":  ");
            int dsIndex = 0;
            while (dsIndex < this.getColumnCount()) {
                buffer.append(Util.formatDouble(this.values[dsIndex][row], true));
                buffer.append("  ");
                ++dsIndex;
            }
            buffer.append("\n");
            ++row;
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(FetchData.padWithBlanks("", 10));
        buff.append(" ");
        String[] stringArray = this.dsNames;
        int n = this.dsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dsName = stringArray[n2];
            buff.append(FetchData.padWithBlanks(dsName, 18));
            ++n2;
        }
        buff.append("\n \n");
        int i = 0;
        while (i < this.timestamps.length) {
            buff.append(FetchData.padWithBlanks("" + this.timestamps[i], 10));
            buff.append(":");
            int j = 0;
            while (j < this.dsNames.length) {
                double value = this.values[j][i];
                String valueStr = Double.isNaN(value) ? "nan" : Util.formatDouble(value);
                buff.append(FetchData.padWithBlanks(valueStr, 18));
                ++j;
            }
            buff.append("\n");
            ++i;
        }
        return buff.toString();
    }

    private static String padWithBlanks(String input, int width) {
        StringBuilder buff = new StringBuilder("");
        int diff = width - input.length();
        while (diff-- > 0) {
            buff.append(' ');
        }
        buff.append(input);
        return buff.toString();
    }

    public double getAggregate(String dsName, ConsolFun consolFun) {
        DataProcessor dp = this.createDataProcessor(null);
        return dp.getAggregate(dsName, consolFun);
    }

    public double getAggregate(String dsName, ConsolFun consolFun, String rpnExpression) throws IOException {
        rpnExpression = rpnExpression.replaceAll("value", dsName);
        return this.getRpnAggregate(rpnExpression, consolFun);
    }

    public double getRpnAggregate(String rpnExpression, ConsolFun consolFun) {
        DataProcessor dataProcessor = this.createDataProcessor(rpnExpression);
        return dataProcessor.getAggregate(RPN_SOURCE_NAME, consolFun);
    }

    public Aggregates getAggregates(String dsName) {
        DataProcessor dataProcessor = this.createDataProcessor(null);
        return dataProcessor.getAggregates(dsName);
    }

    public Aggregates getRpnAggregates(String rpnExpression) throws IOException {
        DataProcessor dataProcessor = this.createDataProcessor(rpnExpression);
        return dataProcessor.getAggregates(RPN_SOURCE_NAME);
    }

    public double get95Percentile(String dsName) {
        DataProcessor dataProcessor = this.createDataProcessor(null);
        return dataProcessor.get95Percentile(dsName);
    }

    public double getRpn95Percentile(String rpnExpression) {
        DataProcessor dataProcessor = this.createDataProcessor(rpnExpression);
        return dataProcessor.get95Percentile(RPN_SOURCE_NAME);
    }

    public void exportXml(OutputStream outputStream) throws IOException {
        XmlWriter writer = new XmlWriter(outputStream);
        writer.startTag("fetch_data");
        writer.startTag("request");
        writer.writeTag("file", this.request.getParentDb().getPath());
        writer.writeComment(Util.getDate(this.request.getFetchStart()));
        writer.writeTag("start", this.request.getFetchStart());
        writer.writeComment(Util.getDate(this.request.getFetchEnd()));
        writer.writeTag("end", this.request.getFetchEnd());
        writer.writeTag("resolution", this.request.getResolution());
        writer.writeTag("cf", (Object)this.request.getConsolFun());
        writer.closeTag();
        writer.startTag("datasources");
        String[] stringArray = this.dsNames;
        int n = this.dsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dsName = stringArray[n2];
            writer.writeTag("name", dsName);
            ++n2;
        }
        writer.closeTag();
        writer.startTag("data");
        int i = 0;
        while (i < this.timestamps.length) {
            writer.startTag("row");
            writer.writeComment(Util.getDate(this.timestamps[i]));
            writer.writeTag("timestamp", this.timestamps[i]);
            writer.startTag("values");
            int j = 0;
            while (j < this.dsNames.length) {
                writer.writeTag("v", this.values[j][i]);
                ++j;
            }
            writer.closeTag();
            writer.closeTag();
            ++i;
        }
        writer.closeTag();
        writer.closeTag();
        writer.flush();
    }

    public void exportXml(String filepath) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filepath);
            this.exportXml(outputStream);
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public String exportXml() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.exportXml(outputStream);
        return outputStream.toString();
    }

    public long getArcStep() {
        return this.arcStep;
    }

    public long getArcEndTime() {
        return this.arcEndTime;
    }

    private DataProcessor createDataProcessor(String rpnExpression) {
        DataProcessor dataProcessor = new DataProcessor(this.request.getFetchStart(), this.request.getFetchEnd());
        String[] stringArray = this.dsNames;
        int n = this.dsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String dsName = stringArray[n2];
            dataProcessor.addDatasource(dsName, this);
            ++n2;
        }
        if (rpnExpression != null) {
            dataProcessor.addDatasource(RPN_SOURCE_NAME, rpnExpression);
            try {
                dataProcessor.processData();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Impossible error: " + ioe);
            }
        }
        return dataProcessor;
    }
}

