/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.Header;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackend;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdToolReader;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlReader;
import org.rrd4j.core.XmlWriter;

public class RrdDb
implements RrdUpdater {
    public static final String PREFIX_XML = "xml:/";
    public static final String PREFIX_RRDTool = "rrdtool:/";
    static final int XML_INITIAL_BUFFER_CAPACITY = 100000;
    private RrdBackend backend;
    private RrdAllocator allocator = new RrdAllocator();
    private final Header header;
    private final Datasource[] datasources;
    private final Archive[] archives;
    private boolean closed = false;

    public RrdDb(RrdDef rrdDef) throws IOException {
        this(rrdDef, RrdFileBackendFactory.getDefaultFactory());
    }

    public RrdDb(RrdDef rrdDef, RrdBackendFactory factory) throws IOException {
        if (!rrdDef.hasDatasources()) {
            throw new IllegalArgumentException("No RRD datasource specified. At least one is needed.");
        }
        if (!rrdDef.hasArchives()) {
            throw new IllegalArgumentException("No RRD archive specified. At least one is needed.");
        }
        String path = rrdDef.getPath();
        this.backend = factory.open(path, false);
        try {
            this.backend.setLength(rrdDef.getEstimatedSize());
            this.header = new Header(this, rrdDef);
            DsDef[] dsDefs = rrdDef.getDsDefs();
            this.datasources = new Datasource[dsDefs.length];
            int i = 0;
            while (i < dsDefs.length) {
                this.datasources[i] = new Datasource(this, dsDefs[i]);
                ++i;
            }
            ArcDef[] arcDefs = rrdDef.getArcDefs();
            this.archives = new Archive[arcDefs.length];
            int i2 = 0;
            while (i2 < arcDefs.length) {
                this.archives[i2] = new Archive(this, arcDefs[i2]);
                ++i2;
            }
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(String path, boolean readOnly) throws IOException {
        this(path, readOnly, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String path, boolean readOnly, RrdBackendFactory factory) throws IOException {
        if (!factory.exists(path)) {
            throw new FileNotFoundException("Could not open " + path + " [non existent]");
        }
        this.backend = factory.open(path, readOnly);
        try {
            this.header = new Header(this, null);
            if (factory.shouldValidateHeader(path)) {
                this.header.validateHeader();
            }
            int dsCount = this.header.getDsCount();
            this.datasources = new Datasource[dsCount];
            int i = 0;
            while (i < dsCount) {
                this.datasources[i] = new Datasource(this, null);
                ++i;
            }
            int arcCount = this.header.getArcCount();
            this.archives = new Archive[arcCount];
            int i2 = 0;
            while (i2 < arcCount) {
                this.archives[i2] = new Archive(this, null);
                ++i2;
            }
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(String path) throws IOException {
        this(path, false);
    }

    public RrdDb(String path, RrdBackendFactory factory) throws IOException {
        this(path, false, factory);
    }

    public RrdDb(String rrdPath, String externalPath) throws IOException {
        this(rrdPath, externalPath, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String rrdPath, String externalPath, RrdBackendFactory factory) throws IOException {
        DataImporter reader;
        if (externalPath.startsWith(PREFIX_RRDTool)) {
            String rrdToolPath = externalPath.substring(PREFIX_RRDTool.length());
            reader = new RrdToolReader(rrdToolPath);
        } else if (externalPath.startsWith(PREFIX_XML)) {
            externalPath = externalPath.substring(PREFIX_XML.length());
            reader = new XmlReader(externalPath);
        } else {
            reader = new XmlReader(externalPath);
        }
        this.backend = factory.open(rrdPath, false);
        try {
            this.backend.setLength(reader.getEstimatedSize());
            this.header = new Header(this, reader);
            this.datasources = new Datasource[reader.getDsCount()];
            int i = 0;
            while (i < this.datasources.length) {
                this.datasources[i] = new Datasource(this, reader, i);
                ++i;
            }
            this.archives = new Archive[reader.getArcCount()];
            i = 0;
            while (i < this.archives.length) {
                this.archives[i] = new Archive(this, reader, i);
                ++i;
            }
            reader.release();
            reader = null;
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.backend.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Header getHeader() {
        return this.header;
    }

    public Datasource getDatasource(int dsIndex) {
        return this.datasources[dsIndex];
    }

    public Archive getArchive(int arcIndex) {
        return this.archives[arcIndex];
    }

    public String[] getDsNames() throws IOException {
        int n = this.datasources.length;
        String[] dsNames = new String[n];
        int i = 0;
        while (i < n) {
            dsNames[i] = this.datasources[i].getDsName();
            ++i;
        }
        return dsNames;
    }

    public Sample createSample(long time) throws IOException {
        return new Sample(this, time);
    }

    public Sample createSample() throws IOException {
        return this.createSample(Util.getTime());
    }

    public FetchRequest createFetchRequest(ConsolFun consolFun, long fetchStart, long fetchEnd, long resolution) {
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution);
    }

    public FetchRequest createFetchRequest(ConsolFun consolFun, long fetchStart, long fetchEnd) {
        return this.createFetchRequest(consolFun, fetchStart, fetchEnd, 1L);
    }

    final synchronized void store(Sample sample) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("RRD already closed, cannot store this sample");
        }
        long newTime = sample.getTime();
        long lastTime = this.header.getLastUpdateTime();
        if (lastTime >= newTime) {
            throw new IllegalArgumentException("Bad sample time: " + newTime + ". Last update time was " + lastTime + ", at least one second step is required");
        }
        double[] newValues = sample.getValues();
        int i = 0;
        while (i < this.datasources.length) {
            double newValue = newValues[i];
            this.datasources[i].process(newTime, newValue);
            ++i;
        }
        this.header.setLastUpdateTime(newTime);
    }

    synchronized FetchData fetchData(FetchRequest request) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("RRD already closed, cannot fetch data");
        }
        Archive archive = this.findMatchingArchive(request);
        return archive.fetchData(request);
    }

    public Archive findMatchingArchive(FetchRequest request) throws IOException {
        ConsolFun consolFun = request.getConsolFun();
        long fetchStart = request.getFetchStart();
        long fetchEnd = request.getFetchEnd();
        long resolution = request.getResolution();
        Archive bestFullMatch = null;
        Archive bestPartialMatch = null;
        long bestStepDiff = 0L;
        long bestMatch = 0L;
        Archive[] archiveArray = this.archives;
        int n = this.archives.length;
        int n2 = 0;
        while (n2 < n) {
            Archive archive = archiveArray[n2];
            if (archive.getConsolFun() == consolFun) {
                long arcStep = archive.getArcStep();
                long arcStart = archive.getStartTime() - arcStep;
                long arcEnd = archive.getEndTime();
                long fullMatch = fetchEnd - fetchStart;
                if (arcEnd >= fetchEnd && arcStart <= fetchStart) {
                    long tmpStepDiff = Math.abs(archive.getArcStep() - resolution);
                    if (tmpStepDiff < bestStepDiff || bestFullMatch == null) {
                        bestStepDiff = tmpStepDiff;
                        bestFullMatch = archive;
                    }
                } else {
                    long tmpMatch = fullMatch;
                    if (arcStart > fetchStart) {
                        tmpMatch -= arcStart - fetchStart;
                    }
                    if (arcEnd < fetchEnd) {
                        tmpMatch -= fetchEnd - arcEnd;
                    }
                    if (bestPartialMatch == null || bestMatch < tmpMatch) {
                        bestPartialMatch = archive;
                        bestMatch = tmpMatch;
                    }
                }
            }
            ++n2;
        }
        if (bestFullMatch != null) {
            return bestFullMatch;
        }
        if (bestPartialMatch != null) {
            return bestPartialMatch;
        }
        throw new IllegalStateException("RRD file does not contain RRA: " + (Object)((Object)consolFun) + " archive");
    }

    public Archive findStartMatchArchive(String consolFun, long startTime, long resolution) throws IOException {
        int fallBackIndex = 0;
        int arcIndex = -1;
        long minDiff = Long.MAX_VALUE;
        long fallBackDiff = Long.MAX_VALUE;
        int i = 0;
        while (i < this.archives.length) {
            if (this.archives[i].getConsolFun().equals(consolFun)) {
                long arcStep = this.archives[i].getArcStep();
                long diff = Math.abs(resolution - arcStep);
                if (startTime >= this.archives[i].getStartTime()) {
                    if (diff == 0L) {
                        return this.archives[i];
                    }
                    if (diff < minDiff) {
                        minDiff = diff;
                        arcIndex = i;
                    }
                } else if (diff < fallBackDiff) {
                    fallBackDiff = diff;
                    fallBackIndex = i;
                }
            }
            ++i;
        }
        return arcIndex >= 0 ? this.archives[arcIndex] : this.archives[fallBackIndex];
    }

    public synchronized String dump() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.header.dump());
        RrdUpdater[] rrdUpdaterArray = this.datasources;
        int n = this.datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Datasource datasource = rrdUpdaterArray[n2];
            buffer.append(datasource.dump());
            ++n2;
        }
        rrdUpdaterArray = this.archives;
        n = this.archives.length;
        n2 = 0;
        while (n2 < n) {
            RrdUpdater archive = rrdUpdaterArray[n2];
            buffer.append(((Archive)archive).dump());
            ++n2;
        }
        return buffer.toString();
    }

    final void archive(Datasource datasource, double value, long numUpdates) throws IOException {
        int dsIndex = this.getDsIndex(datasource.getDsName());
        Archive[] archiveArray = this.archives;
        int n = this.archives.length;
        int n2 = 0;
        while (n2 < n) {
            Archive archive = archiveArray[n2];
            archive.archive(dsIndex, value, numUpdates);
            ++n2;
        }
    }

    public int getDsIndex(String dsName) throws IOException {
        int i = 0;
        while (i < this.datasources.length) {
            if (this.datasources[i].getDsName().equals(dsName)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown datasource name: " + dsName);
    }

    public boolean containsDs(String dsName) throws IOException {
        Datasource[] datasourceArray = this.datasources;
        int n = this.datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Datasource datasource = datasourceArray[n2];
            if (datasource.getDsName().equals(dsName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    Datasource[] getDatasources() {
        return this.datasources;
    }

    Archive[] getArchives() {
        return this.archives;
    }

    public synchronized void dumpXml(OutputStream destination) throws IOException {
        XmlWriter writer = new XmlWriter(destination);
        writer.startTag("rrd");
        this.header.appendXml(writer);
        RrdUpdater[] rrdUpdaterArray = this.datasources;
        int n = this.datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Datasource datasource = rrdUpdaterArray[n2];
            datasource.appendXml(writer);
            ++n2;
        }
        rrdUpdaterArray = this.archives;
        n = this.archives.length;
        n2 = 0;
        while (n2 < n) {
            RrdUpdater archive = rrdUpdaterArray[n2];
            ((Archive)archive).appendXml(writer);
            ++n2;
        }
        writer.closeTag();
        writer.flush();
    }

    public synchronized void exportXml(OutputStream destination) throws IOException {
        this.dumpXml(destination);
    }

    public synchronized String getXml() throws IOException {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(100000);
        this.dumpXml(destination);
        return destination.toString();
    }

    public synchronized String exportXml() throws IOException {
        return this.getXml();
    }

    public synchronized void dumpXml(String filename) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filename, false);
            this.dumpXml(outputStream);
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public synchronized void exportXml(String filename) throws IOException {
        this.dumpXml(filename);
    }

    public synchronized long getLastUpdateTime() throws IOException {
        return this.header.getLastUpdateTime();
    }

    public synchronized RrdDef getRrdDef() throws IOException {
        long startTime = this.header.getLastUpdateTime();
        long step = this.header.getStep();
        String path = this.backend.getPath();
        RrdDef rrdDef = new RrdDef(path, startTime, step);
        RrdUpdater[] rrdUpdaterArray = this.datasources;
        int n = this.datasources.length;
        int n2 = 0;
        while (n2 < n) {
            Datasource datasource = rrdUpdaterArray[n2];
            DsDef dsDef = new DsDef(datasource.getDsName(), datasource.getDsType(), datasource.getHeartbeat(), datasource.getMinValue(), datasource.getMaxValue());
            rrdDef.addDatasource(dsDef);
            ++n2;
        }
        rrdUpdaterArray = this.archives;
        n = this.archives.length;
        n2 = 0;
        while (n2 < n) {
            RrdUpdater archive = rrdUpdaterArray[n2];
            ArcDef arcDef = new ArcDef(((Archive)archive).getConsolFun(), ((Archive)archive).getXff(), ((Archive)archive).getSteps(), ((Archive)archive).getRows());
            rrdDef.addArchive(arcDef);
            ++n2;
        }
        return rrdDef;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void copyStateTo(RrdUpdater other) throws IOException {
        int j;
        if (!(other instanceof RrdDb)) {
            throw new IllegalArgumentException("Cannot copy RrdDb object to " + other.getClass().getName());
        }
        RrdDb otherRrd = (RrdDb)other;
        this.header.copyStateTo(otherRrd.header);
        int i = 0;
        while (i < this.datasources.length) {
            j = Util.getMatchingDatasourceIndex(this, i, otherRrd);
            if (j >= 0) {
                this.datasources[i].copyStateTo(otherRrd.datasources[j]);
            }
            ++i;
        }
        i = 0;
        while (i < this.archives.length) {
            j = Util.getMatchingArchiveIndex(this, i, otherRrd);
            if (j >= 0) {
                this.archives[i].copyStateTo(otherRrd.archives[j]);
            }
            ++i;
        }
    }

    public Datasource getDatasource(String dsName) throws IOException {
        try {
            return this.getDatasource(this.getDsIndex(dsName));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getArcIndex(ConsolFun consolFun, int steps) throws IOException {
        int i = 0;
        while (i < this.archives.length) {
            if (this.archives[i].getConsolFun() == consolFun && this.archives[i].getSteps() == steps) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Could not find archive " + (Object)((Object)consolFun) + "/" + steps);
    }

    public Archive getArchive(ConsolFun consolFun, int steps) throws IOException {
        try {
            return this.getArchive(this.getArcIndex(consolFun, steps));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCanonicalPath() throws IOException {
        if (this.backend instanceof RrdFileBackend) {
            return ((RrdFileBackend)this.backend).getCanonicalPath();
        }
        throw new IOException("The underlying backend has no canonical path");
    }

    public String getPath() {
        return this.backend.getPath();
    }

    public RrdBackend getRrdBackend() {
        return this.backend;
    }

    public RrdAllocator getRrdAllocator() {
        return this.allocator;
    }

    public synchronized byte[] getBytes() throws IOException {
        return this.backend.readAll();
    }

    public static void setDefaultFactory(String factoryName) {
        RrdBackendFactory.setDefaultFactory(factoryName);
    }

    public synchronized double[] getLastDatasourceValues() throws IOException {
        double[] values = new double[this.datasources.length];
        int i = 0;
        while (i < values.length) {
            values[i] = this.datasources[i].getLastValue();
            ++i;
        }
        return values;
    }

    public synchronized double getLastDatasourceValue(String dsName) throws IOException {
        int dsIndex = this.getDsIndex(dsName);
        return this.datasources[dsIndex].getLastValue();
    }

    public int getDsCount() {
        return this.datasources.length;
    }

    public int getArcCount() {
        return this.archives.length;
    }

    public long getLastArchiveUpdateTime() throws IOException {
        long last = 0L;
        Archive[] archiveArray = this.archives;
        int n = this.archives.length;
        int n2 = 0;
        while (n2 < n) {
            Archive archive = archiveArray[n2];
            last = Math.max(last, archive.getEndTime());
            ++n2;
        }
        return last;
    }

    public synchronized String getInfo() throws IOException {
        return this.header.getInfo();
    }

    public synchronized void setInfo(String info) throws IOException {
        this.header.setInfo(info);
    }

    public static void main(String[] args) {
        System.out.println("RRD4J :: RRDTool choice for the Java world");
        System.out.println("==================================================================");
        System.out.println("RRD4J base directory: " + Util.getRrd4jHomeDirectory());
        long time = Util.getTime();
        System.out.println("Current time: " + time + ": " + new Date(time * 1000L));
        System.out.println("------------------------------------------------------------------");
        System.out.println("For the latest information visit: https://rrd4j.dev.java.net");
        System.out.println("(C) 2003-2007 Sasa Markovic and Mathias Bogaert. All rights reserved.");
    }
}

