/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RrdToolkit {
    public static void addDatasource(String sourcePath, String destPath, DsDef newDatasource) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        try {
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.addDatasource(newDatasource);
            RrdDb rrdDest = new RrdDb(rrdDef);
            try {
                rrdSource.copyStateTo(rrdDest);
            }
            finally {
                rrdDest.close();
            }
        }
        finally {
            rrdSource.close();
        }
    }

    public static void addDatasource(String sourcePath, DsDef newDatasource, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.addDatasource(sourcePath, destPath, newDatasource);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    public static void removeDatasource(String sourcePath, String destPath, String dsName) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        try {
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.removeDatasource(dsName);
            RrdDb rrdDest = new RrdDb(rrdDef);
            try {
                rrdSource.copyStateTo(rrdDest);
            }
            finally {
                rrdDest.close();
            }
        }
        finally {
            rrdSource.close();
        }
    }

    public static void removeDatasource(String sourcePath, String dsName, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.removeDatasource(sourcePath, destPath, dsName);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    public static void renameDatasource(String sourcePath, String oldDsName, String newDsName) throws IOException {
        block4: {
            RrdDb rrd = new RrdDb(sourcePath);
            try {
                if (rrd.containsDs(oldDsName)) {
                    Datasource datasource = rrd.getDatasource(oldDsName);
                    datasource.setDsName(newDsName);
                    break block4;
                }
                throw new IllegalArgumentException("Could not find datasource [" + oldDsName + "] in file " + sourcePath);
            }
            finally {
                rrd.close();
            }
        }
    }

    public static int forceZerosForNans(String sourcePath, String dsName) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Datasource[] datasources;
            if (dsName == null) {
                datasources = rrd.getDatasources();
            } else if (rrd.containsDs(dsName)) {
                datasources = new Datasource[]{rrd.getDatasource(dsName)};
            } else {
                throw new IllegalArgumentException("Could not find datasource [" + dsName + "] in file " + sourcePath);
            }
            int count = 0;
            Datasource[] datasourceArray = datasources;
            int n = datasources.length;
            int n2 = 0;
            while (n2 < n) {
                Datasource datasource = datasourceArray[n2];
                String currentDsName = datasource.getDsName();
                if (!currentDsName.endsWith("!")) {
                    datasource.setDsName(String.valueOf(currentDsName) + "!");
                    ++count;
                }
                ++n2;
            }
            int n3 = count;
            return n3;
        }
        finally {
            rrd.close();
        }
    }

    public static void addArchive(String sourcePath, String destPath, ArcDef newArchive) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        try {
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.addArchive(newArchive);
            RrdDb rrdDest = new RrdDb(rrdDef);
            try {
                rrdSource.copyStateTo(rrdDest);
            }
            finally {
                rrdDest.close();
            }
        }
        finally {
            rrdSource.close();
        }
    }

    public static void addArchive(String sourcePath, ArcDef newArchive, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.addArchive(sourcePath, destPath, newArchive);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    public static void removeArchive(String sourcePath, String destPath, ConsolFun consolFun, int steps) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException("Source and destination paths are the same");
        }
        RrdDb rrdSource = new RrdDb(sourcePath);
        try {
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.removeArchive(consolFun, steps);
            RrdDb rrdDest = new RrdDb(rrdDef);
            try {
                rrdSource.copyStateTo(rrdDest);
            }
            finally {
                rrdDest.close();
            }
        }
        finally {
            rrdSource.close();
        }
    }

    public static void removeArchive(String sourcePath, ConsolFun consolFun, int steps, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.removeArchive(sourcePath, destPath, consolFun, steps);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void copyFile(String sourcePath, String destPath, boolean saveBackup) throws IOException {
        File source = new File(sourcePath);
        File dest = new File(destPath);
        if (saveBackup) {
            String backupPath = RrdToolkit.getBackupPath(destPath);
            File backup = new File(backupPath);
            RrdToolkit.deleteFile(backup);
            if (!dest.renameTo(backup)) {
                throw new IOException("Could not create backup file " + backupPath);
            }
        }
        RrdToolkit.deleteFile(dest);
        if (!source.renameTo(dest)) {
            throw new IOException("Could not create file " + destPath + " from " + sourcePath);
        }
    }

    private static String getBackupPath(String destPath) {
        String backupPath = destPath;
        while (Util.fileExists(backupPath = String.valueOf(backupPath) + ".bak")) {
        }
        return backupPath;
    }

    public static void setDsHeartbeat(String sourcePath, String datasourceName, long newHeartbeat) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setHeartbeat(newHeartbeat);
        }
        finally {
            rrd.close();
        }
    }

    public static void setDsHeartbeat(String sourcePath, int dsIndex, long newHeartbeat) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Datasource ds = rrd.getDatasource(dsIndex);
            ds.setHeartbeat(newHeartbeat);
        }
        finally {
            rrd.close();
        }
    }

    public static void setDsMinValue(String sourcePath, String datasourceName, double newMinValue, boolean filterArchivedValues) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMinValue(newMinValue, filterArchivedValues);
        }
        finally {
            rrd.close();
        }
    }

    public static void setDsMaxValue(String sourcePath, String datasourceName, double newMaxValue, boolean filterArchivedValues) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMaxValue(newMaxValue, filterArchivedValues);
        }
        finally {
            rrd.close();
        }
    }

    public static void setDsMinMaxValue(String sourcePath, String datasourceName, double newMinValue, double newMaxValue, boolean filterArchivedValues) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMinMaxValue(newMinValue, newMaxValue, filterArchivedValues);
        }
        finally {
            rrd.close();
        }
    }

    public static void setArcXff(String sourcePath, ConsolFun consolFun, int steps, double newXff) throws IOException {
        RrdDb rrd = new RrdDb(sourcePath);
        try {
            Archive arc = rrd.getArchive(consolFun, steps);
            arc.setXff(newXff);
        }
        finally {
            rrd.close();
        }
    }

    public static void resizeArchive(String sourcePath, String destPath, ConsolFun consolFun, int numSteps, int newRows) throws IOException {
        block8: {
            if (Util.sameFilePath(sourcePath, destPath)) {
                throw new IllegalArgumentException("Source and destination paths are the same");
            }
            if (newRows < 2) {
                throw new IllegalArgumentException("New archive size must be at least 2");
            }
            RrdDb rrdSource = new RrdDb(sourcePath);
            try {
                RrdDef rrdDef = rrdSource.getRrdDef();
                ArcDef arcDef = rrdDef.findArchive(consolFun, numSteps);
                if (arcDef.getRows() == newRows) break block8;
                arcDef.setRows(newRows);
                rrdDef.setPath(destPath);
                RrdDb rrdDest = new RrdDb(rrdDef);
                try {
                    rrdSource.copyStateTo(rrdDest);
                }
                finally {
                    rrdDest.close();
                }
            }
            finally {
                rrdSource.close();
            }
        }
    }

    public static void resizeArchive(String sourcePath, ConsolFun consolFun, int numSteps, int newRows, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.resizeArchive(sourcePath, destPath, consolFun, numSteps, newRows);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }

    public static void split(String sourcePath) throws IOException {
        RrdDb rrdSource = new RrdDb(sourcePath);
        try {
            String[] dsNames;
            String[] stringArray = dsNames = rrdSource.getDsNames();
            int n = dsNames.length;
            int n2 = 0;
            while (n2 < n) {
                String dsName = stringArray[n2];
                RrdDef rrdDef = rrdSource.getRrdDef();
                rrdDef.setPath(RrdToolkit.createSplitPath(dsName, sourcePath));
                rrdDef.saveSingleDatasource(dsName);
                RrdDb rrdDest = new RrdDb(rrdDef);
                try {
                    rrdSource.copyStateTo(rrdDest);
                }
                finally {
                    rrdDest.close();
                }
                ++n2;
            }
        }
        finally {
            rrdSource.close();
        }
    }

    public static String[] getCanonicalPaths(String directory, String extension, boolean resursive) throws IOException {
        File baseDir = new File(directory);
        if (!baseDir.isDirectory()) {
            throw new IOException("Not a directory: " + directory);
        }
        LinkedList<String> fileList = new LinkedList<String>();
        RrdToolkit.traverseDirectory(new File(directory), extension, resursive, fileList);
        Object[] result = fileList.toArray(new String[fileList.size()]);
        Arrays.sort(result);
        return result;
    }

    private static void traverseDirectory(File directory, String extension, boolean recursive, List<String> list) throws IOException {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && recursive) {
                RrdToolkit.traverseDirectory(file, extension, recursive, list);
            } else if (file.isFile() && file.getName().endsWith(extension)) {
                list.add(file.getCanonicalPath());
            }
            ++n2;
        }
    }

    private static String createSplitPath(String dsName, String sourcePath) {
        File file = new File(sourcePath);
        String newName = String.valueOf(dsName) + "-" + file.getName();
        String path = file.getAbsolutePath();
        String parentDir = path.substring(0, 1 + path.lastIndexOf(Util.getFileSeparator()));
        return String.valueOf(parentDir) + newName;
    }
}

