/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.rrd4j.core.Header;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.Util;

class HeaderTableModel
extends AbstractTableModel {
    private static final Object[] DESCRIPTIONS = new Object[]{"path", "signature", "step", "last timestamp", "datasources", "archives", "size"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private File file;
    private Object[] values;

    HeaderTableModel() {
    }

    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return DESCRIPTIONS[rowIndex];
        }
        if (columnIndex == 1) {
            if (this.values != null) {
                return this.values[rowIndex];
            }
            return "--";
        }
        return null;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    void setFile(File newFile) {
        try {
            this.file = newFile;
            this.values = null;
            String path = this.file.getAbsolutePath();
            RrdDb rrd = new RrdDb(path, true);
            try {
                Header header = rrd.getHeader();
                String signature = header.getSignature();
                String step = "" + header.getStep();
                String lastTimestamp = String.valueOf(header.getLastUpdateTime()) + " [" + new Date(header.getLastUpdateTime() * 1000L) + "]";
                String datasources = "" + header.getDsCount();
                String archives = "" + header.getArcCount();
                String size = String.valueOf(rrd.getRrdBackend().getLength()) + " bytes";
                this.values = new Object[]{path, signature, step, lastTimestamp, datasources, archives, size};
            }
            finally {
                rrd.close();
            }
            this.fireTableDataChanged();
        }
        catch (Exception e) {
            Util.error(null, e);
        }
    }
}

