/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FDSNEventQuerier
extends AbstractFDSNQuerier {
    FDSNEventQueryParams queryParams;
    private static Logger logger = LoggerFactory.getLogger(FDSNEventQuerier.class);

    public FDSNEventQuerier(FDSNEventQueryParams queryParams) {
        this.queryParams = queryParams;
    }

    public Quakeml getQuakeML() throws FDSNWSException {
        URI uri = null;
        try {
            uri = this.queryParams.formURI();
            this.connect(uri);
            if (!this.isError()) {
                if (!this.isEmpty()) {
                    try {
                        Quakeml quakeml = new Quakeml(this.getReader());
                        if (!quakeml.checkSchemaVersion()) {
                            logger.warn("XmlSchema of this document does not match this code, results may be incorrect. XmlSchema (code): http://quakeml.org/xmlns/quakeml/1.2XmlSchema (doc): " + quakeml.getSchemaVersion());
                        }
                        return quakeml;
                    }
                    catch (XMLStreamException e) {
                        throw new SeisFileException("Unable to load xml", e);
                    }
                }
                return Quakeml.createEmptyQuakeML();
            }
            throw new FDSNWSException("Error: " + this.getErrorMessage());
        }
        catch (URISyntaxException e) {
            throw new FDSNWSException("Error with URL syntax", e);
        }
        catch (SeisFileException e) {
            if (e instanceof FDSNWSException) {
                ((FDSNWSException)e).setTargetURI(uri);
                throw (FDSNWSException)e;
            }
            throw new FDSNWSException(e.getMessage(), e, uri);
        }
    }

    public void validateQuakeML() throws SeisFileException, URISyntaxException {
        URI uri = this.queryParams.formURI();
        try {
            this.connect(uri);
            if (!this.isError() && !this.isEmpty()) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLStreamReader reader = factory.createXMLStreamReader(this.getConnectionUri().toString(), this.getInputStream());
                FDSNEventQuerier.validateQuakeML(reader);
            }
        }
        catch (SAXException e) {
            throw new FDSNWSException("Unable to validate xml", e, uri);
        }
        catch (XMLStreamException e) {
            throw new FDSNWSException("Unable to read xml", e, uri);
        }
        catch (IOException e) {
            throw new FDSNWSException("IOException trying to validate", e, uri);
        }
    }

    public static void validateQuakeML(XMLStreamReader reader) throws SAXException, IOException {
        FDSNEventQuerier.validate(reader, Quakeml.loadSchema());
    }

    public void outputRaw(OutputStream out) throws MalformedURLException, IOException, URISyntaxException, FDSNWSException {
        this.connect(this.queryParams.formURI());
        this.outputRaw(this.getInputStream(), out);
    }
}

