/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxElementProcessor;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StaxUtil {
    static String parent = "";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String SHORT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public static StartElement expectStartElement(String expected, XMLEventReader reader) throws XMLStreamException, StationXMLException {
        XMLEvent cur = reader.peek();
        if (cur.isStartElement() && cur.asStartElement().getName().getLocalPart().equals(expected)) {
            parent = expected;
            return reader.nextEvent().asStartElement();
        }
        Location loc = cur.getLocation();
        throw new StationXMLException("Expected a start <" + expected + "> element at line " + loc.getLineNumber() + ", " + loc.getColumnNumber() + ": " + (cur.isStartElement() ? cur.asStartElement().getName().getLocalPart() : Integer.valueOf(cur.getEventType())));
    }

    public static String pullContiguousText(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        String outText = "";
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            if (e.isCharacters()) {
                outText = outText + e.asCharacters().getData();
                continue;
            }
            if (!e.isEndElement()) continue;
            return outText;
        }
        throw new StationXMLException("Ran out of XMLEvents before end of text element");
    }

    public static String pullText(XMLEventReader reader, String elementName) throws XMLStreamException, StationXMLException {
        String outText = "";
        StartElement startElement = StaxUtil.expectStartElement(elementName, reader);
        if (startElement.isStartElement() && startElement.asStartElement().getName().getLocalPart().equals(elementName)) {
            return StaxUtil.pullContiguousText(reader);
        }
        throw new StationXMLException("Expected START_ELEMENT of type " + elementName);
    }

    public static int pullInt(XMLEventReader reader, String elementName) throws NumberFormatException, XMLStreamException, StationXMLException {
        return Integer.parseInt(StaxUtil.pullText(reader, elementName));
    }

    public static float pullFloat(XMLEventReader reader, String elementName) throws NumberFormatException, XMLStreamException, StationXMLException {
        return Float.parseFloat(StaxUtil.pullText(reader, elementName));
    }

    public static void skipToStartElement(XMLEventReader reader) throws XMLStreamException {
        if (!reader.hasNext()) {
            return;
        }
        while (reader.hasNext() && !reader.peek().isStartElement()) {
            reader.nextEvent();
        }
    }

    public static void skipToMatchingEnd(XMLEventReader reader) throws XMLStreamException {
        int count = 0;
        XMLEvent cur = reader.peek();
        if (cur.isStartElement() && reader.hasNext()) {
            ++count;
            reader.nextEvent();
            Exception justForStackTrace = new Exception();
            System.out.println("Warning: Skipping: '" + cur.asStartElement().getName().getLocalPart() + "' at line " + cur.getLocation().getLineNumber() + ", " + cur.getLocation().getColumnNumber() + " in or after '" + parent + "' in class " + justForStackTrace.getStackTrace()[1]);
        }
        while (count > 0 && reader.hasNext()) {
            cur = reader.peek();
            if (cur.isStartElement()) {
                ++count;
            } else if (cur.isEndElement()) {
                --count;
            }
            reader.nextEvent();
        }
    }

    public static void skipToStartOrEndElement(XMLEventReader reader) throws XMLStreamException {
        if (!reader.hasNext()) {
            return;
        }
        while (reader.hasNext() && !reader.peek().isStartElement() && !reader.peek().isEndElement()) {
            reader.nextEvent();
        }
    }

    public static boolean hasNext(XMLEventReader reader, String elementName, String endElementName) throws XMLStreamException {
        try {
            return StaxUtil.hasNext(reader, elementName, endElementName, new StaxElementProcessor(){

                @Override
                public void processNextStartElement(XMLEventReader reader) throws XMLStreamException {
                    reader.next();
                    StaxUtil.skipToMatchingEnd(reader);
                }
            });
        }
        catch (SeisFileException e) {
            throw new RuntimeException("Should not happen, but I guess it did! :(", e);
        }
    }

    public static boolean hasNext(XMLEventReader reader, String elementName, String endElementName, StaxElementProcessor unknownProcessor) throws XMLStreamException, SeisFileException {
        while (reader.hasNext()) {
            if (reader.peek().isStartElement()) {
                if (reader.peek().asStartElement().getName().getLocalPart().equals(elementName)) {
                    return true;
                }
                unknownProcessor.processNextStartElement(reader);
                continue;
            }
            if (reader.peek().isEndElement() && reader.peek().asEndElement().getName().getLocalPart().equals(endElementName)) {
                return false;
            }
            reader.next();
        }
        return false;
    }

    public static boolean hasAttribute(StartElement start, String name) {
        Iterator<Attribute> it = start.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (!a.getName().getLocalPart().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String pullAttributeIfExists(StartElement start, String name) throws StationXMLException {
        Iterator<Attribute> it = start.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (!a.getName().getLocalPart().equals(name)) continue;
            return a.getValue();
        }
        return null;
    }

    public static String pullAttribute(StartElement start, String name) throws StationXMLException {
        String val = StaxUtil.pullAttributeIfExists(start, name);
        if (val != null) {
            return val;
        }
        throw new StationXMLException(name + " not found as an attribute in " + start.getName().getLocalPart() + " at " + start.getLocation().getLineNumber() + ", " + start.getLocation().getColumnNumber());
    }

    public static Integer pullIntAttribute(StartElement start, String name) throws StationXMLException {
        return Integer.parseInt(StaxUtil.pullAttribute(start, name));
    }

    public static Float pullFloatAttribute(StartElement start, String name) throws StationXMLException {
        return Float.valueOf(Float.parseFloat(StaxUtil.pullAttribute(start, name)));
    }

    public static Date pullDate(XMLEventReader reader, String name) throws StationXMLException, XMLStreamException {
        return StaxUtil.parseDate(StaxUtil.pullText(reader, name));
    }

    public static Date pullDateAttributeIfExists(StartElement start, String name) throws StationXMLException {
        return StaxUtil.parseDate(StaxUtil.pullAttributeIfExists(start, name));
    }

    public static Date parseDate(String text) throws StationXMLException {
        SimpleDateFormat sdf = new SimpleDateFormat(SHORT_DATE_FORMAT);
        try {
            return sdf.parse(text);
        }
        catch (ParseException e) {
            sdf = new SimpleDateFormat(DATE_FORMAT);
            try {
                return sdf.parse(text);
            }
            catch (ParseException e1) {
                throw new StationXMLException(e);
            }
        }
    }
}

