/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.StationMagnitudeContribution;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Magnitude {
    public static final String ELEMENT_NAME = "magnitude";
    String publicId;
    String originId;
    String type;
    Integer stationCount;
    Float azimuthalGap;
    RealQuantity mag;
    List<StationMagnitudeContribution> stationMagnitudeContributionList = new ArrayList<StationMagnitudeContribution>();
    String evaluationMode;
    String evaluationStatus;
    String methodID;
    CreationInfo creationInfo;

    public Magnitude(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("originID")) {
                    this.originId = StaxUtil.pullText(reader, "originID");
                    continue;
                }
                if (elName.equals("stationCount")) {
                    this.stationCount = StaxUtil.pullInt(reader, "stationCount");
                    continue;
                }
                if (elName.equals("azimuthalGap")) {
                    this.azimuthalGap = Float.valueOf(StaxUtil.pullFloat(reader, "azimuthalGap"));
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("mag")) {
                    this.mag = new RealQuantity(reader, "mag");
                    continue;
                }
                if (elName.equals("stationMagnitudeContribution")) {
                    this.stationMagnitudeContributionList.add(new StationMagnitudeContribution(reader));
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getOriginId() {
        return this.originId;
    }

    public String getType() {
        return this.type;
    }

    public RealQuantity getMag() {
        return this.mag;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public Integer getStationCount() {
        return this.stationCount;
    }

    public Float getAzimuthalGap() {
        return this.azimuthalGap;
    }

    public List<StationMagnitudeContribution> getStationMagnitudeContributionList() {
        return this.stationMagnitudeContributionList;
    }
}

