/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Tensor {
    public static final String ELEMENT_NAME = "tensor";
    RealQuantity Mrr;
    RealQuantity Mtt;
    RealQuantity Mpp;
    RealQuantity Mrt;
    RealQuantity Mrp;
    RealQuantity Mtp;

    public Tensor(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Mrr")) {
                    this.Mrr = new RealQuantity(reader, "Mrr");
                    continue;
                }
                if (elName.equals("Mtt")) {
                    this.Mtt = new RealQuantity(reader, "Mtt");
                    continue;
                }
                if (elName.equals("Mpp")) {
                    this.Mpp = new RealQuantity(reader, "Mpp");
                    continue;
                }
                if (elName.equals("Mrt")) {
                    this.Mrt = new RealQuantity(reader, "Mrt");
                    continue;
                }
                if (elName.equals("Mrp")) {
                    this.Mrp = new RealQuantity(reader, "Mrp");
                    continue;
                }
                if (elName.equals("Mtp")) {
                    this.Mtp = new RealQuantity(reader, "Mtp");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public RealQuantity getMrr() {
        return this.Mrr;
    }

    public RealQuantity getMtt() {
        return this.Mtt;
    }

    public RealQuantity getMpp() {
        return this.Mpp;
    }

    public RealQuantity getMrt() {
        return this.Mrt;
    }

    public RealQuantity getMrp() {
        return this.Mrp;
    }

    public RealQuantity getMtp() {
        return this.Mtp;
    }
}

