/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataLogger;
import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.PreAmplifier;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.SampleRateRatio;
import edu.sc.seis.seisFile.fdsnws.stationxml.Sensor;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Channel
extends BaseNodeType {
    private SampleRateRatio sampleRateRatio;
    private FloatType sampleRate;
    private FloatType clockDrift;
    private String clockDriftUnit = "SECONDS/SAMPLE";
    private Unit calibrationUnits;
    private Sensor sensor;
    private PreAmplifier preAmplifier;
    private DataLogger dataLogger;
    private Equipment equipment;
    private Response response;
    private String locCode;
    private String stationCode;
    private String networkCode;
    private FloatType latitude;
    private FloatType longitude;
    private FloatType elevation;
    private FloatType depth;
    private FloatType azimuth;
    private FloatType dip;
    List<String> typeList = new ArrayList<String>();
    String storageFormat;

    public Channel(XMLEventReader reader, String networkCode, String stationCode) throws XMLStreamException, StationXMLException {
        this.networkCode = networkCode;
        this.stationCode = stationCode;
        StartElement startE = StaxUtil.expectStartElement("Channel", reader);
        super.parseAttributes(startE);
        this.locCode = StaxUtil.pullAttribute(startE, "locationCode");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("Latitude")) {
                    this.latitude = new FloatType(reader, "Latitude", "DEGREES");
                    continue;
                }
                if (elName.equals("Longitude")) {
                    this.longitude = new FloatType(reader, "Longitude", "DEGREES");
                    continue;
                }
                if (elName.equals("Elevation")) {
                    this.elevation = new FloatType(reader, "Elevation", "METER");
                    continue;
                }
                if (elName.equals("Depth")) {
                    this.depth = new FloatType(reader, "Depth", "METER");
                    continue;
                }
                if (elName.equals("Azimuth")) {
                    this.azimuth = new FloatType(reader, "Azimuth", "DEGREES");
                    continue;
                }
                if (elName.equals("Dip")) {
                    this.dip = new FloatType(reader, "Dip", "DEGREES");
                    continue;
                }
                if (elName.equals("Type")) {
                    this.typeList.add(StaxUtil.pullText(reader, "Type"));
                    continue;
                }
                if (elName.equals("SampleRate")) {
                    this.sampleRate = new FloatType(reader, "SampleRate", "HERTZ");
                    continue;
                }
                if (elName.equals("SampleRateRatio")) {
                    this.sampleRateRatio = new SampleRateRatio(reader);
                    continue;
                }
                if (elName.equals("ClockDrift")) {
                    this.clockDrift = new FloatType(reader, "ClockDrift", this.clockDriftUnit);
                    continue;
                }
                if (elName.equals("CalibrationUnits")) {
                    this.calibrationUnits = new Unit(reader, "CalibrationUnits");
                    continue;
                }
                if (elName.equals("Sensor")) {
                    this.sensor = new Sensor(reader);
                    continue;
                }
                if (elName.equals("preAmplifier")) {
                    this.preAmplifier = new PreAmplifier(reader);
                    continue;
                }
                if (elName.equals("DataLogger")) {
                    this.dataLogger = new DataLogger(reader);
                    continue;
                }
                if (elName.equals("Equipment")) {
                    this.equipment = new Equipment(reader);
                    continue;
                }
                if (elName.equals("Response")) {
                    this.response = new Response(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public SampleRateRatio getSampleRateRatio() {
        return this.sampleRateRatio;
    }

    public FloatType getSampleRate() {
        return this.sampleRate;
    }

    public FloatType getClockDrift() {
        return this.clockDrift;
    }

    public String getClockDriftUnit() {
        return this.clockDriftUnit;
    }

    public Unit getCalibrationUnits() {
        return this.calibrationUnits;
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public PreAmplifier getPreAmplifier() {
        return this.preAmplifier;
    }

    public DataLogger getDataLogger() {
        return this.dataLogger;
    }

    public Equipment getEquipment() {
        return this.equipment;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getLocCode() {
        return this.locCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public FloatType getLatitude() {
        return this.latitude;
    }

    public FloatType getLon() {
        return this.longitude;
    }

    public FloatType getElevation() {
        return this.elevation;
    }

    public FloatType getDepth() {
        return this.depth;
    }

    public FloatType getAzimuth() {
        return this.azimuth;
    }

    public FloatType getDip() {
        return this.dip;
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    public String getStorageFormat() {
        return this.storageFormat;
    }

    public String toString() {
        return this.getNetworkCode() + "." + this.getStationCode() + "." + this.getLocCode() + "." + this.getCode();
    }
}

