/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNEventRecord;
import edu.sc.seis.seisFile.psn.PSNHeader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class PSNDataFile {
    private PSNEventRecord[] eventRecs;

    public PSNDataFile(String filename) throws FileNotFoundException, IOException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(filename))));
    }

    public PSNDataFile(DataInputStream dis) throws FileNotFoundException, IOException {
        this.readFile(dis);
        dis.close();
    }

    private void readFile(DataInputStream dis) throws IOException, FileNotFoundException {
        PSNHeader header = new PSNHeader(dis);
        if (!header.isVolumeFile()) {
            this.eventRecs = new PSNEventRecord[]{new PSNEventRecord(header, dis)};
        } else {
            this.eventRecs = new PSNEventRecord[header.getNumRecords()];
            for (int i = 0; i < header.getNumRecords(); ++i) {
                this.eventRecs[i] = new PSNEventRecord(dis);
            }
        }
    }

    public PSNEventRecord[] getEventRecords() {
        return this.eventRecs;
    }

    public static byte[] chopToLength(byte[] byteArray) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] == 0) continue;
            list.add(new Byte(byteArray[i]));
        }
        byte[] newArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newArray[i] = (Byte)list.get(i);
        }
        return newArray;
    }

    public static void main(String[] args) {
        try {
            PSNDataFile psnData = new PSNDataFile(args[0]);
            PSNEventRecord[] records = psnData.getEventRecords();
            System.out.println("Number of Records: " + records.length);
            for (int i = 0; i < records.length; ++i) {
                System.out.println("****** Event Record " + i + " ******");
                System.out.println(records[i].toString());
            }
        }
        catch (Throwable ee) {
            ee.printStackTrace();
        }
    }
}

