/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class SyncFileWriter {
    SyncLine previous = null;
    String dccName;
    String dateModified;
    String[] extraHeaders;
    protected PrintWriter writer;

    public SyncFileWriter(String dccName, String filename) throws IOException {
        this(dccName, new PrintWriter(new BufferedWriter(new FileWriter(filename))));
    }

    public SyncFileWriter(String dccName, PrintWriter writer) {
        this(dccName, SyncLine.dateToString(new Date()), new String[0], writer);
    }

    public SyncFileWriter(String dccName, String dateModified, PrintWriter writer) {
        this(dccName, dateModified, new String[0], writer);
    }

    public SyncFileWriter(String dccName, String dateModified, String[] extraHeaders, PrintWriter writer) {
        this.dccName = dccName;
        this.dateModified = dateModified;
        this.extraHeaders = extraHeaders;
        this.writer = writer;
        writer.println(new SyncFile(dccName, dateModified, extraHeaders).getHeaderLine());
    }

    public void appendAll(SyncFile sFile) {
        this.appendAll(sFile, true);
    }

    public void appendAll(SyncFile sFile, boolean consolidate) {
        for (SyncLine line : sFile.getSyncLines()) {
            this.appendLine(line, consolidate);
        }
    }

    public void appendLine(SyncLine line) {
        this.appendLine(line, true);
    }

    public void appendLine(SyncLine line, boolean consolidate) {
        if (consolidate) {
            if (this.previous == null) {
                this.previous = line;
            } else if (this.previous.isContiguous(line, 0.01f)) {
                this.previous = this.previous.concat(line);
            } else {
                this.writer.println(this.previous.formatLine());
                this.previous = line;
            }
        } else {
            this.writer.println(line.formatLine());
        }
    }

    public void close() {
        if (this.writer != null) {
            this.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void flush() {
        if (this.writer != null) {
            if (this.previous != null) {
                this.writer.println(this.previous.formatLine());
                this.previous = null;
            }
            this.writer.flush();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

