/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.StringMSeedQueryReader;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class WaveServer
extends StringMSeedQueryReader {
    int reqId = 1;
    String host;
    int port;
    int recordSizeExp = 12;
    boolean doSteim1 = false;
    Socket socket;
    PrintWriter out;
    DataInputStream in;
    int timeoutSeconds = 60;
    public static final int DEFAULT_TIMEOUT_SECONDS = 60;
    boolean verbose = false;

    WaveServer(PrintWriter out, DataInputStream in) {
        this.out = out;
        this.in = in;
    }

    public WaveServer(String host, int port) {
        this(host, port, 60);
    }

    public WaveServer(String host, int port, int timeoutSeconds) {
        this.host = host;
        this.port = port;
        this.timeoutSeconds = timeoutSeconds;
    }

    public List<MenuItem> getMenu() throws IOException {
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        String nextReqId = this.getNextRequestId();
        PrintWriter socketOut = this.getOut();
        socketOut.println("MENU: " + nextReqId + " SCNL");
        String all = new BufferedReader(new InputStreamReader(this.getIn())).readLine();
        String[] sections = all.split("  ");
        for (int i = 1; i < sections.length; ++i) {
            String[] cols = sections[i].split(" +");
            String pin = cols[0];
            String s = cols[1];
            String c = cols[2];
            String n = cols[3];
            String l = "";
            int locOffset = 0;
            if (cols.length == 8) {
                l = cols[4];
                locOffset = 1;
            }
            String start = cols[locOffset + 4];
            String end = cols[locOffset + 5];
            String dataType = cols[locOffset + 6];
            MenuItem item = new MenuItem(n, s, l, c, Double.parseDouble(start), Double.parseDouble(end), Integer.parseInt(pin), dataType);
            result.add(item);
        }
        return result;
    }

    public List<TraceBuf2> getTraceBuf(String network, String station, String location, String channel, Date start, Date end) throws IOException {
        String cmd = this.createQuery(network, station, location, channel, start, end);
        return this.getTraceBuf(cmd);
    }

    public List<TraceBuf2> getTraceBuf(String cmd) throws IOException {
        ArrayList<TraceBuf2> ans = new ArrayList<TraceBuf2>();
        if (this.isVerbose()) {
            System.out.println("send cmd: " + cmd);
        }
        PrintWriter socketOut = this.getOut();
        socketOut.println(cmd);
        socketOut.flush();
        this.getIn().mark(64);
        DataInputStream dataIn = this.getIn();
        for (int nRead = 0; dataIn.available() > 0 && nRead < 64; ++nRead) {
            System.out.print((char)dataIn.read());
        }
        this.in.reset();
        String all = dataIn.readLine();
        if (this.isVerbose()) {
            System.out.println("response: " + all);
        }
        String[] splitLine = all.split(" ");
        int byteLengthIndex = 10;
        if ("F".equals(splitLine[6])) {
            int numBytes = Integer.parseInt(splitLine[byteLengthIndex]);
            int totSize = 0;
            while (totSize < numBytes) {
                if (this.verbose) {
                    System.out.println("Read next traceBuf2: read bytes" + totSize + " < " + numBytes + " total bytes");
                }
                byte[] headerByte = new byte[64];
                this.in.readFully(headerByte);
                String dataType = TraceBuf2.extractDataType(headerByte);
                boolean swapBytes = TraceBuf2.isSwapBytes(dataType);
                int numSamples = TraceBuf2.extractNumSamples(headerByte, swapBytes);
                int sampSize = TraceBuf2.getSampleSize(dataType);
                byte[] dataBuf = new byte[numSamples * sampSize];
                dataIn.readFully(dataBuf);
                byte[] allTraceBuf = new byte[headerByte.length + dataBuf.length];
                System.arraycopy(headerByte, 0, allTraceBuf, 0, headerByte.length);
                System.arraycopy(dataBuf, 0, allTraceBuf, headerByte.length, dataBuf.length);
                TraceBuf2 tb = new TraceBuf2(allTraceBuf);
                totSize += tb.getSize();
                if (this.isVerbose()) {
                    System.out.println("TraceBuf received: " + tb);
                }
                ans.add(tb);
            }
        }
        return ans;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected Socket getSocket() throws IOException {
        if (this.socket == null && this.host != null) {
            this.socket = new Socket(this.getHost(), this.getPort());
            this.socket.setSoTimeout(this.timeoutSeconds * 1000);
        }
        return this.socket;
    }

    public int getRecordSize() {
        return this.recordSizeExp;
    }

    public void setRecordSize(int recordSize) {
        if (recordSize > 255) {
            throw new IllegalArgumentException("Record size exponent cannot be larger than 255. 12 is SEED standard 4096.");
        }
        this.recordSizeExp = recordSize;
    }

    public boolean isDoSteim1() {
        return this.doSteim1;
    }

    public void setDoSteim1(boolean doSteim1) {
        this.doSteim1 = doSteim1;
    }

    public PrintWriter getOut() throws IOException {
        if (this.out == null && this.getSocket() != null) {
            this.out = new PrintWriter(this.getSocket().getOutputStream(), true);
        }
        return this.out;
    }

    public DataInputStream getIn() throws IOException {
        if (this.in == null && this.getSocket() != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.getSocket().getInputStream()));
        }
        return this.in;
    }

    public static int getDefaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public String createQuery(String network, String station, String location, String channel, Date begin, Date end) {
        String nextReqId = this.getNextRequestId();
        DecimalFormat df = new DecimalFormat("0.0###", new DecimalFormatSymbols(Locale.US));
        String cmd = "GETSCNLRAW: " + nextReqId + " " + station + " " + channel + " " + network + " " + (location == null ? "--" : location) + " " + df.format((double)begin.getTime() / 1000.0) + " " + df.format((double)end.getTime() / 1000.0);
        return cmd;
    }

    @Override
    public List<DataRecord> read(String query) throws IOException, SeisFileException, SeedFormatException {
        ArrayList<DataRecord> out = new ArrayList<DataRecord>();
        List<TraceBuf2> tbList = this.getTraceBuf(query);
        for (TraceBuf2 traceBuf2 : tbList) {
            if (this.verbose) {
                System.out.println("tracebuf2 " + traceBuf2.getNetwork() + "." + traceBuf2.getStation() + "." + traceBuf2.getLocId() + "." + traceBuf2.getChannel() + " " + traceBuf2.getStartDate() + " " + traceBuf2.getNumSamples());
            }
            List<DataRecord> mseed = this.doSteim1 ? traceBuf2.toMiniSeed(this.recordSizeExp, 10) : traceBuf2.toMiniSeedNoCompression(this.recordSizeExp);
            out.addAll(mseed);
        }
        return out;
    }

    String getNextRequestId() {
        return "" + this.reqId++;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

