/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.SteimFrameBlock;
import edu.iris.dmc.seedcodec.Utility;

public class Steim2 {
    public static int[] decode(byte[] b, int numSamples, boolean swapBytes, int bias) throws SteimException {
        if (b.length % 64 != 0) {
            throw new SteimException("encoded data length is not multiple of 64 bytes (" + b.length + ")");
        }
        int[] samples = new int[numSamples];
        int numFrames = b.length / 64;
        int current = 0;
        int start = 0;
        int end = 0;
        int firstData = 0;
        int lastValue = 0;
        for (int i = 0; i < numFrames; ++i) {
            int[] tempSamples = Steim2.extractSamples(b, i * 64, swapBytes);
            firstData = 0;
            if (i == 0) {
                lastValue = bias;
                start = tempSamples[1];
                end = tempSamples[2];
                firstData = 3;
                if (bias == 0) {
                    lastValue = start - tempSamples[3];
                }
            }
            for (int j = firstData; j < tempSamples.length && current < numSamples; ++current, ++j) {
                samples[current] = lastValue + tempSamples[j];
                lastValue = samples[current];
            }
        }
        if (current != numSamples) {
            throw new SteimException("Number of samples decompressed doesn't match number in header: " + current + " != " + numSamples);
        }
        return samples;
    }

    public static int[] decode(byte[] b, int numSamples, boolean swapBytes) throws SteimException {
        return Steim2.decode(b, numSamples, swapBytes, 0);
    }

    public static SteimFrameBlock encode(int[] samples, int frames) throws SteimException {
        return Steim2.encode(samples, frames, 0);
    }

    public static SteimFrameBlock encode(int[] samples, int frames, int bias) throws SteimException {
        return Steim2.encode(samples, frames, bias, samples.length);
    }

    public static SteimFrameBlock encode(int[] samples, int frames, int bias, int samplesLength) throws SteimException {
        int ndiff;
        if (samplesLength == 0) {
            throw new SteimException("samples array is zero size");
        }
        if (frames <= 0) {
            throw new SteimException("number of frames is not a positive value");
        }
        if (frames > 63) {
            throw new SteimException("cannot encode more than 63 frames, you asked for " + frames);
        }
        SteimFrameBlock frameBlock = new SteimFrameBlock(frames, 2);
        frameBlock.addEncodedWord(samples[0], 0, 0);
        frameBlock.addEncodedWord(samples[samplesLength - 1], 0, 0);
        int[] diff = new int[7];
        int[] minbits = new int[7];
        for (int sampleIndex = 0; sampleIndex < samplesLength; sampleIndex += ndiff) {
            int nibble;
            int submask;
            int bitmask;
            int points_remaining = 0;
            for (int i = 0; i < 7 && sampleIndex + i < samplesLength; ++i) {
                if (sampleIndex + i == 0) {
                    diff[0] = samples[0] - bias;
                } else {
                    diff[i] = samples[sampleIndex + i] - samples[sampleIndex + i - 1];
                }
                minbits[i] = Steim2.minBitsNeeded(diff[i]);
                ++points_remaining;
            }
            int nbits = Steim2.bitsForPack(minbits, points_remaining);
            switch (nbits) {
                case 4: {
                    ndiff = 7;
                    bitmask = 15;
                    submask = 2;
                    nibble = 3;
                    break;
                }
                case 5: {
                    ndiff = 6;
                    bitmask = 31;
                    submask = 1;
                    nibble = 3;
                    break;
                }
                case 6: {
                    ndiff = 5;
                    bitmask = 63;
                    submask = 0;
                    nibble = 3;
                    break;
                }
                case 8: {
                    ndiff = 4;
                    bitmask = 255;
                    submask = 0;
                    nibble = 1;
                    break;
                }
                case 10: {
                    ndiff = 3;
                    bitmask = 1023;
                    submask = 3;
                    nibble = 2;
                    break;
                }
                case 15: {
                    ndiff = 2;
                    bitmask = Short.MAX_VALUE;
                    submask = 2;
                    nibble = 2;
                    break;
                }
                case 30: {
                    ndiff = 1;
                    bitmask = 0x3FFFFFFF;
                    submask = 1;
                    nibble = 2;
                    break;
                }
                default: {
                    throw new SteimException("Unable to encode " + nbits + " bit difference in Steim2 format");
                }
            }
            int word = Steim2.steimPackWord(diff, nbits, ndiff, bitmask, submask);
            if (!frameBlock.addEncodedWord(word, ndiff, nibble)) continue;
            frameBlock.setXsubN(samples[sampleIndex + ndiff - 1]);
            break;
        }
        return frameBlock;
    }

    private static int minBitsNeeded(int diff) {
        int minbits = 0;
        minbits = diff >= -8 && diff < 8 ? 4 : (diff >= -16 && diff < 16 ? 5 : (diff >= -32 && diff < 32 ? 6 : (diff >= -128 && diff < 128 ? 8 : (diff >= -512 && diff < 512 ? 10 : (diff >= -16384 && diff < 16384 ? 15 : (diff >= -536870912 && diff < 0x20000000 ? 30 : 32))))));
        return minbits;
    }

    private static int bitsForPack(int[] minbits, int points_remaining) {
        if (points_remaining >= 7 && minbits[0] <= 4 && minbits[1] <= 4 && minbits[2] <= 4 && minbits[3] <= 4 && minbits[4] <= 4 && minbits[5] <= 4 && minbits[6] <= 4) {
            return 4;
        }
        if (points_remaining >= 6 && minbits[0] <= 5 && minbits[1] <= 5 && minbits[2] <= 5 && minbits[3] <= 5 && minbits[4] <= 5 && minbits[5] <= 5) {
            return 5;
        }
        if (points_remaining >= 5 && minbits[0] <= 6 && minbits[1] <= 6 && minbits[2] <= 6 && minbits[3] <= 6 && minbits[4] <= 6) {
            return 6;
        }
        if (points_remaining >= 4 && minbits[0] <= 8 && minbits[1] <= 8 && minbits[2] <= 8 && minbits[3] <= 8) {
            return 8;
        }
        if (points_remaining >= 3 && minbits[0] <= 10 && minbits[1] <= 10 && minbits[2] <= 10) {
            return 10;
        }
        if (points_remaining >= 2 && minbits[0] <= 15 && minbits[1] <= 15) {
            return 15;
        }
        if (points_remaining >= 1 && minbits[0] <= 30) {
            return 30;
        }
        return 32;
    }

    private static int steimPackWord(int[] diff, int nbits, int ndiff, int bitmask, int submask) {
        int val = 0;
        int i = 0;
        for (i = 0; i < ndiff; ++i) {
            val = val << nbits | diff[i] & bitmask;
        }
        if (submask != 0) {
            val |= submask << 30;
        }
        return val;
    }

    protected static int[] extractSamples(byte[] bytes, int offset, boolean swapBytes) {
        int nibbles = Utility.bytesToInt(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], swapBytes);
        int currNibble = 0;
        int dnib = 0;
        int[] temp = new int[106];
        int currNum = 0;
        block16: for (int i = 0; i < 16; ++i) {
            currNibble = nibbles >> 30 - i * 2 & 3;
            switch (currNibble) {
                case 0: {
                    if (offset != 0) continue block16;
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    continue block16;
                }
                case 1: {
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4]);
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4 + 1]);
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4 + 2]);
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4 + 3]);
                    continue block16;
                }
                case 2: {
                    int tempInt = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    dnib = tempInt >> 30 & 3;
                    switch (dnib) {
                        case 1: {
                            temp[currNum++] = tempInt << 2 >> 2;
                            continue block16;
                        }
                        case 2: {
                            temp[currNum++] = tempInt << 2 >> 17;
                            temp[currNum++] = tempInt << 17 >> 17;
                            continue block16;
                        }
                        case 3: {
                            temp[currNum++] = tempInt << 2 >> 22;
                            temp[currNum++] = tempInt << 12 >> 22;
                            temp[currNum++] = tempInt << 22 >> 22;
                            continue block16;
                        }
                    }
                    continue block16;
                }
                case 3: {
                    int tempInt = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    dnib = tempInt >> 30 & 3;
                    int diffCount = 0;
                    int bitSize = 0;
                    int headerSize = 0;
                    switch (dnib) {
                        case 0: {
                            headerSize = 2;
                            diffCount = 5;
                            bitSize = 6;
                            break;
                        }
                        case 1: {
                            headerSize = 2;
                            diffCount = 6;
                            bitSize = 5;
                            break;
                        }
                        case 2: {
                            headerSize = 4;
                            diffCount = 7;
                            bitSize = 4;
                            break;
                        }
                    }
                    if (diffCount <= 0) continue block16;
                    for (int d = 0; d < diffCount; ++d) {
                        temp[currNum++] = tempInt << headerSize + d * bitSize >> (diffCount - 1) * bitSize + headerSize;
                    }
                    continue block16;
                }
            }
        }
        int[] out = new int[currNum];
        System.arraycopy(temp, 0, out, 0, currNum);
        return out;
    }

    public static void main(String[] args) throws SteimException {
        byte[] b = new byte[64];
        for (int i = 0; i < 64; ++i) {
            b[i] = 0;
        }
        b[0] = 1;
        b[1] = -80;
        System.out.println(b[1]);
        b[2] = -1;
        b[3] = -1;
        b[4] = 0;
        b[5] = 0;
        b[6] = 0;
        b[7] = 0;
        b[8] = 0;
        b[9] = 0;
        b[10] = 0;
        b[11] = 0;
        b[12] = 1;
        b[13] = 2;
        b[14] = 3;
        b[15] = 0;
        b[16] = 1;
        b[17] = 1;
        b[18] = 0;
        b[19] = 0;
        b[20] = 0;
        b[21] = 1;
        b[22] = 0;
        b[23] = 0;
        int[] temp = Steim2.decode(b, 17, false);
    }
}

