/*
 * Decompiled with CFR 0.152.
 */
package com.isti.dhi2mseed;

import com.isti.dhi.DhiDataServer;
import com.isti.dhi.IChannelInfo;
import com.isti.dhi2mseed.SCNLFileReader;
import com.isti.dhi2mseed.Utils;
import com.ooc.CORBA.ORB;
import com.ooc.CORBA.ORBSingleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class DHI2mseed {
    public static final String PROGRAM_NAME = "DHI2mseed";
    public static final String VERSION_NUM_STR = "0.04";
    public static final String REVISION_STR = "DHI2mseed, Version 0.04";
    private static final String defaultScnlFileName = "scnl.txt";
    private static final String defaultOutputDirName = "data";
    private static final String defaultPropsFileName = null;
    private static final ORB dummyOocOrbObj = null;
    private static final ORBSingleton dummyOocSingObj = null;
    private static final String dateFormatPattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String dateFormatPatternDescriptionText = "yyyy-MM-ddTHH:mm:ss";
    private static final DateFormat dateFormat = Utils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final Map argsMap = new TreeMap();
    private static int maxArgLength = 0;
    public static final String directoryNameDescription = "directory";
    public static final String fileNameDescription = "file";
    public static final String DURATION_TIME_ARG = DHI2mseed.addArg("-duration", "minutes");
    public static final String END_TIME_ARG = DHI2mseed.addArg("-endtime", "yyyy-MM-ddTHH:mm:ss");
    public static final String EXIST_VALUES_DESCRIPTION;
    public static final String EXIST_ARG;
    public static final String SCNL_FILE_ARG;
    public static final String HELP_ARG;
    public static final String OUTPUT_DIR_ARG;
    public static final String PROPS_ARG;
    public static final String START_TIME_ARG;
    private boolean printHelpFlag = false;
    private String outputDirName = "data";
    private String propsFileName = defaultPropsFileName;
    private String scnlFileName = "scnl.txt";
    private static final String defaultFileExistValue = "ignore";
    private String fileExistValue = null;
    private final File scnlFile;
    private SCNLFileReader scnlFileReader;
    private final File outputDir;
    private final File fissuresPropsFile;
    private Date startTime = null;
    private Date endTime = null;
    private long durationMS = 0L;
    private String startTimeText = null;
    private String durationText = null;
    private String endTimeText = null;
    boolean timeErrorFlag = false;
    boolean errorFlag = false;

    private static String addArg(String arg, String valueDescription) {
        if (!arg.startsWith("-")) {
            throw new IllegalArgumentException();
        }
        if (argsMap.keySet().contains(arg)) {
            throw new IllegalArgumentException();
        }
        if (arg.length() > maxArgLength) {
            maxArgLength = arg.length();
        }
        argsMap.put(arg, valueDescription);
        return arg;
    }

    public DHI2mseed(String[] args) {
        System.out.println(REVISION_STR);
        for (int i = 0; i < args.length; ++i) {
            String valueArg;
            String currentArg = args[i];
            if (i + 1 < args.length) {
                valueArg = args[i + 1];
                if (valueArg.startsWith("-")) {
                    valueArg = null;
                } else {
                    ++i;
                }
            } else {
                valueArg = null;
            }
            if (currentArg.equals(EXIST_ARG)) {
                if (valueArg == null) {
                    this.fileExistValue = defaultFileExistValue;
                    continue;
                }
                this.fileExistValue = DhiDataServer.getFileExistValue(valueArg);
                if (this.fileExistValue != null) continue;
                System.err.println("Invalid parameter for \"" + EXIST_ARG + "\": " + valueArg);
                DhiDataServer.printFileExistValues(System.err);
                this.errorFlag = true;
                continue;
            }
            if (currentArg.equals(OUTPUT_DIR_ARG)) {
                if (valueArg == null) {
                    System.err.println("No value for " + currentArg);
                    this.errorFlag = true;
                    continue;
                }
                this.outputDirName = valueArg;
                continue;
            }
            if (currentArg.equals(PROPS_ARG)) {
                if (valueArg == null) {
                    System.err.println("No value for " + currentArg);
                    this.errorFlag = true;
                    continue;
                }
                this.propsFileName = valueArg;
                continue;
            }
            if (currentArg.equals(SCNL_FILE_ARG)) {
                if (valueArg == null) {
                    System.err.println("No value for " + currentArg);
                    this.errorFlag = true;
                    continue;
                }
                this.scnlFileName = valueArg;
                continue;
            }
            if (currentArg.equals(START_TIME_ARG)) {
                if (valueArg == null) {
                    System.err.println("No value for " + currentArg);
                    this.errorFlag = true;
                    continue;
                }
                this.startTimeText = valueArg;
                continue;
            }
            if (currentArg.equals(END_TIME_ARG)) {
                if (valueArg == null) {
                    System.err.println("No value for " + currentArg);
                    this.errorFlag = true;
                    continue;
                }
                this.endTimeText = valueArg;
                continue;
            }
            if (currentArg.equals(DURATION_TIME_ARG)) {
                if (valueArg == null) {
                    System.err.println("No value for " + currentArg);
                    this.errorFlag = true;
                    continue;
                }
                this.durationText = valueArg;
                continue;
            }
            if (currentArg.equals(HELP_ARG)) {
                this.printHelpFlag = true;
                continue;
            }
            System.err.println("Invalid argument: " + currentArg);
            this.errorFlag = true;
            this.printHelpFlag = true;
        }
        if (this.printHelpFlag) {
            System.out.println("Usage:");
            Iterator it = argsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != null) {
                    System.out.println(Utils.getString(entry.getKey(), maxArgLength + 3) + entry.getValue());
                    continue;
                }
                System.out.println(entry.getKey());
            }
            System.exit(this.errorFlag ? 1 : 0);
        }
        if (this.scnlFileName != null) {
            this.scnlFile = new File(this.scnlFileName);
            if (!this.scnlFile.canRead()) {
                System.err.println("Can not read SCNL file: " + this.scnlFileName);
                this.errorFlag = true;
            }
        } else {
            this.scnlFile = null;
            System.err.println("SCNL file not specified");
            this.errorFlag = true;
        }
        if (this.outputDirName != null) {
            this.outputDir = new File(this.outputDirName);
            if (!this.outputDir.isDirectory() && !this.outputDir.mkdirs()) {
                System.err.println("Output directory could not be created: " + this.outputDirName);
                this.errorFlag = true;
            }
        } else {
            this.outputDir = null;
            System.err.println("Output directory not specified");
            this.errorFlag = true;
        }
        if (this.propsFileName != null) {
            this.fissuresPropsFile = new File(this.propsFileName);
            if (!this.fissuresPropsFile.canRead()) {
                System.err.println("Can not read FISSURES/CORBA server properties file: " + this.propsFileName);
                this.errorFlag = true;
            }
        } else {
            this.fissuresPropsFile = null;
        }
        if (this.startTimeText == null && this.endTimeText == null && this.durationText == null) {
            GregorianCalendar calendar = new GregorianCalendar(Utils.GMT_TIME_ZONE);
            calendar.add(11, -1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.durationText = "60";
            this.startTimeText = dateFormat.format(calendar.getTime());
        }
        if (this.durationText != null) {
            try {
                double durationMinutes = Double.parseDouble(this.durationText);
                this.durationMS = (long)(durationMinutes * 60000.0);
            }
            catch (NumberFormatException ex) {
                this.errorFlag = true;
            }
        }
        if (this.startTimeText == null && this.endTimeText == null) {
            System.err.println("Start time and end not specified");
            this.errorFlag = true;
        }
        if (this.startTimeText != null) {
            this.startTime = this.parseDate(this.startTimeText, START_TIME_ARG);
        } else if (this.durationText == null && !this.errorFlag) {
            System.err.println("Start time or duration not specified");
            this.errorFlag = true;
        }
        if (this.endTimeText != null) {
            this.endTime = this.parseDate(this.endTimeText, END_TIME_ARG);
        } else if (this.durationText == null && !this.errorFlag) {
            System.err.println("End time or duration not specified");
            this.errorFlag = true;
        }
        if (!this.errorFlag) {
            if (this.startTimeText == null) {
                this.startTime = new Date(this.endTime.getTime() - this.durationMS);
            } else if (this.endTimeText == null) {
                this.endTime = new Date(this.startTime.getTime() + this.durationMS);
            }
            if (this.startTime == null) {
                System.err.println("Start time is null");
                this.errorFlag = true;
            }
            if (this.endTime == null) {
                System.err.println("End time is null");
            }
            try {
                this.scnlFileReader = new SCNLFileReader(this.scnlFile);
            }
            catch (FileNotFoundException ex) {
                System.err.println("Error opening SCNL file: " + this.scnlFile);
                this.errorFlag = true;
            }
        }
        if (this.timeErrorFlag) {
            System.err.println("Time format should be: yyyy-MM-ddTHH:mm:ss");
        }
        if (this.errorFlag) {
            System.exit(1);
        }
        if (this.fileExistValue == null) {
            this.fileExistValue = defaultFileExistValue;
        }
        try {
            IChannelInfo channelInfo;
            DhiDataServer dataServer = new DhiDataServer(this.fissuresPropsFile);
            while ((channelInfo = this.scnlFileReader.getNextChannelInfo()) != null) {
                dataServer.getSEEDFiles(channelInfo, this.startTime, this.endTime, this.outputDir, this.fileExistValue);
            }
        }
        catch (Exception ex) {
            System.err.println("Error writing SEED files: " + ex);
            System.exit(2);
        }
    }

    public static Date parseDate(String date) throws ParseException {
        return dateFormat.parse(date.replace('/', '-').replace(' ', 'T'));
    }

    public Date parseDate(String date, String argText) {
        try {
            return DHI2mseed.parseDate(date);
        }
        catch (ParseException ex) {
            System.err.println("Invalid value for \"" + argText + "\": " + date);
        }
        catch (Exception ex) {
            System.err.println("Invalid value for \"" + argText + "\": " + date + "\n" + ex);
        }
        this.timeErrorFlag = true;
        this.errorFlag = true;
        return null;
    }

    public static void main(String[] args) {
        try {
            new DHI2mseed(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < DhiDataServer.FILE_EXIST_VALUES.length; ++i) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(DhiDataServer.FILE_EXIST_VALUES[i]);
        }
        EXIST_VALUES_DESCRIPTION = "[" + sb.toString() + "]";
        EXIST_ARG = DHI2mseed.addArg("-exist", EXIST_VALUES_DESCRIPTION);
        SCNL_FILE_ARG = DHI2mseed.addArg("-f", "SCNLfile");
        HELP_ARG = DHI2mseed.addArg("-help", null);
        OUTPUT_DIR_ARG = DHI2mseed.addArg("-o", "outputdirectory");
        PROPS_ARG = DHI2mseed.addArg("-p", "propertiesfile");
        START_TIME_ARG = DHI2mseed.addArg("-starttime", dateFormatPatternDescriptionText);
    }
}

